/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.shelp.common.Language;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import utils.ssl.KeyStoreUtility;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class KeystoreDescriptionPanel {
    private GbPanel rootComponent = new GbPanel();
    private CardLayout rootLayout = new CardLayout();

    public static KeyStoreUtility.KeystoreValidationResult getKeystoreValidationResult(RootPaneContainer rpc, File keystore, String storePassword, String keyPassword) throws KeyStoreException, KeyStoreUtility.UnableToLoadCACertsException, InvalidKeystoreException {
        KeyStore store = null;
        boolean loadedKeystore = false;
        String explanation = null;
        try {
            store = KeyStoreUtility.openKeystore(keystore, storePassword, keyPassword);
            loadedKeystore = true;
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
            explanation = Language.get("INCORRECT_PASSWORD") + ".";
        }
        catch (IOException e) {
            explanation = e.getMessage();
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
            explanation = Language.get("KEYSTORE_PROBLEM_CERTS") + ".";
        }
        if (explanation != null) {
            throw new InvalidKeystoreException(explanation);
        }
        return KeyStoreUtility.validateKeystore(store);
    }

    public static void showDescriptionPanel(RootPaneContainer rpc, File keystore, String storePassword, String keyPassword) {
        try {
            KeyStoreUtility.KeystoreValidationResult validateKeystore = KeystoreDescriptionPanel.getKeystoreValidationResult(rpc, keystore, storePassword, keyPassword);
            KeystoreDescriptionPanel.showValidationResult(rpc, validateKeystore);
        }
        catch (InvalidKeystoreException e) {
            String explanation = e.getMessage();
            String error = "<html>" + Language.get("UNABLE_TO_LOAD_KEYSTORE") + ".";
            if (explanation != null) {
                error = error + "<BR><BR>" + explanation;
            }
            SHGlassOptionPane.showErrorDialog((RootPaneContainer)rpc, (String)error, (String)Language.get("UNABLE_TO_LOAD_KEYSTORE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (KeyStoreUtility.UnableToLoadCACertsException e) {
            e.printStackTrace();
        }
    }

    public static void showValidationResult(RootPaneContainer rpc, KeyStoreUtility.KeystoreValidationResult validateKeystore) {
        KeystoreDescriptionPanel panel = new KeystoreDescriptionPanel(validateKeystore);
        panel.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10));
        Dimension d = panel.getRootComponent().getPreferredSize();
        PanelGlassDialog glassDialog = new PanelGlassDialog(rpc, Language.get("CERTIFICATE_CHAIN"), d.width + 200, Language.get("CLOSE"), null);
        glassDialog.setContentPanel((JComponent)panel.getRootComponent());
        glassDialog.showDialog();
    }

    private String getAliasWithCertificateChain(KeyStoreUtility.KeystoreValidationResult result) {
        for (String alias : result.aliasToChain.keySet()) {
            KeyStoreUtility.CertificateChainSummary certificateChainSummary = result.aliasToChain.get(alias);
            if (certificateChainSummary == null || certificateChainSummary.certificates.size() <= 0) continue;
            return alias;
        }
        return result.aliasToChain.keySet().iterator().next();
    }

    public KeystoreDescriptionPanel(KeyStoreUtility.KeystoreValidationResult result) {
        HashMap<String, KeyStoreUtility.CertificateChainSummary> aliasToChain = result.aliasToChain;
        int Y = 0;
        this.rootComponent.setLayout((LayoutManager)this.rootLayout);
        String alias = this.getAliasWithCertificateChain(result);
        GbPanel aliasPanel = new GbPanel();
        KeyStoreUtility.CertificateChainSummary certificateChainSummary = aliasToChain.get(alias);
        ArrayList<KeyStoreUtility.CertificateSummary> certs = certificateChainSummary.certificates;
        GbPanel topPanel = new GbPanel();
        JLabel aliasLabel = new JLabel(alias);
        aliasLabel.setFont(SHStyle.largeFont);
        JWrapLabel isValidLabel = new JWrapLabel();
        JWrapLabel isSelfSigned = new JWrapLabel();
        JWrapLabel reasonLabel = new JWrapLabel();
        isSelfSigned.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
        reasonLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
        if (certificateChainSummary.isChainValidate) {
            isValidLabel.setText("<html>" + Language.get("CERT_IS_VALID"));
            isValidLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16"));
        } else {
            isValidLabel.setText("<html>" + Language.get("CERT_IS_NOT_VALID"));
            isValidLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
            if (certificateChainSummary.validateError != null) {
                reasonLabel.setText(certificateChainSummary.validateError + ".");
            }
        }
        if (certificateChainSummary.isSelfSigned) {
            isSelfSigned.setText("<html>" + Language.get("CERT_IS_SELF_SIGNED"));
        }
        int YY = 0;
        topPanel.add((Component)aliasLabel, 0, YY++, 1, 1, 1, 0, 17, 0);
        topPanel.add((Component)isValidLabel, 0, YY++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(10, 0, 0, 0));
        if (reasonLabel.getText().length() > 0) {
            topPanel.add((Component)reasonLabel, 0, YY++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(10, 0, 0, 0));
        }
        if (isSelfSigned.getText().length() > 0) {
            topPanel.add((Component)isSelfSigned, 0, YY++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(10, 0, 0, 0));
        }
        topPanel.add((Component)new JPanel(), 0, YY++, 1, 1, 1, 1, 17, 1);
        aliasPanel.add((Component)topPanel, 0, Y++, 1, Y, 1, 0, 10, 1, (Insets)new ScaledInsets(0, 5, 0, 5));
        JLabel title = new JLabel(Language.get("CERTIFICATE_CHAIN"));
        title.setFont(SHStyle.bitBiggerFont);
        aliasPanel.add((Component)title, 0, Y++, 1, 1, 0, 0, 10, 0, (Insets)new ScaledInsets(10, 0, 5, 0));
        ArrayList<CertificatePanel> panels = new ArrayList<CertificatePanel>();
        for (int i = 0; i < certs.size(); ++i) {
            CertificatePanel cPanel = new CertificatePanel(certs.get(i));
            if (i > 0) {
                aliasPanel.add((Component)new GroupLine(), 0, Y++, 1, 1, 0, 0, 10, 0);
            }
            aliasPanel.add((Component)((Object)cPanel), 0, Y++, 1, 1, 0, 0, 10, 0);
            panels.add(cPanel);
        }
        SwingUtil.setSizesToWidest(panels);
        aliasPanel.add((Component)new JPanel(), 0, Y++, 1, 1, 0, 100, 10, 1);
        this.rootComponent.add((Component)aliasPanel, (Object)alias);
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public static void main(String[] args) throws UnrecoverableKeyException, CertificateException, IOException, KeyStoreException, KeyStoreUtility.UnableToLoadCACertsException {
        Language.loadTranslations();
        String path = "/Users/gchristelis/Documents/workspace/Certificates/RapidSSL/Renewal_2016/shcodesignkeystore";
        KeyStore store = KeyStoreUtility.openKeystore(new File(path), "a6HkqQLrra152AfuGg66N2randomsh", "a6HkqQLrra152AfuGg66N2randomsh");
        if (store != null) {
            System.out.println("Got store " + store + ". Validating...");
            KeyStoreUtility.KeystoreValidationResult validateKeystore = KeyStoreUtility.validateKeystore(store);
            for (String alias : validateKeystore.aliasToChain.keySet()) {
                System.out.println("Alias: " + alias);
                KeyStoreUtility.CertificateChainSummary certificateChainSummary = validateKeystore.aliasToChain.get(alias);
                System.out.println("\tValid: " + certificateChainSummary.isChainValidate);
                System.out.println("\tSelf-Signed: " + certificateChainSummary.isSelfSigned);
                System.out.println("\tUnknown Types: " + certificateChainSummary.contansUnknownCertificateTypes);
            }
            SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
            KeystoreDescriptionPanel kdp = new KeystoreDescriptionPanel(validateKeystore);
            frame.getContentPane().add(kdp.getRootComponent());
            frame.setVisible(true);
        }
    }

    class CertificatePanel
    extends GbPanel {
        public CertificatePanel(KeyStoreUtility.CertificateSummary summary) {
            super(new ScaledInsets(2, 2, 2, 2));
            int Y = 0;
            this.add(new JLabel("<html><b>" + Language.get("SUBJECT") + ":</b> " + summary.subject), 0, Y++, 1, 1, 1, 1, 17, 0);
            this.add(new JLabel("<html><b>" + Language.get("VALID") + ":</b> " + summary.dateFrom + " " + Language.get("TRANSPORT_TO_TRANSPORT") + " " + summary.dateTo), 0, Y++, 1, 1, 1, 1, 17, 0);
            this.add(new JLabel("<html><b>" + Language.get("ISSUER") + ":</b> " + summary.issuer), 0, Y++, 1, 1, 1, 1, 17, 0);
            this.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createLineBorder((Color)new Color(120, 155, 198), (int)1), (Border)SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5)));
            this.setBackground(new Color(245, 245, 255));
        }
    }

    class GroupLine
    extends JPanel {
        GroupLine() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(new Color(133, 175, 237));
            g.fillRect(this.getWidth() / 2 - 2, 0, 4, this.getHeight());
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.height = 10;
            return dim;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dim = super.getMinimumSize();
            dim.height = 10;
            return dim;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension dim = super.getMinimumSize();
            dim.height = 10;
            return dim;
        }
    }

    public static class InvalidKeystoreException
    extends Exception {
        public InvalidKeystoreException(String message) {
            super(message);
        }
    }
}

