/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.CentralDebugging;
import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.images.LicenseIcon;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.LicenseSet;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.SHUpdateCheckDialog;
import com.aem.shelp.tech.TechServerConfig;
import com.aem.shelp.tech.TechServerConfigManager;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.admin.AdminServerVersion;
import com.aem.shelp.tech.admin.rows.AdminRow;
import com.aem.shelp.tech.admin.subsections.AdminBackup;
import com.aem.shelp.tech.admin.subsections.AdminRestore;
import com.aem.shelp.tech.admin.subsections.AdminSection;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.dataexport.AdminAPI;
import com.aem.shelp.tech.admin.subsections.dataexport.AdminCluster;
import com.aem.shelp.tech.admin.subsections.dataexport.AdminEmail;
import com.aem.shelp.tech.admin.subsections.dataexport.AdminEnterprise;
import com.aem.shelp.tech.admin.subsections.dataexport.AdminStatus;
import com.aem.shelp.tech.admin.subsections.gettingstarted.AdminBranding;
import com.aem.shelp.tech.admin.subsections.gettingstarted.AdminDiskCleanup;
import com.aem.shelp.tech.admin.subsections.gettingstarted.AdminLicense;
import com.aem.shelp.tech.admin.subsections.gettingstarted.AdminMemory;
import com.aem.shelp.tech.admin.subsections.gettingstarted.AdminPassword;
import com.aem.shelp.tech.admin.subsections.gettingstarted.AdminStatusTest;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminAutoForget;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminBlocked;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminFeatures;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminHostname;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminLanguage;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminNewSSL;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminPorts;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminRecovery;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminSSL;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminServerLog;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminWelcomePage;
import com.aem.shelp.tech.admin.subsections.serversettings.BusinessFeatureSet;
import com.aem.shelp.tech.admin.subsections.sessions.AdminCustomerDetails;
import com.aem.shelp.tech.admin.subsections.sessions.AdminDisclaimer;
import com.aem.shelp.tech.admin.subsections.sessions.AdminElevation;
import com.aem.shelp.tech.admin.subsections.sessions.AdminEndOfSession;
import com.aem.shelp.tech.admin.subsections.sessions.AdminQueuePassword;
import com.aem.shelp.tech.admin.subsections.sessions.AdminSessionSummary;
import com.aem.shelp.tech.admin.subsections.simulation.AdminSimulation;
import com.aem.shelp.tech.admin.subsections.technicians.AdminAuthentication;
import com.aem.shelp.tech.admin.subsections.technicians.AdminGroups;
import com.aem.shelp.tech.admin.subsections.technicians.AdminLDAP;
import com.aem.shelp.tech.admin.subsections.technicians.AdminRadius;
import com.aem.shelp.tech.admin.subsections.technicians.AdminTechPresence;
import com.aem.shelp.tech.admin.subsections.technicians.AdminTechRestrictions;
import com.aem.shelp.tech.admin.subsections.technicians.AdminTechnicians;
import com.aem.shelp.util.ErrorDialogs;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jwrapper.jwutils.swing.JWAutomatable;
import jwrapper.jwutils.swing.JWAutomate;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.SaverUtil;
import utils.progtools.StackTracer;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.icons.CircularProgressLabel;
import utils.swing.images.ImageLoader;
import utils.swing.sectionproperties.AllSectionsPanel;
import utils.swing.sectionproperties.Section;
import utils.switches.Switches;
import utils.switches.oem.OEMSwitches;

public class AdminPanel
extends AllSectionsPanel
implements JWAutomatable,
TechServerConfig.TechServerConfigListener {
    private static final boolean DEBUG_PRINT_CHANGES = true;
    public static LicenseSet LOADED_LICENSES = null;
    private final AdminSection statusSection;
    private JPanel savingLanelPanel;
    private CircularProgressLabel savingLabel;
    private ArrayList<AdminSection> allSections = new ArrayList();
    private AdminServerVersion serverPanel;
    private AdminRadius radiusPanel;
    private AdminEnterprise adminEnterprise;
    private AdminCluster adminCluster;
    private AdminSimulation adminSimulation;
    private AdminSection licenseSection;
    private SaverUtil saveUtil;
    private AdminSection backupSection;
    private AdminSection loginSecuritySection;
    private AdminSection emailSection;
    private final AdminSection serverLogSection;
    private boolean disableSaveListener = false;
    private boolean forceDisableSaveListener = false;
    private final AdminSection groupsSection;
    private AdminTechnicians techniciansPanel;
    private AdminGroups groupsPanel;
    private TechServerConfig serverConfig;
    private TechClient client;
    private OnDemandThreadPool onDemandThreadPool = new OnDemandThreadPool("AdminPanelSaver", 1, 1, 5);
    private SaverUtil.SaveListener saveListener = new SaverUtil.SaveListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performSave() {
            try {
                long start = System.currentTimeMillis();
                AdminPanel.this.setSavingLabelOn();
                Object object = AdminPanel.this.serverConfig.getLock();
                synchronized (object) {
                    final ServerConfig currentConfig = AdminPanel.this.serverConfig.getServerConfig();
                    System.out.println("[AdminPanel] Saving configuration now");
                    String oldSettings = currentConfig.printConfig();
                    String oldDisclaimer = currentConfig.disclaimer;
                    boolean forceSave = false;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            for (AdminSection section : AdminPanel.this.allSections) {
                                section.saveTo(currentConfig);
                            }
                        }
                    });
                    for (AdminSection section : AdminPanel.this.allSections) {
                        if (forceSave || !section.forceSave()) continue;
                        forceSave = true;
                    }
                    String newSettings = currentConfig.printConfig();
                    String newDisclaimer = currentConfig.disclaimer;
                    if (forceSave || AdminPanel.differ(oldSettings, newSettings, true) || AdminPanel.differ(oldDisclaimer, newDisclaimer, true)) {
                        System.out.println("[AdminPanel] There is a config change. Sending configuration to server now.");
                        if (CentralDebugging.PRINT_SERVER_CONFIG_ON_SAVE) {
                            System.out.println(currentConfig.printConfig());
                        }
                        AdminPanel.this.serverConfig.requestSave("Admin");
                    } else {
                        System.out.println("[AdminPanel] There is no config change. Skipping...");
                        TechServerConfigManager.INSTANCE.clearRequestedSaveConfigInstanceID();
                    }
                    for (AdminSection section : AdminPanel.this.allSections) {
                        section.saveComplete(currentConfig);
                    }
                }
                long timeTaken = System.currentTimeMillis() - start;
                if (timeTaken > 500L) {
                    AdminPanel.this.setSavingLabelOff();
                } else {
                    Timer timer = new Timer((int)(500L - timeTaken), new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AdminPanel.this.setSavingLabelOff();
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
            catch (Throwable t) {
                System.out.println("[AminPanel] SEVERE ERROR: unable to save server configuration");
                t.printStackTrace();
                AdminPanel.this.setSavingLabelError(t);
            }
        }
    };

    public AdminPanel() {
        AdminRow serverSettingsRows;
        AdminSection integrationsSection;
        AdminRow gettingStartedRow;
        this.savingLanelPanel = new JPanel(new GridLayout(1, 1));
        SwingUtil.setWidth((JComponent)this.savingLanelPanel, (int)SimpleHelpLookAndFeel.scale((int)48));
        this.setRightContents(this.savingLanelPanel);
        this.savingLabel = SHProgressIcons.getCircularInfiniteLabel(SHProgressIcons.SIZE_24);
        this.savingLabel.setToolTipText(Language.get("PLEASE_WAIT_SAVING"));
        this.saveUtil = new SaverUtil("AdminPanel", 1000, this.saveListener, false);
        this.serverPanel = new AdminServerVersion(this);
        this.allSectionsPanel.add((Component)this.serverPanel.getRootComponent(), 0, this.allSectionsPanel.getComponentCount(), 1, 1, 1, 0, 17, 2);
        AdminSection passwordSection = new AdminSection(new AdminPassword(), ImageLoader.getImageIcon((String)"images/svg/general/lock.svg,48"));
        this.allSections.add(passwordSection);
        this.licenseSection = new AdminSection(new AdminLicense(), LicenseIcon.getLicenseIcon(1, true));
        this.allSections.add(this.licenseSection);
        AdminSection brandingSection = null;
        if (OemBranding.OEM_IS_SH) {
            brandingSection = new AdminSection(new AdminBranding(), OEMSwitches.DARK_THEME ? ImageLoader.getImageIconLighter((String)"images/svg/general/palette.svg,48") : ImageLoader.getImageIcon((String)"images/svg/general/palette.svg,48"));
            this.allSections.add(brandingSection);
        }
        this.statusSection = new AdminSection(new SubSection[]{new AdminStatusTest(), new AdminMemory(), new AdminDiskCleanup()}, ImageLoader.getImageIcon((String)"images/svg/general/heartbeat.svg,48"), Language.get("SERVER_STATUS_TEST_2"));
        this.allSections.add(this.statusSection);
        if (OemBranding.OEM_IS_SH) {
            gettingStartedRow = new AdminRow(this, new Section[]{passwordSection, this.licenseSection, brandingSection, this.statusSection}, Language.get("ADMIN_ROW_STARTED"));
            this.addSectionRow(gettingStartedRow);
        } else {
            gettingStartedRow = new AdminRow(this, new Section[]{passwordSection, this.licenseSection, this.statusSection}, Language.get("ADMIN_ROW_STARTED"));
            this.addSectionRow(gettingStartedRow);
        }
        this.techniciansPanel = new AdminTechnicians();
        this.groupsPanel = new AdminGroups(this);
        AdminSection techniciansSection = new AdminSection(this.techniciansPanel, ImageLoader.getImageIcon((String)"images/svg/users/technician.svg,48"));
        this.allSections.add(techniciansSection);
        this.groupsSection = new AdminSection(this.groupsPanel, ImageLoader.getImageIcon((String)"images/svg/users/group.svg,48"));
        this.allSections.add(this.groupsSection);
        this.radiusPanel = new AdminRadius();
        this.loginSecuritySection = new AdminSection(new SubSection[]{new AdminTechRestrictions(), new AdminAuthentication(this), new AdminLDAP(), this.radiusPanel}, ImageLoader.getImageIcon((String)"images/svg/security/key.svg,48"), Language.get("ADMIN_LOGIN_SECURITY"));
        this.allSections.add(this.loginSecuritySection);
        AdminRow techniciansRows = new AdminRow(this, new Section[]{techniciansSection, this.groupsSection, this.loginSecuritySection}, Language.get("ADMIN_ROW_TECHNICIANS"));
        this.addSectionRow(techniciansRows);
        AdminSection sessionFeaturesSection = new AdminSection(new SubSection[]{new AdminDisclaimer(), new AdminTechPresence(), new AdminQueuePassword(), new AdminElevation()}, ImageLoader.getImageIcon((String)"images/svg/general/help.svg,48"), Language.get("ADMIN_SESSION_FEATURES"));
        this.allSections.add(sessionFeaturesSection);
        AdminSection customerDetailsSection = new AdminSection(new AdminCustomerDetails(), ImageLoader.getImageIcon((String)"images/svg/users/profile.svg,48"));
        this.allSections.add(customerDetailsSection);
        AdminSection endOfSession = new AdminSection(new SubSection[]{new AdminEndOfSession(), new AdminSessionSummary()}, ImageLoader.getImageIcon((String)"images/svg/general/disconnect.svg,48"), Language.get("POST_SESSION_TAB"));
        this.allSections.add(endOfSession);
        AdminRow sessionsRows = new AdminRow(this, new Section[]{sessionFeaturesSection, customerDetailsSection, endOfSession}, Language.get("ADMIN_ROW_SESSIONS"));
        this.addSectionRow(sessionsRows);
        SubSection[] featureSections = OemBranding.OEM_IS_SH ? new SubSection[]{new AdminLanguage(), new AdminFeatures(), new BusinessFeatureSet(), new AdminWelcomePage()} : new SubSection[]{new AdminLanguage(), new AdminFeatures(), new AdminWelcomePage()};
        AdminSection serverFeaturesSection = new AdminSection(featureSections, ImageLoader.getImageIcon((String)"images/svg/general/switches.svg,48"), Language.get("ADMIN_SERVER_FEATURES"));
        this.allSections.add(serverFeaturesSection);
        AdminSection networkSection = new AdminSection(new SubSection[]{new AdminHostname(), new AdminPorts(), Switches.SH_Lets_Encrypt_Support ? new AdminNewSSL() : new AdminSSL()}, ImageLoader.getImageIcon((String)"images/svg/computing/network.svg,48"), Language.get("ADMIN_NETWORK_SETTINGS"));
        this.allSections.add(networkSection);
        this.serverLogSection = new AdminSection(AdminServerLog.getInstance(), ImageLoader.getImageIcon((String)"images/svg/files-folders/text.svg,48"));
        this.allSections.add(this.serverLogSection);
        SubSection[] advancedSubSections = Switches.SH_autoForgetServices ? new SubSection[]{new AdminRecovery(), new AdminAutoForget(), new AdminBlocked()} : new SubSection[]{new AdminRecovery(), new AdminBlocked()};
        AdminSection advancedSection = new AdminSection(advancedSubSections, ImageLoader.getImageIcon((String)"images/svg/security/shield.svg,48"), Language.get("ADMIN_ADVANCED_SECTION"));
        this.allSections.add(advancedSection);
        AdminRow serverSettingsRows2 = new AdminRow(this, new Section[]{serverFeaturesSection, networkSection, this.serverLogSection, advancedSection}, Language.get("ADMIN_ROW_SERVER_SETTINGS"));
        this.addSectionRow(serverSettingsRows2);
        this.emailSection = new AdminSection(new AdminEmail(), ImageLoader.getImageIcon((String)"images/svg/computing/email.svg,48"));
        this.allSections.add(this.emailSection);
        if (Switches.API) {
            integrationsSection = new AdminSection(new SubSection[]{new AdminAPI(), new AdminStatus()}, ImageLoader.getImageIcon((String)"images/svg/computing/window-code.svg,48"), Language.get("INTEGRATIONS"));
            this.allSections.add(integrationsSection);
        } else {
            integrationsSection = new AdminSection(new AdminStatus(), ImageLoader.getImageIcon((String)"images/svg/computing/window-code.svg,48"));
            this.allSections.add(integrationsSection);
        }
        this.adminEnterprise = new AdminEnterprise();
        AdminSection entPageSection = new AdminSection(this.adminEnterprise, OEMSwitches.DARK_THEME ? ImageLoader.getImageIconLighter((String)"images/svg/computing/monolith.svg,48") : ImageLoader.getImageIcon((String)"images/svg/computing/monolith.svg,48"));
        this.allSections.add(entPageSection);
        this.adminCluster = new AdminCluster();
        AdminSection clusterPageSection = new AdminSection(this.adminCluster, ImageLoader.getImageIcon((String)"images/svg/computing/clustering.svg,48"));
        this.allSections.add(clusterPageSection);
        this.adminSimulation = new AdminSimulation();
        AdminSection simulationPageSection = new AdminSection(this.adminSimulation, OEMSwitches.DARK_THEME ? ImageLoader.getImageIconLighter((String)"images/svg/computing/design-color_code-editor.svg,48") : ImageLoader.getImageIcon((String)"images/svg/computing/design-color_code-editor.svg,48"));
        if (Switches.SH_enterpriseSimulations) {
            this.allSections.add(simulationPageSection);
            serverSettingsRows = new AdminRow(this, new Section[]{this.emailSection, integrationsSection, entPageSection, clusterPageSection, simulationPageSection}, Language.get("ADMIN_ROW_SERVER_SETTINGS"));
            this.addSectionRow(serverSettingsRows);
        } else {
            serverSettingsRows = new AdminRow(this, new Section[]{this.emailSection, integrationsSection, entPageSection, clusterPageSection}, Language.get("ADMIN_ROW_SERVER_SETTINGS"));
            this.addSectionRow(serverSettingsRows);
        }
        this.backupSection = Switches.SH_allowRestoreFromBackup ? new AdminSection(new SubSection[]{new AdminBackup(this), new AdminRestore(this)}, null, Language.get("ADMIN_BACKUP_TITLE")) : new AdminSection(new AdminBackup(this), null);
        this.finish();
    }

    public void switchToBackupSection() {
        this.selectSection(this.backupSection);
    }

    public void switchToAdministrationTabMemoryConfig() {
        this.selectSection(this.statusSection);
    }

    public void switchToTechnicianGroup(TechGroup group) {
        this.groupsPanel.selectGroup(group);
        this.selectSection(this.groupsSection);
    }

    public void switchToLoginSecuritySection() {
        this.selectSection(this.loginSecuritySection);
    }

    public void switchToEmailSection() {
        this.selectSection(this.emailSection);
    }

    @Override
    public void initBackButton() {
        this.back.setText(Language.get("ALL_SETTINGS"));
        this.back.setIcon(ImageLoader.getImageIcon((String)"images/svg/arrows/left.svg,16"));
    }

    public void setTechClient(TechClient client, MachineTreeModel model) {
        this.client = client;
        TechServerConfig.INSTANCE.addTechServerConfigListener(this);
        this.serverConfig = TechServerConfig.INSTANCE;
        this.techniciansPanel.setMachineTreeModel(model);
        this.groupsPanel.setMachineTreeModel(model);
        this.serverPanel.setTechClient(client);
        this.backupSection.setTechClient(client);
        for (AdminSection section : this.allSections) {
            section.setTechClient(client);
        }
        for (AdminSection section : this.allSections) {
            section.setAdminPanel(this);
            section.setupSaveListeners();
        }
        if (AdminBackup.INSTANCE != null) {
            new AdminBackup.CheckBackupThread(AdminBackup.INSTANCE).start();
        }
        if (TechServerConfig.INSTANCE.hasBeenFetched()) {
            this.loadConfig();
        }
    }

    public void loadConfig() {
        AdminGroups.INSTANCE.reloadTwoTierEmailDefaults();
        AdminAuthentication.INSTANCE.reloadTwoTierEmailDefaults();
        AdminStatusTest.INSTANCE.setServerOSIsWindows(this.serverConfig.isWindows());
        new Thread(){

            @Override
            public void run() {
                if (AdminBranding.INSTANCE != null) {
                    try {
                        AdminBranding.INSTANCE.fetchBrandingSettings();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
        LicenseSet licenseSet = this.client.getServerLicenses();
        if (licenseSet == null) {
            AdminLicense.INSTANCE.setLicenses(null);
            this.serverPanel.setLicenses(null);
            SHUpdateCheckDialog.setLicenses(null);
            LOADED_LICENSES = null;
            this.radiusPanel.licenseChanged();
        } else {
            AdminLicense.INSTANCE.setLicenses(licenseSet);
            this.serverPanel.setLicenses(licenseSet);
            SHUpdateCheckDialog.setLicenses(licenseSet);
            LOADED_LICENSES = licenseSet;
            this.radiusPanel.licenseChanged();
            this.adminEnterprise.licenseChanged();
            this.adminCluster.licenseChanged();
            this.adminSimulation.licenseChanged();
            boolean isTrial = licenseSet.isTrial();
            this.licenseSection.setLargeIcon(LicenseIcon.getLicenseIcon(this.client.getSessionLimit(), isTrial));
        }
        this.loadProperties();
    }

    public void peersChanged() {
        try {
            this.adminEnterprise.peersChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateSessionLimit() {
        try {
            boolean isTrial = LOADED_LICENSES.isTrial();
            this.licenseSection.setLargeIcon(LicenseIcon.getLicenseIcon(this.client.getSessionLimit(), isTrial));
            this.adminEnterprise.updateSessionLimit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromConfigOnEDT(final ServerConfig config) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AdminPanel.this.loadFromConfigOnEDT(config);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            this.forceDisableSaveListener = true;
            for (AdminSection section : this.allSections) {
                section.loadFrom(config);
            }
        }
        finally {
            this.forceDisableSaveListener = false;
        }
    }

    public void disableSaves() {
        this.disableSaveListener = true;
    }

    public void enableSaves() {
        this.disableSaveListener = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() {
        Object object = this.serverConfig.getLock();
        synchronized (object) {
            ServerConfig config = this.serverConfig.getServerConfig();
            this.loadFromConfigOnEDT(config);
        }
    }

    public void requestASave(String actionType) {
        this.requestASave(actionType, false);
    }

    public void requestASave(final String actionType, final boolean immediate) {
        boolean hasError = false;
        for (AdminSection section : this.allSections) {
            if (!section.hasError()) continue;
            hasError = true;
            break;
        }
        if (!hasError) {
            if (!this.forceDisableSaveListener && !this.disableSaveListener) {
                Runnable worker = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = TechServerConfigManager.INSTANCE.SERVER_CONFIG_LOCK;
                        synchronized (object) {
                            TechServerConfigManager.INSTANCE.markConfigIDToBeSaved();
                            System.out.println("[AdminPanel] Save requested (" + actionType + ")");
                            if (immediate) {
                                AdminPanel.this.saveUtil.saveNow();
                            } else {
                                AdminPanel.this.saveUtil.queueSave();
                            }
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    this.onDemandThreadPool.runAsync(worker);
                } else {
                    worker.run();
                }
            }
        } else {
            System.out.println("[AdminPanel] Skipping save due to config error");
            this.saveUtil.cancelSave();
        }
    }

    public void deferSave() {
        this.saveUtil.deferSave();
    }

    public static boolean differ(String s1, String s2, boolean showDiff) {
        int s2Index;
        if (!showDiff) {
            return s1.compareTo(s2) != 0;
        }
        char[] s1Chars = s1.toCharArray();
        char[] s2Chars = s2.toCharArray();
        int s1Index = 0;
        for (s2Index = 0; s1Index < s1Chars.length && s2Index < s2Chars.length && s1Chars[s1Index] == s2Chars[s2Index]; ++s1Index, ++s2Index) {
        }
        if (s1Index == s1Chars.length && s2Index == s2Chars.length) {
            return false;
        }
        int changePoint = s1Index;
        s1Index = s1Chars.length - 1;
        for (s2Index = s2Chars.length - 1; s1Index > changePoint && s2Index > changePoint && s1Chars[s1Index] == s2Chars[s2Index]; --s1Index, --s2Index) {
        }
        return true;
    }

    public void setLastBackedUp(String lastBackupDate) {
        if (lastBackupDate == null) {
            this.serverPanel.setBackupButtonRed(true);
        } else {
            this.serverPanel.setBackupButtonRed(false);
        }
    }

    public boolean grabScreenShotsOfChildren() {
        return true;
    }

    public Component[] getChildComponents() {
        this.specificSectionPanel.setSize(this.getSize());
        ArrayList<JComponent> children = new ArrayList<JComponent>();
        for (AdminSection section : this.allSections) {
            JComponent component = section.getRootComponent();
            component.setSize(this.specificSectionPanel.getSize());
            component.setPreferredSize(this.specificSectionPanel.getSize());
            JWAutomate.layoutComponent((Component)component);
            children.add(component);
        }
        return children.toArray(new Component[0]);
    }

    @Override
    public JComponent getRootComponent() {
        return super.getRootComponent();
    }

    @Override
    public void loadedNewConfig(ServerConfig config) {
    }

    @Override
    public void configMismatchHandled() {
    }

    @Override
    public void failedToBind(String[] failedAddresses) {
    }

    @Override
    public void serverConfigFetched() {
        System.out.println("[AdminPanel] Server Config Fetched");
        this.loadConfig();
    }

    @Override
    public void localServerConfigChanged(String sourceID) {
        if (!sourceID.equals("Admin")) {
            System.out.println("[AdminPanel] Server Config Changed");
            this.loadConfig();
        }
    }

    @Override
    public TechServerConfig.ServerConfigMismatchHandler configMismatch(String reason) {
        return new TechServerConfig.ServerConfigMismatchHandler(false, false);
    }

    public void saveIfRequired() {
        this.saveUtil.skipDelayIfSaveScheduled();
    }

    public void setSavingLabelOn() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdminPanel.this.savingLanelPanel.removeAll();
                AdminPanel.this.savingLanelPanel.add((Component)AdminPanel.this.savingLabel);
                AdminPanel.this.savingLabel.switchOn();
                AdminPanel.this.setRightContents(AdminPanel.this.savingLanelPanel);
            }
        });
    }

    public void setSavingLabelOff() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdminPanel.this.savingLanelPanel.removeAll();
                AdminPanel.this.savingLanelPanel.revalidate();
                AdminPanel.this.savingLanelPanel.repaint();
            }
        });
    }

    public void setSavingLabelError(final Throwable t) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdminPanel.this.savingLanelPanel.removeAll();
                JLabel warningLabel = new JLabel(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,24"));
                warningLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        ErrorDialogs.ErrorGlassDialog dialog = new ErrorDialogs.ErrorGlassDialog(SwingUtil.getRootPaneContainer((Component)AdminPanel.this.getRootComponent()), Language.get("FAILED_SAVE_MSG"), ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), true, false);
                        dialog.setText(Language.get("FAILED_SAVE_MSG"), null, StackTracer.getStacktrace((Throwable)t));
                        dialog.showDialog();
                    }
                });
                AdminPanel.this.savingLanelPanel.add(warningLabel);
                AdminPanel.this.savingLanelPanel.revalidate();
                AdminPanel.this.savingLanelPanel.repaint();
            }
        });
    }

    public void showOnlyTechConfig() {
        this.removeAll();
        this.add(this.techniciansPanel.getRootComponent());
        this.techniciansPanel.forceAtLeastOneGroupSelected();
        this.revalidate();
        this.repaint();
    }

    public void loadTechnicians(TechUser[] usersToAdminister, TechGroup[] groupsToAdminister) {
        this.techniciansPanel.loadTechnicians(usersToAdminister, groupsToAdminister);
    }

    public void removeGroupAssociatedWith(AppProfile app, boolean saveConfig) {
        this.groupsPanel.removeGroupAssociatedWith(app, saveConfig);
    }
}

