/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.utils;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.hierarchy.utils.TreeSelection;
import java.util.ArrayList;

public class MachineSelection
extends TreeSelection<MachineGroup, Machine> {
    public static final MachineSelection EMPTY = new MachineSelection();
    public int offlineCount = 0;
    public int availableCount = 0;
    public int needRestartCount = 0;
    public int needUpgradeCount = 0;
    public int monitored = 0;
    public int autoUpdating = 0;
    public int queuedStop = 0;
    public int queuedMigrate = 0;
    public int queuedRunTool = 0;
    public int supportsAutoUpdateCount = 0;
    public int supportMonitoring = 0;
    public int allowsMonitoring = 0;
    public int allowsScripting = 0;
    public int windows = 0;
    public int linux = 0;
    public int osx = 0;
    public int windows_offline = 0;
    public int linux_offline = 0;
    public int osx_offline = 0;
    public int supportsRestartAndReboot = 0;

    protected Machine[] initElementArray(int size) {
        return new Machine[size];
    }

    public Machine[] getAvailableMachines() {
        ArrayList<Machine> result = new ArrayList<Machine>();
        for (Machine machine : this) {
            if (!machine.isAvailable()) continue;
            result.add(machine);
        }
        return result.toArray(new Machine[0]);
    }

    public Machine[] getScriptableMachines(boolean online) {
        ArrayList<Machine> result = new ArrayList<Machine>();
        for (Machine machine : this) {
            if (!machine.allowScripting() || online != machine.isAvailable()) continue;
            result.add(machine);
        }
        return result.toArray(new Machine[0]);
    }

    public Machine[] getOfflineMachines() {
        ArrayList<Machine> result = new ArrayList<Machine>();
        for (Machine machine : this) {
            if (machine.isAvailable()) continue;
            result.add(machine);
        }
        return result.toArray(new Machine[0]);
    }

    public Machine[] getMachinesAutoUpdating(boolean autoUpdating) {
        ArrayList<Machine> result = new ArrayList<Machine>();
        for (Machine machine : this) {
            if (machine.isAutoUpdating() != autoUpdating) continue;
            result.add(machine);
        }
        return result.toArray(new Machine[0]);
    }

    public int getAutoUpdatingCount() {
        return this.autoUpdating;
    }

    public Machine[] getUpgradeMachines() {
        ArrayList<Machine> result = new ArrayList<Machine>();
        for (Machine machine : this) {
            if (!machine.needsUpgrading()) continue;
            result.add(machine);
        }
        return result.toArray(new Machine[0]);
    }

    @Override
    protected void addMachineToStats(Machine m) {
        super.addMachineToStats(m);
        if (m.isAvailable()) {
            ++this.availableCount;
            if (m.needsRestarting()) {
                ++this.needRestartCount;
            } else if (m.needsUpgrading()) {
                ++this.needUpgradeCount;
            }
            if (m.isMonitored()) {
                ++this.monitored;
            }
            if (m.supportsRestartAndReboot()) {
                ++this.supportsRestartAndReboot;
            }
            if (m.supportsMonitoring()) {
                ++this.supportMonitoring;
                if (m.allowMonitoring()) {
                    ++this.allowsMonitoring;
                }
                if (m.allowScripting()) {
                    ++this.allowsScripting;
                }
            }
            if (m.getOsBaseType() == 0) {
                ++this.windows;
            } else if (m.getOsBaseType() == 2) {
                ++this.linux;
            } else if (m.getOsBaseType() == 1) {
                ++this.osx;
            }
        } else {
            ++this.offlineCount;
            if (m.getOsBaseType() == 0) {
                ++this.windows_offline;
            } else if (m.getOsBaseType() == 2) {
                ++this.linux_offline;
            } else if (m.getOsBaseType() == 1) {
                ++this.osx_offline;
            }
        }
        if (m.supportsAutoUpdating()) {
            ++this.supportsAutoUpdateCount;
        }
        if (m.isAutoUpdating()) {
            ++this.autoUpdating;
        }
        if (m.hasMigrateQueued()) {
            ++this.queuedMigrate;
        }
        if (m.hasRunToolQueued()) {
            ++this.queuedRunTool;
        }
        if (m.hasStopQueued()) {
            ++this.queuedStop;
        }
    }

    @Override
    protected void removeMachineFromStats(Machine m) {
        super.removeMachineFromStats(m);
        if (m.isAvailable()) {
            --this.availableCount;
            if (m.needsRestarting()) {
                --this.needRestartCount;
            } else if (m.needsUpgrading()) {
                --this.needUpgradeCount;
            }
            if (m.isMonitored()) {
                --this.monitored;
            }
            if (m.supportsMonitoring()) {
                --this.supportMonitoring;
                if (m.allowMonitoring()) {
                    --this.allowsMonitoring;
                }
                if (m.allowScripting()) {
                    --this.allowsScripting;
                }
            }
            if (m.getOsBaseType() == 0) {
                --this.windows;
            } else if (m.getOsBaseType() == 2) {
                --this.linux;
            } else if (m.getOsBaseType() == 1) {
                --this.osx;
            }
        } else {
            --this.offlineCount;
            if (m.getOsBaseType() == 0) {
                --this.windows_offline;
            } else if (m.getOsBaseType() == 2) {
                --this.linux_offline;
            } else if (m.getOsBaseType() == 1) {
                --this.osx_offline;
            }
        }
        if (m.supportsAutoUpdating()) {
            --this.supportsAutoUpdateCount;
        }
        if (m.isAutoUpdating()) {
            --this.autoUpdating;
        }
        if (m.hasMigrateQueued()) {
            --this.queuedMigrate;
        }
        if (m.hasRunToolQueued()) {
            --this.queuedRunTool;
        }
        if (m.hasStopQueued()) {
            --this.queuedStop;
        }
    }

    public int getTotalWindows() {
        return this.windows + this.windows_offline;
    }

    public int getTotalLinux() {
        return this.linux + this.linux_offline;
    }

    public int getTotalMacos() {
        return this.osx + this.osx_offline;
    }
}

