/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.service;

import com.aem.sgateway.common.AbstractServiceUtil;
import com.aem.sgateway.common.SGServiceUpdateUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.service.ServiceUIListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.animated.arrow.ArrowedProgressBar;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public abstract class AbstractSGServiceUI
implements AbstractField.ChangeListener,
TreeSelectionListener,
ActionListener {
    public static boolean SIMULATE_SG_SERVICE_ACTIONS = false;
    private GbPanel rootComponent = new GbPanel();
    private ActionMachinesThread actionThread = null;
    private JButton closeButton;
    private JButton actionButton;
    private Machine[] allMachines;
    private JLabel statusLabel = new JLabel();
    private ArrowedProgressBar progressBar = new ArrowedProgressBar();
    private JLabel machinePasswordLabel;
    private JLabel usernameLabel;
    private JLabel passwordLabel;
    private TextField machinePasswordField = new TextField(null, (AbstractField.ChangeListener)this, 7);
    private TextField usernameField = new TextField(null, (AbstractField.ChangeListener)this, 0);
    private TextField passwordField = new TextField(null, (AbstractField.ChangeListener)this, 7);
    private JLabel machinePasswordCountLabel = new JLabel();
    private JLabel credentialsCountLabel = new JLabel();
    private JLabel errorLabel = new JLabel(" ");
    private HashMap<String, GeneralInfoWrapper> map = new HashMap();
    private int needUpdatingCount;
    private int countNeedPassword;
    private int countNeedCredentials;
    private int countNeedBoth;
    private int countNeedNone;
    private int countAlreadyUpdating;
    private JLabel descriptionLabel;
    private TechClient client;
    private Machine[] selectedMachines;
    private ServiceUIListener listener;

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public AbstractSGServiceUI(TechClient client, Machine[] allMachines, ServiceUIListener listener) {
        this.listener = listener;
        this.allMachines = allMachines;
        this.client = client;
        for (int i = 0; i < allMachines.length; ++i) {
            GeneralInfoWrapper wrapper = new GeneralInfoWrapper();
            wrapper.info = allMachines[i];
            this.map.put(allMachines[i].getMachineID(), wrapper);
        }
        this.initUI();
    }

    public abstract String getMessageError();

    public abstract String getMessageBusy();

    public abstract String getMessageDone();

    public abstract String getActionButtonText();

    public abstract String getDialogTitle();

    public abstract String getDescriptionText();

    public abstract String getStatusText();

    public abstract AbstractServiceUtil getUpdateUtilFor(TechClient var1, Machine var2);

    private void initUI() {
        this.errorLabel.setForeground(SHStyle.ERROR_TEXT_COLOR);
        this.machinePasswordCountLabel.setFont(SHStyle.smallFont);
        this.credentialsCountLabel.setFont(SHStyle.smallFont);
        this.machinePasswordCountLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
        this.credentialsCountLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
        this.closeButton = new JButton(Language.get("FINISH"));
        this.actionButton = new JButton(this.getActionButtonText());
        this.actionButton.setEnabled(false);
        this.actionButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(SHStyle.EXAMPLE_TEXT_FONT_SIZE));
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(5, 5, 5, 5));
        int X = 0;
        SHButtonUI.makeButtonBlue((JButton)this.actionButton);
        buttonsPanel.add((Component)this.progressBar.getRootComponent(), X++, 0, 1, 1, 0, 0, 13, 3);
        buttonsPanel.add((Component)this.statusLabel, X++, 0, 1, 1, 100, 0, 17, 3);
        buttonsPanel.add((Component)this.actionButton, X++, 0, 1, 1, 0, 0, 13, 3);
        buttonsPanel.add((Component)this.closeButton, X++, 0, 1, 1, 0, 0, 13, 3);
        SwingUtil.setSizesToWidest((JComponent)this.closeButton, (JComponent)this.actionButton);
        JPanel configPanel = this.initConfigPanel();
        this.descriptionLabel = new JWrapLabel("<html>" + this.getDescriptionText() + "</html>");
        int Y = 0;
        this.rootComponent.add((Component)configPanel, 0, Y++, 1, 1, 1, 1, 10, 1);
        this.rootComponent.add((Component)buttonsPanel, 0, Y++, 1, 1, 1, 0, 10, 1);
    }

    protected abstract boolean askForMachinePassword();

    private JPanel initConfigPanel() {
        JPanel configPanel = new JPanel();
        GbPanelWrapper config = new GbPanelWrapper((Container)configPanel, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.errorLabel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        this.machinePasswordLabel = new JLabel(Language.get("UPDATE_SERVICE_MACHINE_PASSWORD"));
        this.usernameLabel = new JLabel(Language.get("UPDATE_SERVICE_USERNAME"));
        this.passwordLabel = new JLabel(Language.get("UPDATE_SERVICE_PASSWORD"));
        SwingUtil.setWidth((JComponent)this.machinePasswordField.getComponent(), (int)SimpleHelpLookAndFeel.scale((int)200));
        SwingUtil.setWidth((JComponent)this.usernameField.getComponent(), (int)SimpleHelpLookAndFeel.scale((int)200));
        SwingUtil.setWidth((JComponent)this.passwordField.getComponent(), (int)SimpleHelpLookAndFeel.scale((int)200));
        this.usernameField.getComponent().setEnabled(false);
        this.passwordField.getComponent().setEnabled(false);
        this.machinePasswordField.getComponent().setEnabled(false);
        this.actionButton.setEnabled(false);
        this.usernameLabel.setEnabled(false);
        this.passwordLabel.setEnabled(false);
        this.machinePasswordLabel.setEnabled(false);
        int Y = 0;
        config.add((Component)this.errorLabel, 0, Y++, 3, 1, 1, 0, 13, 2);
        if (this.askForMachinePassword()) {
            config.add((Component)this.machinePasswordLabel, 0, Y, 1, 1, 0, 0, 13, 0);
            config.add((Component)this.machinePasswordField.getComponent(), 1, Y, 1, 1, 0, 0, 17, 2);
            config.add((Component)this.machinePasswordCountLabel, 2, Y++, 1, 1, 1, 0, 17, 2);
        }
        config.add((Component)this.usernameLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        config.add((Component)this.usernameField.getComponent(), 1, Y, 1, 1, 0, 0, 17, 2);
        config.add((Component)this.credentialsCountLabel, 2, Y++, 1, 1, 1, 0, 17, 2);
        config.add((Component)this.passwordLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        config.add((Component)this.passwordField.getComponent(), 1, Y++, 1, 1, 0, 0, 17, 2);
        config.add((Component)new JPanel(), 0, Y++, 1, 1, 0, 1, 17, 1);
        return configPanel;
    }

    public void startAction() {
        this.actionButton.setEnabled(false);
        this.machinePasswordField.getComponent().setEnabled(false);
        this.usernameField.getComponent().setEnabled(false);
        this.passwordField.getComponent().setEnabled(false);
        if (this.actionThread != null) {
            this.actionThread.die();
        }
        this.actionThread = new ActionMachinesThread(this.allMachines);
        this.actionThread.start();
    }

    private void enableUpdateButtons() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractSGServiceUI.this.machinePasswordField.getComponent().setEnabled(true);
                AbstractSGServiceUI.this.usernameField.getComponent().setEnabled(true);
                AbstractSGServiceUI.this.passwordField.getComponent().setEnabled(true);
                boolean machinePasswordRequired = AbstractSGServiceUI.this.countNeedPassword > 0 || AbstractSGServiceUI.this.countNeedBoth > 0;
                AbstractSGServiceUI.this.machinePasswordField.getComponent().setEnabled(machinePasswordRequired);
                AbstractSGServiceUI.this.machinePasswordLabel.setEnabled(machinePasswordRequired);
                if (machinePasswordRequired) {
                    int total = AbstractSGServiceUI.this.countNeedPassword + AbstractSGServiceUI.this.countNeedBoth;
                    AbstractSGServiceUI.this.machinePasswordField.setExampleValue(Language.get("REQUIRED"));
                    if (total == 1) {
                        AbstractSGServiceUI.this.machinePasswordCountLabel.setText(total + " " + Language.get("PASSWORD_REQUIRED_BY"));
                    } else {
                        AbstractSGServiceUI.this.machinePasswordCountLabel.setText(total + " " + Language.get("PASSWORD_REQUIRED_BY_MULTIPLE"));
                    }
                } else {
                    AbstractSGServiceUI.this.machinePasswordCountLabel.setText("");
                    AbstractSGServiceUI.this.machinePasswordField.setExampleValue("");
                }
                boolean credentialsRequired = AbstractSGServiceUI.this.countNeedCredentials > 0 || AbstractSGServiceUI.this.countNeedBoth > 0;
                AbstractSGServiceUI.this.usernameField.getComponent().setEnabled(credentialsRequired);
                AbstractSGServiceUI.this.passwordField.getComponent().setEnabled(credentialsRequired);
                AbstractSGServiceUI.this.usernameLabel.setEnabled(credentialsRequired);
                AbstractSGServiceUI.this.passwordLabel.setEnabled(credentialsRequired);
                if (credentialsRequired) {
                    int total = AbstractSGServiceUI.this.countNeedCredentials + AbstractSGServiceUI.this.countNeedBoth;
                    if (total == 1) {
                        AbstractSGServiceUI.this.credentialsCountLabel.setText(total + " " + Language.get("CREDENTIALS_REQUIRED_BY"));
                    } else {
                        AbstractSGServiceUI.this.credentialsCountLabel.setText(total + " " + Language.get("CREDENTIALS_REQUIRED_BY_MULTIPLE"));
                    }
                    AbstractSGServiceUI.this.usernameField.setExampleValue(Language.get("REQUIRED"));
                } else {
                    AbstractSGServiceUI.this.credentialsCountLabel.setText("");
                    AbstractSGServiceUI.this.usernameField.setExampleValue("");
                    AbstractSGServiceUI.this.passwordField.setExampleValue("");
                }
                if (AbstractSGServiceUI.this.needUpdatingCount - AbstractSGServiceUI.this.countAlreadyUpdating == 0) {
                    AbstractSGServiceUI.this.actionButton.setEnabled(false);
                } else {
                    boolean canUpdateSome;
                    boolean bl = canUpdateSome = AbstractSGServiceUI.this.countNeedNone > 0;
                    if (!canUpdateSome) {
                        if (AbstractSGServiceUI.this.countNeedPassword > 0) {
                            boolean bl2 = canUpdateSome = AbstractSGServiceUI.this.machinePasswordField.getTextFieldValue().length() != 0;
                        }
                        if (!canUpdateSome && AbstractSGServiceUI.this.countNeedCredentials > 0) {
                            boolean bl3 = canUpdateSome = AbstractSGServiceUI.this.usernameField.getTextFieldValue().length() > 0;
                        }
                        if (!canUpdateSome && AbstractSGServiceUI.this.countNeedBoth > 0) {
                            canUpdateSome = AbstractSGServiceUI.this.machinePasswordField.getTextFieldValue().length() != 0 && AbstractSGServiceUI.this.usernameField.getTextFieldValue().length() > 0;
                        }
                    }
                    AbstractSGServiceUI.this.actionButton.setEnabled(canUpdateSome);
                }
            }
        });
    }

    public void setSelectedMachines(Machine[] machines) {
        this.selectedMachines = machines;
        this.checkUpdateButtonState();
    }

    private void checkUpdateButtonState() {
        GeneralInfoWrapper wrapper;
        this.needUpdatingCount = 0;
        this.countNeedPassword = 0;
        this.countNeedCredentials = 0;
        this.countNeedBoth = 0;
        this.countNeedNone = 0;
        this.countAlreadyUpdating = 0;
        if (this.selectedMachines == null) {
            this.setMessageLabel("", false);
            return;
        }
        if (this.selectedMachines.length == 1) {
            Machine info = this.selectedMachines[0];
            wrapper = this.map.get(info.getMachineID());
            if (wrapper.error) {
                if (wrapper.explanation != null) {
                    this.setMessageLabel(this.getMessageError() + ": " + wrapper.explanation, true);
                } else {
                    this.setMessageLabel(this.getMessageError() + ".", true);
                }
            } else if (wrapper.busyActioning) {
                this.setMessageLabel(this.getMessageBusy(), false);
                ++this.countAlreadyUpdating;
            } else if (wrapper.requiresCredentials || wrapper.requiresMachinePassword) {
                this.setMessageLabel(Language.get("UPDATE_UI_NEED_CREDENTIALS"), false);
            } else if (wrapper.actionedOk) {
                this.setMessageLabel(this.getMessageDone(), false);
            }
        } else {
            this.setMessageLabel(" ", false);
        }
        for (int i = 0; i < this.selectedMachines.length; ++i) {
            wrapper = this.map.get(this.selectedMachines[i].getMachineID());
            if (wrapper.actionedOk) continue;
            ++this.needUpdatingCount;
            if (wrapper.requiresCredentials && !wrapper.requiresMachinePassword) {
                ++this.countNeedCredentials;
            }
            if (wrapper.requiresMachinePassword && !wrapper.requiresCredentials) {
                ++this.countNeedPassword;
            }
            if (!wrapper.requiresCredentials && !wrapper.requiresMachinePassword) {
                ++this.countNeedNone;
            }
            if (!wrapper.requiresCredentials || !wrapper.requiresMachinePassword) continue;
            ++this.countNeedBoth;
        }
        this.enableUpdateButtons();
    }

    private void setMessageLabel(final String string, final boolean error) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (error) {
                    AbstractSGServiceUI.this.errorLabel.setForeground(SHStyle.ERROR_TEXT_COLOR);
                } else {
                    AbstractSGServiceUI.this.errorLabel.setForeground(UIManager.getColor("TextField.foreground"));
                }
                if (string.length() == 0) {
                    AbstractSGServiceUI.this.errorLabel.setVisible(false);
                } else {
                    AbstractSGServiceUI.this.errorLabel.setVisible(true);
                }
                AbstractSGServiceUI.this.errorLabel.setText(string);
                AbstractSGServiceUI.this.errorLabel.repaint();
            }
        });
    }

    private void setStatusText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractSGServiceUI.this.statusLabel.setText(text);
            }
        });
    }

    public void changed(AbstractField source) {
        this.enableUpdateButtons();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.checkUpdateButtonState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.actionButton) {
            if (this.actionThread != null) {
                this.actionThread.die();
            }
            this.actionThread = new ActionMachinesThread(this.selectedMachines);
            this.actionThread.start();
        } else {
            if (this.actionThread != null) {
                this.actionThread.die();
            }
            this.actionThread = null;
            for (Machine m : this.allMachines) {
                m.setUIMetadata(null);
            }
            this.listener.finish();
        }
    }

    class ActionMachinesThread
    extends Thread {
        private Machine[] items;
        private boolean die;

        public ActionMachinesThread(Machine[] items) {
            this.items = items;
        }

        public void die() {
            this.die = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String machinePassword = AbstractSGServiceUI.this.machinePasswordField.getTextFieldValue();
                String username = AbstractSGServiceUI.this.usernameField.getTextFieldValue();
                String password = AbstractSGServiceUI.this.passwordField.getTextFieldValue();
                AbstractSGServiceUI.this.progressBar.on();
                for (int i = 0; i < this.items.length; ++i) {
                    if (this.die) {
                        return;
                    }
                    Machine machine = this.items[i];
                    int index = i + 1;
                    System.out.println("[AbstractSGServiceUtil] Processing " + machine);
                    AbstractSGServiceUI.this.setStatusText(AbstractSGServiceUI.this.getStatusText() + " " + index + "/" + this.items.length + ": " + machine.getMachineName());
                    GeneralInfoWrapper wrapper = (GeneralInfoWrapper)AbstractSGServiceUI.this.map.get(machine.getMachineID());
                    wrapper.error = false;
                    wrapper.explanation = null;
                    wrapper.busyActioning = true;
                    AbstractSGServiceUI.this.listener.startedProcessing(machine);
                    int result = SGServiceUpdateUtil.RESULT_ERROR;
                    try {
                        AbstractServiceUtil updateUtil = AbstractSGServiceUI.this.getUpdateUtilFor(AbstractSGServiceUI.this.client, machine);
                        result = updateUtil.doUpdate(machinePassword, username, password);
                        wrapper.busyActioning = false;
                        if (result == SGServiceUpdateUtil.RESULT_OK) {
                            wrapper.actionedOk = true;
                            continue;
                        }
                        if (result == SGServiceUpdateUtil.RESULT_MACHINE_PASSWORD) {
                            wrapper.requiresMachinePassword = true;
                            continue;
                        }
                        if (result == SGServiceUpdateUtil.RESULT_CREDENTIALS) {
                            wrapper.requiresCredentials = true;
                            continue;
                        }
                        if (result != SGServiceUpdateUtil.RESULT_ERROR) continue;
                        wrapper.explanation = updateUtil.getErrorExplanation();
                        wrapper.error = true;
                        continue;
                    }
                    finally {
                        AbstractSGServiceUI.this.listener.endedProcessing(machine, result);
                    }
                }
            }
            finally {
                AbstractSGServiceUI.this.setStatusText("");
                AbstractSGServiceUI.this.progressBar.off();
                AbstractSGServiceUI.this.checkUpdateButtonState();
            }
        }
    }

    class GeneralInfoWrapper {
        boolean busyActioning;
        Machine info;
        boolean actionedOk = false;
        boolean requiresMachinePassword = false;
        boolean requiresCredentials = false;
        public boolean error = false;
        public String explanation = null;

        GeneralInfoWrapper() {
        }

        public int hashCode() {
            return this.info.getMachineID().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof GeneralInfoWrapper)) {
                return false;
            }
            GeneralInfoWrapper wrapper = (GeneralInfoWrapper)o;
            return wrapper.info.equals(this.info);
        }
    }
}

