/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.dnd;

import com.aem.shelp.tech.access.dnd.TransferEntry;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;

public abstract class TreeTransferable<TG extends TreeGroup<TG, TE>, TE extends TreeElement>
implements Transferable {
    TransferEntry<TG, TE>[] machines;
    private DataFlavor[] flavors;

    public TreeTransferable(TransferEntry<TG, TE>[] machines) {
        this.machines = machines;
        this.flavors = this.initFlavors();
    }

    protected abstract DataFlavor[] initFlavors();

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.machines;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavors[0].equals(flavor);
    }
}

