/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.table.sessions;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.contents.table.AbstractMachineTable;
import com.aem.shelp.tech.access.contents.table.TableGroupPanel;
import com.aem.shelp.tech.access.contents.table.sessions.SessionTableColumns;
import com.aem.shelp.tech.access.contents.table.sessions.SessionsTableRenderer;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.hierarchy.ui.SelectionUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.SwingUtil;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class SessionsTable
extends AbstractMachineTable {
    private static final SessionsTableDurationRepainter durationRepainter = new SessionsTableDurationRepainter();
    private SimpleList<IndexedAbstractSession> sessionsList;
    private SessionsTableRenderer sessionTableRenderer;
    private int prevColumnCount = 0;

    public SessionsTable(MachineTreeModel model, MachineGroup group, AccessPanelListener accessPanelListener, TableGroupPanel tableGroupPanel, boolean showMachineIcons) {
        super(group, accessPanelListener, tableGroupPanel);
        this.initSessionsList();
        this.initUI(showMachineIcons);
        durationRepainter.addSessionsTable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSessionsList() {
        if (this.sessionsList == null) {
            this.sessionsList = new SimpleList();
        }
        this.sessionsList.startBatch();
        try {
            if (this.sessionsList.size() > 0) {
                this.sessionsList.clear();
            }
            for (int index = 0; index < this.group.getElements().size(); ++index) {
                Machine machine = (Machine)this.group.getElements().get(index);
                for (int sessionIndex = 0; sessionIndex < machine.getActiveSessionCount_ClientOnly(); ++sessionIndex) {
                    AbstractSession session = machine.getActiveSessions_ClientOnly().get(sessionIndex);
                    this.sessionsList.add(new IndexedAbstractSession(index, sessionIndex, session, machine));
                }
            }
        }
        finally {
            this.sessionsList.endBatch();
        }
    }

    @Override
    public SHJTable getRootComponent() {
        return this.table;
    }

    private void initUI(boolean showMachineIcons) {
        TableStructure ts = TableStructure.createTableStructure(Machine.class, new String[]{""}, new String[]{Language.get("REMOTE_MACHINE")});
        this.model = new SimpleTableModel(this.sessionsList, ts);
        this.table = new SHJTable(this.model){

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                SelectionUtil<MachineGroup, Machine> model = SessionsTable.this.tableGroupPanel.getGroupsList().getSelectionModel();
                model.changeSelection(SessionsTable.this.tableGroupPanel, rowIndex, toggle, extend);
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                boolean result = super.processKeyBinding(ks, e, condition, pressed);
                if (result) {
                    Object binding;
                    InputMap map = this.getInputMap(condition);
                    ActionMap am = this.getActionMap();
                    if (map != null && am != null && this.isEnabled() && (binding = map.get(ks)).equals("selectAll")) {
                        SessionsTable.this.tableGroupPanel.getGroupsList().selectAllExceptIn(SessionsTable.this.tableGroupPanel);
                    }
                }
                return result;
            }
        };
        this.table.getSelectionModel().addListSelectionListener(new MachineSelectionListener());
        this.table.setRowHeight(SimpleHelpLookAndFeel.scale((int)27));
        this.sessionTableRenderer = new SessionsTableRenderer(this.tableGroupPanel, showMachineIcons, this.sessionsList, this.accessPanelListener.getTechClient());
        this.table.setDefaultRenderer(Object.class, this.sessionTableRenderer);
        this.table.setDefaultRenderer(String.class, this.sessionTableRenderer);
        this.table.addMouseListener(new TerminateAdapter());
    }

    @Override
    public void sortByColumn(int columnToSortBy, boolean ascending) {
    }

    public void groupsRemoved(MachineGroup parentGroup, MachineGroup[] removedChildren, int[] removedIndices) {
    }

    public void groupsAdded(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void groupsChanged(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void machinesChanged(MachineGroup parent, Machine[] inserted, Machine[] removed, Machine[] updated, Machine.MachineChanges updateResults) {
        block10: {
            int sessionsAdded;
            block9: {
                if (!parent.equals(this.group)) {
                    return;
                }
                sessionsAdded = 0;
                int sessionsRemoved = 0;
                if (updateResults.sessionsAdded != null) {
                    sessionsAdded = updateResults.sessionsAdded.size();
                }
                if (updateResults.sessionsRemoved != null) {
                    sessionsRemoved = updateResults.sessionsRemoved.size();
                }
                if (sessionsRemoved <= 0) break block9;
                for (AbstractSession session : updateResults.sessionsRemoved) {
                    for (int i = this.sessionsList.size() - 1; i >= 0; --i) {
                        IndexedAbstractSession existingSession = this.sessionsList.get(i);
                        if (!session.equals(existingSession.session)) continue;
                        this.sessionsList.remove(existingSession);
                    }
                }
                break block10;
            }
            if (sessionsAdded <= 0) break block10;
            for (AbstractSession session : updateResults.sessionsAdded) {
                int indexToInsertAt = -1;
                int sessionIndex = 0;
                for (int i = 0; i < this.sessionsList.size(); ++i) {
                    IndexedAbstractSession existingSession = this.sessionsList.get(i);
                    if (existingSession.remoteMachine.equals(session.getRemoteMachine())) {
                        indexToInsertAt = i + 1;
                        ++sessionIndex;
                        continue;
                    }
                    if (indexToInsertAt != -1) break;
                }
                IndexedAbstractSession indexedAbstractSession = new IndexedAbstractSession(indexToInsertAt, sessionIndex, session, (Machine)session.getRemoteMachine());
                if (indexToInsertAt == -1 || indexToInsertAt == this.sessionsList.size()) {
                    this.sessionsList.add(indexedAbstractSession);
                    continue;
                }
                this.sessionsList.add(indexToInsertAt, indexedAbstractSession);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.sessionsList.size() == 0;
    }

    @Override
    public Machine[] getSelectedMachines() {
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<Machine> selectedMachines = new ArrayList<Machine>();
        for (int selectedRow : selectedRows) {
            try {
                IndexedAbstractSession selection = (IndexedAbstractSession)this.table.getValueAt(selectedRow, 0);
                if (selection == null || selectedMachines.contains(selection.remoteMachine)) continue;
                selectedMachines.add(selection.remoteMachine);
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        }
        return selectedMachines.toArray(new Machine[0]);
    }

    @Override
    public void filterProcessorChanged() {
    }

    public static class IndexedAbstractSession {
        public int machineIndex;
        public int sessionIndex;
        public AbstractSession session;
        public Machine remoteMachine;

        public IndexedAbstractSession(int index, int sessionIndex, AbstractSession session, Machine remoteMachine) {
            this.machineIndex = index;
            this.sessionIndex = sessionIndex;
            this.session = session;
            this.remoteMachine = remoteMachine;
        }
    }

    class MachineSelectionListener
    implements ListSelectionListener {
        MachineSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            SessionsTable.this.tableGroupPanel.getGroupsList().notifySelectionChange();
        }
    }

    static class SessionsTableDurationRepainter
    extends Thread {
        private final LinkedList<WeakReference<SessionsTable>> allTables = new LinkedList();
        private final Object LOCK = new Object();

        public SessionsTableDurationRepainter() {
            super("SessionsTableDurationRepainter");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSessionsTable(SessionsTable table) {
            Object object = this.LOCK;
            synchronized (object) {
                this.allTables.add(new WeakReference<SessionsTable>(table));
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    this.repaintDuration();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repaintDuration() {
            Object object = this.LOCK;
            synchronized (object) {
                for (int i = this.allTables.size() - 1; i >= 0; --i) {
                    WeakReference<SessionsTable> ref = this.allTables.get(i);
                    SessionsTable sessionsTable = (SessionsTable)ref.get();
                    if (sessionsTable == null) {
                        this.allTables.remove(i);
                        continue;
                    }
                    sessionsTable.getRootComponent().repaint();
                }
            }
        }
    }

    class TerminateAdapter
    extends MouseAdapter {
        TerminateAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row;
            boolean isTerminatePressed = SessionTableColumns.isTerminateColumn(e.getPoint().x);
            if (isTerminatePressed && (row = SessionsTable.this.table.rowAtPoint(e.getPoint())) >= 0) {
                boolean terminate;
                final AbstractSession session = ((IndexedAbstractSession)((SessionsTable)SessionsTable.this).table.getValueAt((int)row, (int)0)).session;
                TransientTechUser techUser = SessionsTable.this.accessPanelListener.getTechClient().getTechUser();
                if (techUser.canTerminateSession(session) && (terminate = SHGlassOptionPane.showConfirmDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)SessionsTable.this.getRootComponent()), (String)Language.get("CONFIRM_CLOSE"), (String)Language.get("CONFIRM_CLOSE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/general/disconnect.svg,48"), (String)Language.get("CLOSE_SESSION")))) {
                    new Thread(){

                        @Override
                        public void run() {
                            SessionsTable.this.accessPanelListener.terminateSession(session);
                        }
                    }.start();
                }
                e.consume();
            }
        }
    }
}

