/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.table;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.HierarchyPanelListener;
import com.aem.shelp.tech.access.contents.ContinualViewableUpdates;
import com.aem.shelp.tech.access.contents.table.MachineTableHeader;
import com.aem.shelp.tech.access.contents.table.TableGroupPanel;
import com.aem.shelp.tech.access.contents.table.sessions.SessionsTableHeader;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.access.utils.MachineSelection;
import com.aem.shelp.tech.hierarchy.model.AbstractTreeModel;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupPanel;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupsList;
import com.aem.shelp.tech.hierarchy.utils.TreeSelection;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import javax.swing.UIManager;
import utils.progtools.RunOnSilentThreadLock;
import utils.swing.images.ImageLoader;

public class TableGroupList
extends AbstractGroupsList<MachineGroup, Machine> {
    private boolean showSessionsTable = false;

    public TableGroupList(AccessPanelListener accessPanelListener) {
        super(accessPanelListener);
    }

    public void setShowSessions(boolean showSessions) {
        this.showSessionsTable = showSessions;
    }

    @Override
    protected void notifySelectionChange(TreeSelection<MachineGroup, Machine> selection) {
        ((AccessPanelListener)this.hierarchyPanelListener).setSelectedElements(this, selection, true);
    }

    @Override
    protected AbstractGroupPanel<MachineGroup, Machine> createGroupPanel(AbstractTreeModel<MachineGroup, Machine> groupInterface, MachineGroup group, HierarchyPanelListener accessPanelListener, boolean isFirstAdded, AbstractGroupsList<MachineGroup, Machine> groupsList, boolean showMachineIcons) {
        return new TableGroupPanel((MachineTreeModel)groupInterface, group, (AccessPanelListener)accessPanelListener, isFirstAdded, groupsList, showMachineIcons, this.showSessionsTable);
    }

    @Override
    protected Color getBackground() {
        return UIManager.getColor("Table.background");
    }

    @Override
    protected void addHeading() {
        if (this.showSessionsTable) {
            SessionsTableHeader machineTableHeader = new SessionsTableHeader();
            this.rootScrollPane.setColumnHeaderView(machineTableHeader);
        } else {
            MachineTableHeader machineTableHeader = new MachineTableHeader();
            this.rootScrollPane.setColumnHeaderView(machineTableHeader);
        }
    }

    @Override
    protected TreeSelection<MachineGroup, Machine> initTreeSelection() {
        return new MachineSelection();
    }

    @Override
    protected void elementsAreShowing(List<Machine> elements) {
        this.hierarchyPanelListener.getTechClient().addMachinesToSubscribeList(elements);
    }

    @Override
    protected void elementsHaveBeenPainted(RunOnSilentThreadLock paintedLock, AbstractTreeModel<MachineGroup, Machine> groupInterface, AbstractGroupsList<MachineGroup, Machine> abstractGroupsList) {
        ContinualViewableUpdates.INSTANCE.register((AccessPanelListener)this.hierarchyPanelListener, abstractGroupsList);
    }

    protected void addToGroupPanel(AbstractGroupPanel<MachineGroup, Machine> groupPanel, MachineGroup parent, Machine[] inserted, Machine[] removed, Machine[] updated, Machine.MachineChanges updateResults) {
        groupPanel.machinesChanged(parent, inserted, removed, updated, updateResults);
    }

    @Override
    protected Icon getNoContentIcon() {
        return ImageLoader.getImageIconDisabled((String)"images/svg/technology/screen.svg,128");
    }

    @Override
    protected String getNoContentText() {
        return Language.get("ACCESS_PANEL_NO_MACHINES");
    }

    @Override
    protected String getNoContentSubText() {
        return null;
    }

    public void groupsChanged(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }
}

