/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.table;

import com.aem.CentralDebugging;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.MachineUIMetadata;
import com.aem.shelp.tech.access.contents.table.MachineTableColumns;
import com.aem.shelp.tech.access.contents.table.TableGroupPanel;
import com.aem.shelp.tech.access.contents.ui.StatusIcon;
import com.aem.shelp.tech.customer.OSIconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import utils.swing.MiniStatGraph;
import utils.swing.components.AlertGradientTableCellRenderer;
import utils.swing.images.ImageLoader;

public class MachineTableRenderer
extends AlertGradientTableCellRenderer
implements MachineTableColumns.MachineColumnPainter {
    private Machine machine;
    private boolean isSelected = false;
    private MachineInfo info;
    private MiniStatGraph cpu = new MiniStatGraph(AccessStyle.MINISTAT_BG, MiniStatGraph.GREEN, 100.0);
    private MiniStatGraph mem = new MiniStatGraph(AccessStyle.MINISTAT_BG, MiniStatGraph.BLUE, 100.0);
    private TableGroupPanel tableGroupPanel;
    private boolean showMachineIcons = true;

    public MachineTableRenderer(TableGroupPanel tableGroupPanel, boolean showMachineIcons) {
        this.setShowMachineIcons(showMachineIcons);
        this.tableGroupPanel = tableGroupPanel;
    }

    public void setShowMachineIcons(boolean showMachineIcons) {
        this.showMachineIcons = showMachineIcons;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        AlertGradientTableCellRenderer label = (AlertGradientTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            label.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            label.setForeground(UIManager.getColor("Table.foreground"));
        }
        label.setWarningBackground(null, true);
        this.isSelected = isSelected;
        this.machine = (Machine)value;
        if (this.machine == null) {
            this.info = null;
            label.setText(" ");
            label.setIcon(null);
        } else {
            this.info = this.machine.getMachineInfo();
            if (this.machine.getMachineName() != null) {
                label.setText(" " + this.machine.getMachineName().getName());
            } else {
                label.setText(" ");
            }
            if (!this.machine.isAvailable()) {
                if (!isSelected) {
                    label.setForeground(Color.GRAY);
                } else {
                    label.setForeground(new Color(240, 240, 240));
                }
            }
            if (this.showMachineIcons) {
                Object uiMetadata = this.machine.getUIMetadata();
                if (uiMetadata != null) {
                    label.setIcon(((MachineUIMetadata)uiMetadata).getIcon());
                } else {
                    label.setIcon(null);
                }
            }
        }
        return label;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (MachineTableColumns.getColumnsWidth() == -1) {
            return dim;
        }
        dim.width = this.getWidth() - MachineTableColumns.getColumnsWidth();
        return dim;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = super.getWidth();
        int height = super.getHeight();
        Dimension prefSize = this.getPreferredSize();
        this.setSize(prefSize.width, height);
        super.paint(g);
        this.setSize(width, height);
        g.setColor(this.getBackground());
        g.fillRect(prefSize.width, 0, width - prefSize.width, height);
        g.setColor(this.getForeground());
        g.setFont(AccessStyle.MACHINE_TABLE_FONT);
        MachineTableColumns.callPaintMethods(g, width, height, this, this.isSelected);
        this.tableGroupPanel.getGroupsList().justPainted(this.machine);
        if (CentralDebugging.SHOW_ACCESS_SUBSCRIPTIONS) {
            System.out.println("[Subscriptions][MachineTableRenderer] Painting machine: " + this.machine);
        }
    }

    @Override
    public void paintIP(Graphics g, int width, int height) {
        String ip;
        if (this.info != null && (ip = this.info.getMostRelevantLanIP()) != null) {
            this.paintText(g, ip, width, height, MachineTableColumns.ipCenter, MachineTableColumns.IP_WIDTH);
        }
    }

    @Override
    public void paintWANIP(Graphics g, int width, int height) {
        String ip;
        if (this.info != null && (ip = this.info.getWanIP()) != null) {
            this.paintText(g, ip, width, height, MachineTableColumns.wanIpCenter, MachineTableColumns.WANIP_WIDTH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintText(Graphics g, String text, int width, int height, int centerX, int columnWidth) {
        if (text == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int baseTextLine = height / 2 + fm.getDescent() + 1;
        Shape currentClip = g.getClip();
        Rectangle bounds = currentClip.getBounds();
        try {
            int x = width + centerX - columnWidth / 2;
            int y = 0;
            int w = columnWidth;
            int h = height;
            int x2 = x + w;
            int y2 = y + h;
            int newx = Math.max(x, bounds.x);
            int newy = Math.max(y, bounds.y);
            int newx2 = Math.min(bounds.x + bounds.width, x2);
            int newy2 = Math.min(bounds.y + bounds.height, y2);
            g.setClip(new Rectangle(newx, newy, newx2 - newx, newy2 - newy));
            g.drawString(text, width + centerX - columnWidth / 2, baseTextLine);
        }
        finally {
            g.setClip(currentClip);
        }
    }

    @Override
    public void paintHostname(Graphics g, int width, int height) {
        if (this.info != null) {
            String hostname = this.info.getHostname();
            this.paintText(g, hostname, width, height, MachineTableColumns.hostnameCenter, MachineTableColumns.HOSTNAME_WIDTH);
        }
    }

    @Override
    public void paintUsername(Graphics g, int width, int height) {
        if (this.info != null) {
            String user = this.info.getConsoleUser();
            this.paintText(g, user, width, height, MachineTableColumns.usernameCenter, MachineTableColumns.USERNAME_WIDTH);
        }
    }

    @Override
    public void paintGraphs(Graphics g, int width, int height) {
        if (this.info != null && this.machine != null && this.machine.isAvailable()) {
            if (this.machine.allowMonitoring()) {
                if (this.machine.isMonitored()) {
                    int padding = 2;
                    int graphHeight = height - 2 * padding;
                    this.mem.paint(g, this.info.getMem(), width + MachineTableColumns.memCenter - MachineTableColumns.GRAPH_WIDTHS / 2, padding, MachineTableColumns.GRAPH_WIDTHS, graphHeight, true);
                    this.cpu.paint(g, this.info.getCpu(), width + MachineTableColumns.cpuCenter - MachineTableColumns.GRAPH_WIDTHS / 2, padding, MachineTableColumns.GRAPH_WIDTHS, graphHeight, true);
                }
            } else if (this.machine.supportsMonitoring()) {
                Icon deniedIcon = ImageLoader.getImageIcon((String)"images/svg/general/accessdenied.svg,16");
                deniedIcon.paintIcon(null, g, width + MachineTableColumns.memCenter - MachineTableColumns.GRAPH_WIDTHS / 2 - deniedIcon.getIconWidth() / 2, (height - deniedIcon.getIconHeight()) / 2);
            }
        }
    }

    @Override
    public void paintOS(Graphics g, int width, int height, boolean isSelected) {
        Icon osIcon = this.machine != null ? OSIconLoader.getOSTag(this.machine, isSelected) : null;
        if (osIcon != null) {
            osIcon.paintIcon(null, g, width + MachineTableColumns.osCenter - osIcon.getIconWidth() / 2, (height - osIcon.getIconHeight()) / 2);
        }
    }

    @Override
    public void paintStatus(Graphics g, int width, int height) {
        if (this.machine != null) {
            StatusIcon.renderStatus(g, this.machine, width + MachineTableColumns.statusCenter, height / 2);
        }
    }

    @Override
    public void paintMachineName(Graphics g, int width, int height) {
    }

    @Override
    public void paintAlert(Graphics g, int width, int height) {
        if (this.machine != null && this.machine.getMachineInfo() != null && this.machine.getMachineInfo().getTriggeredAlertIDs().size() > 0) {
            Icon icon = this.machine.isAvailable() ? ImageLoader.getImageIcon((String)Icons.ALERT_STATUS_TAB_BAD) : ImageLoader.getImageIcon((String)Icons.ALERT_STATUS_TAB_SH);
            icon.paintIcon(this, g, width + MachineTableColumns.alertsCenter - icon.getIconWidth() / 2, (height - icon.getIconHeight()) / 2);
        }
    }
}

