/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.table;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.NetAdapter;
import com.aem.shelp.tech.customer.OSIconLoader;
import com.aem.shelp.tech.customer.OSTag;
import java.awt.Graphics;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class MachineTableColumns {
    public static int[] cumulativeColumnWidths;
    public static int columnsToShow;
    public static final int GRAPH_WIDTHS;
    public static final int PADDING;
    public static final int OS_WIDTH;
    public static final int USERNAME_WIDTH;
    public static final int STATUS_ICON_WIDTH;
    public static final int ALERTS_ICON_WIDTH;
    public static final int IP_WIDTH;
    public static final int WANIP_WIDTH;
    public static final int HOSTNAME_WIDTH;
    public static int memCenter;
    public static int cpuCenter;
    public static int osCenter;
    public static int usernameCenter;
    public static int statusCenter;
    public static int alertsCenter;
    public static int ipCenter;
    public static int hostnameCenter;
    public static int wanIpCenter;
    private static int availableWidth;

    public static void setAvailableWidth(int width) {
        if (width == availableWidth) {
            return;
        }
        availableWidth = width;
        int metricsWidth = width - SimpleHelpLookAndFeel.scale((int)200);
        if (metricsWidth < 0) {
            MachineTableColumns.setColumnsToShow(1);
        } else {
            int colCount;
            for (colCount = cumulativeColumnWidths.length - 1; colCount > 0 && cumulativeColumnWidths[colCount] > metricsWidth; --colCount) {
            }
            MachineTableColumns.setColumnsToShow(++colCount);
        }
    }

    public static int getColumnsWidth() {
        if (columnsToShow == 0) {
            return -1;
        }
        return cumulativeColumnWidths[columnsToShow - 1];
    }

    public static int getColumnAtX(int x, int width) {
        int col0Width = width - cumulativeColumnWidths[columnsToShow - 1];
        if (x < col0Width) {
            return 0;
        }
        if (MachineTableColumns.inBetween(x, width + alertsCenter, ALERTS_ICON_WIDTH)) {
            return 1;
        }
        if (MachineTableColumns.inBetween(x, width + statusCenter, STATUS_ICON_WIDTH)) {
            return 2;
        }
        if (MachineTableColumns.inBetween(x, width + osCenter, OS_WIDTH)) {
            return 3;
        }
        if (MachineTableColumns.inBetween(x, width + usernameCenter, USERNAME_WIDTH)) {
            return 4;
        }
        if (MachineTableColumns.inBetween(x, width + hostnameCenter, HOSTNAME_WIDTH)) {
            return 5;
        }
        if (MachineTableColumns.inBetween(x, width + ipCenter, IP_WIDTH)) {
            return 6;
        }
        if (MachineTableColumns.inBetween(x, width + wanIpCenter, WANIP_WIDTH)) {
            return 7;
        }
        return 0;
    }

    private static boolean inBetween(int x, int center, int width) {
        return center - width / 2 < x && x < center + width / 2;
    }

    private static void setColumnsToShow(int count) {
        columnsToShow = count;
        switch (columnsToShow) {
            case 2: {
                alertsCenter = -PADDING - ALERTS_ICON_WIDTH / 2;
                break;
            }
            case 3: {
                statusCenter = -PADDING - STATUS_ICON_WIDTH / 2;
                alertsCenter = statusCenter - PADDING - ALERTS_ICON_WIDTH / 2 - STATUS_ICON_WIDTH / 2;
            }
            case 4: {
                osCenter = -PADDING - OS_WIDTH / 2;
                statusCenter = osCenter - PADDING - STATUS_ICON_WIDTH / 2 - OS_WIDTH / 2;
                alertsCenter = statusCenter - PADDING - ALERTS_ICON_WIDTH / 2 - STATUS_ICON_WIDTH / 2;
                break;
            }
            case 5: {
                memCenter = -PADDING - GRAPH_WIDTHS / 2;
                cpuCenter = memCenter - PADDING - GRAPH_WIDTHS;
                osCenter = cpuCenter - PADDING - GRAPH_WIDTHS / 2 - OS_WIDTH / 2;
                statusCenter = osCenter - PADDING - STATUS_ICON_WIDTH / 2 - OS_WIDTH / 2;
                alertsCenter = statusCenter - PADDING - ALERTS_ICON_WIDTH / 2 - STATUS_ICON_WIDTH / 2;
                break;
            }
            case 6: {
                memCenter = -PADDING - GRAPH_WIDTHS / 2;
                cpuCenter = memCenter - PADDING - GRAPH_WIDTHS;
                usernameCenter = cpuCenter - PADDING - GRAPH_WIDTHS / 2 - USERNAME_WIDTH / 2;
                osCenter = usernameCenter - PADDING - USERNAME_WIDTH / 2 - OS_WIDTH / 2;
                statusCenter = osCenter - PADDING - STATUS_ICON_WIDTH / 2 - OS_WIDTH / 2;
                alertsCenter = statusCenter - PADDING - ALERTS_ICON_WIDTH / 2 - STATUS_ICON_WIDTH / 2;
                break;
            }
            case 7: {
                memCenter = -PADDING - GRAPH_WIDTHS / 2;
                cpuCenter = memCenter - PADDING - GRAPH_WIDTHS;
                hostnameCenter = cpuCenter - PADDING - GRAPH_WIDTHS / 2 - HOSTNAME_WIDTH / 2;
                usernameCenter = hostnameCenter - PADDING - HOSTNAME_WIDTH / 2 - USERNAME_WIDTH / 2;
                osCenter = usernameCenter - PADDING - USERNAME_WIDTH / 2 - OS_WIDTH / 2;
                statusCenter = osCenter - PADDING - STATUS_ICON_WIDTH / 2 - OS_WIDTH / 2;
                alertsCenter = statusCenter - PADDING - ALERTS_ICON_WIDTH / 2 - STATUS_ICON_WIDTH / 2;
                break;
            }
            case 8: {
                memCenter = -PADDING - GRAPH_WIDTHS / 2;
                cpuCenter = memCenter - PADDING - GRAPH_WIDTHS;
                ipCenter = cpuCenter - PADDING - GRAPH_WIDTHS / 2 - IP_WIDTH / 2;
                hostnameCenter = ipCenter - PADDING - IP_WIDTH / 2 - HOSTNAME_WIDTH / 2;
                usernameCenter = hostnameCenter - PADDING - HOSTNAME_WIDTH / 2 - USERNAME_WIDTH / 2;
                osCenter = usernameCenter - PADDING - USERNAME_WIDTH / 2 - OS_WIDTH / 2;
                statusCenter = osCenter - PADDING - STATUS_ICON_WIDTH / 2 - OS_WIDTH / 2;
                alertsCenter = statusCenter - PADDING - ALERTS_ICON_WIDTH / 2 - STATUS_ICON_WIDTH / 2;
                break;
            }
            case 9: {
                memCenter = -PADDING - GRAPH_WIDTHS / 2;
                cpuCenter = memCenter - PADDING - GRAPH_WIDTHS;
                wanIpCenter = cpuCenter - PADDING - GRAPH_WIDTHS / 2 - WANIP_WIDTH / 2;
                ipCenter = wanIpCenter - PADDING - WANIP_WIDTH / 2 - IP_WIDTH / 2;
                hostnameCenter = ipCenter - PADDING - IP_WIDTH / 2 - HOSTNAME_WIDTH / 2;
                usernameCenter = hostnameCenter - PADDING - HOSTNAME_WIDTH / 2 - USERNAME_WIDTH / 2;
                osCenter = usernameCenter - PADDING - USERNAME_WIDTH / 2 - OS_WIDTH / 2;
                statusCenter = osCenter - PADDING - STATUS_ICON_WIDTH / 2 - OS_WIDTH / 2;
                alertsCenter = statusCenter - PADDING - ALERTS_ICON_WIDTH / 2 - STATUS_ICON_WIDTH / 2;
            }
        }
    }

    public static int getWanIPColumn() {
        if (columnsToShow == 9) {
            return 7;
        }
        return -1;
    }

    public static int getLanIPColumn() {
        if (columnsToShow >= 8) {
            return 6;
        }
        return -1;
    }

    public static int getNameColumnWidth() {
        return cumulativeColumnWidths[columnsToShow - 1];
    }

    public static Object getColumnContents(int column, Machine m) {
        if (column == 0) {
            return m.getMachineName().getName();
        }
        if (column == 1) {
            return m.getMachineInfo().getTriggeredAlertIDs().size();
        }
        if (column == 2) {
            if (!m.isAvailable()) {
                return -1;
            }
            return m.getActiveSessionCount_ClientOnly();
        }
        if (column == 3) {
            return m.getOsSummary();
        }
        if (columnsToShow >= 6) {
            if (column == 4) {
                return m.getRemoteUsername();
            }
            if (column == 5) {
                return m.getMachineInfo().getHostname();
            }
            if (column == 6) {
                NetAdapter[] netAdapters = m.getMachineInfo().getNetAdapters();
                if (netAdapters != null && netAdapters.length > 0 && netAdapters[0] != null) {
                    return netAdapters[0].ip;
                }
                return "";
            }
            if (column == 7) {
                return m.getMachineInfo().getWanIP();
            }
        }
        return null;
    }

    public static void callPaintMethods(Graphics g, int width, int height, MachineColumnPainter painter, boolean isSelected) {
        switch (columnsToShow) {
            case 9: {
                painter.paintWANIP(g, width, height);
            }
            case 8: {
                painter.paintIP(g, width, height);
            }
            case 7: {
                painter.paintHostname(g, width, height);
            }
            case 6: {
                painter.paintUsername(g, width, height);
            }
            case 5: {
                painter.paintGraphs(g, width, height);
            }
            case 4: {
                painter.paintOS(g, width, height, isSelected);
            }
            case 3: {
                painter.paintAlert(g, width, height);
            }
            case 2: {
                painter.paintStatus(g, width, height);
            }
            case 0: 
            case 1: {
                painter.paintMachineName(g, width, height);
            }
        }
    }

    static {
        columnsToShow = 0;
        GRAPH_WIDTHS = SimpleHelpLookAndFeel.scale((int)40);
        PADDING = SimpleHelpLookAndFeel.scale((int)4);
        OS_WIDTH = OSTag.getTagWidth(OSIconLoader.OSIconSize.SMALL, true);
        USERNAME_WIDTH = SimpleHelpLookAndFeel.scale((int)100);
        STATUS_ICON_WIDTH = SimpleHelpLookAndFeel.scale((int)30);
        ALERTS_ICON_WIDTH = SimpleHelpLookAndFeel.scale((int)30);
        IP_WIDTH = SimpleHelpLookAndFeel.scale((int)100);
        WANIP_WIDTH = SimpleHelpLookAndFeel.scale((int)100);
        HOSTNAME_WIDTH = SimpleHelpLookAndFeel.scale((int)150);
        int i = 0;
        int j = 0;
        cumulativeColumnWidths = new int[9];
        MachineTableColumns.cumulativeColumnWidths[i++] = 0;
        MachineTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + ALERTS_ICON_WIDTH;
        MachineTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + STATUS_ICON_WIDTH;
        MachineTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + OS_WIDTH;
        MachineTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING * 2 + GRAPH_WIDTHS * 2;
        MachineTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + USERNAME_WIDTH;
        MachineTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + HOSTNAME_WIDTH;
        MachineTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + IP_WIDTH;
        MachineTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + WANIP_WIDTH;
        MachineTableColumns.setColumnsToShow(i);
    }

    public static interface MachineColumnPainter {
        public void paintIP(Graphics var1, int var2, int var3);

        public void paintWANIP(Graphics var1, int var2, int var3);

        public void paintHostname(Graphics var1, int var2, int var3);

        public void paintUsername(Graphics var1, int var2, int var3);

        public void paintGraphs(Graphics var1, int var2, int var3);

        public void paintOS(Graphics var1, int var2, int var3, boolean var4);

        public void paintStatus(Graphics var1, int var2, int var3);

        public void paintMachineName(Graphics var1, int var2, int var3);

        public void paintAlert(Graphics var1, int var2, int var3);
    }
}

