/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.apptunnel;

import com.aem.shelp.proxy.types.apptunnel.AppTunnelSpecification;
import utils.message.Message;

public class AppTunnelTarget {
    private final AppTunnelSpecification parent;
    private String remoteHost;

    private boolean isRemoteLocalhost() {
        return this.remoteHost == null;
    }

    public AppTunnelTarget(AppTunnelSpecification parent, String remoteHost) {
        this.parent = parent;
        this.remoteHost = remoteHost;
    }

    public String getRemoteHost() {
        if (this.isRemoteLocalhost()) {
            return "localhost";
        }
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.parent.getRemotePort();
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void toMessage(Message m) {
        m.append(this.remoteHost);
    }

    public static AppTunnelTarget fromMessage(Message m, AppTunnelSpecification spec, byte version) {
        return new AppTunnelTarget(spec, m.getNextString());
    }

    public boolean equals(Object o) {
        if (o instanceof AppTunnelTarget) {
            AppTunnelTarget target = (AppTunnelTarget)o;
            return target.parent.equals(this.parent) && target.remoteHost.equals(this.remoteHost);
        }
        return false;
    }

    public AppTunnelSpecification getSpecification() {
        return this.parent;
    }
}

