/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.TypedMap;
import utils.stream.StreamUtils;

public class WebsiteAccessibleThreshold
extends Alert {
    public static final Object ID = "WebsiteAccessibleTrigger";
    String site = "";
    boolean accessible = true;
    String validateText = "";
    String connect;
    String read;
    String reason;
    public static final String KEY_CONNECT_MS = "${CONTEXT_KEY_WEB_CONNECT_MS}";
    public static final String KEY_READ_MS = "${CONTEXT_KEY_WEB_READ_MS}";
    private long lastChecked = 0L;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_NET_WEB_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_NET_WEB_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/network.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/general/ok.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.accessible) {
            return Language.get("ALERT_WEB_ACCESSIBLE", this.site);
        }
        return Language.get("ALERT_WEB_NOTACCESSIBLE", this.site);
    }

    @Override
    public Alert createCorollary() {
        WebsiteAccessibleThreshold clone = (WebsiteAccessibleThreshold)this.cloneWithNewID();
        clone.accessible = !clone.accessible;
        return clone;
    }

    public void setTriggerOn(String site, boolean isAccessible, String validateText) {
        this.site = site;
        this.accessible = isAccessible;
        this.validateText = validateText;
    }

    public String getSite() {
        return this.site;
    }

    public String getValidationText() {
        return this.validateText;
    }

    public boolean getTriggerIfAccessible() {
        return this.accessible;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.site);
        m.append(this.accessible);
        m.append(this.validateText);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.site = m.getNextString();
        this.accessible = m.getNextBoolean();
        this.validateText = m.getNextString();
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_CONNECT_MS);
        keys.add(KEY_READ_MS);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_CONNECT_MS, this.connect);
        map.setString(KEY_READ_MS, this.read);
        return map;
    }

    @Override
    public void timePassed() {
        long now = SafeClock.currentTimeMillis();
        if (now - this.lastChecked > 20000L) {
            boolean through;
            block24: {
                this.lastChecked = now;
                if (CentralDebugging.ALERT_WEBSITE) {
                    System.out.println("[WebsiteThreshold] Checking now - more than 20s since last check.");
                }
                through = false;
                try {
                    InputStream in;
                    long ms;
                    if (CentralDebugging.ALERT_WEBSITE) {
                        System.out.println("[WebsiteThreshold] Connecting to " + this.site);
                    }
                    try {
                        ms = SafeClock.currentTimeMillis();
                        URL url = new URL(this.site);
                        in = url.openStream();
                        this.connect = "" + (SafeClock.currentTimeMillis() - ms);
                    }
                    catch (Exception x) {
                        this.reason = "${ALERT_WEB_CONNECT_FAILED} " + x;
                        throw x;
                    }
                    try {
                        if (CentralDebugging.ALERT_WEBSITE) {
                            System.out.println("[WebsiteThreshold] Connection successful");
                        }
                        if (this.validateText != null && this.validateText.length() > 0) {
                            if (CentralDebugging.ALERT_WEBSITE) {
                                System.out.println("[WebsiteThreshold] Checking validation text");
                            }
                            ms = SafeClock.currentTimeMillis();
                            String content = StreamUtils.readAllAsString((InputStream)in);
                            this.read = "" + (SafeClock.currentTimeMillis() - ms);
                            if (!content.contains(this.validateText)) {
                                if (CentralDebugging.ALERT_WEBSITE) {
                                    System.out.println("[WebsiteThreshold] Validation text NOT found");
                                }
                                this.reason = "${ALERT_WEB_VERIFY_FAILED}";
                                throw new ValidationFailedException("Validation content not found");
                            }
                            this.reason = "${ALERT_WEB_TEXT_OK}";
                            if (CentralDebugging.ALERT_WEBSITE) {
                                System.out.println("[WebsiteThreshold] Validation text found");
                            }
                        } else {
                            this.reason = "${ALERT_WEB_NOTEXT_OK}";
                        }
                    }
                    catch (ValidationFailedException x) {
                        throw x;
                    }
                    catch (Exception x) {
                        this.read = null;
                        this.reason = "${ALERT_WEB_READ_FAILED} " + x;
                        throw x;
                    }
                    finally {
                        FileUtil.robustClose((InputStream)in);
                    }
                    through = true;
                }
                catch (ValidationFailedException in) {
                }
                catch (Exception x) {
                    if (!CentralDebugging.ALERT_WEBSITE) break block24;
                    System.out.println("[WebsiteThreshold] Connection failed");
                    x.printStackTrace();
                }
            }
            boolean state = false;
            if (through && this.accessible) {
                state = true;
            }
            if (!through && !this.accessible) {
                state = true;
            }
            this.updateTriggeredState(state);
        }
    }

    class ValidationFailedException
    extends Exception {
        public ValidationFailedException(String message) {
            super(message);
        }
    }
}

