/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResult;
import com.aem.shelp.common.toolbox.ToolResourceLocator;
import com.aem.shelp.common.toolbox.server.ToolBoxRunner;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.GlobalEvents;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.message.TypedMap;
import utils.ostools.OS;
import utils.progtools.net.URLParser;
import utils.switches.LocalSwitches;
import utils.udp.Acculog;

public class ToolboxDatapointThreshold
extends Alert {
    public static final Object ID = "ToolboxDatapointTrigger";
    Message tooldef;
    boolean nonzero = true;
    double blockCount;
    int blockUnit;
    long startTime;
    boolean useGMT;
    static HashMap<String, Long> nextRun = new HashMap();
    static HashMap<String, Long> runs = new HashMap();
    static HashMap<String, ToolBoxResult> results = new HashMap();
    static Object runs_LOCK = new Object();
    ToolboxDatapointRun currentRun = null;
    String matched;
    String reason;
    public static final String KEY_RETCODE = "${CONTEXT_KEY_TOOLBOX_RETCODE}";

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_TBOX_DATA_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_TBOX_DATA_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/users/runner.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/general/box.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.nonzero) {
            return Language.get("ALERT_TBOX_TOOL_NONZERO", new Object[0]);
        }
        return Language.get("ALERT_TBOX_TOOL_ZERO", new Object[0]);
    }

    @Override
    public Alert createCorollary() {
        ToolboxDatapointThreshold clone = (ToolboxDatapointThreshold)this.cloneWithNewID();
        clone.nonzero = !clone.nonzero;
        return clone;
    }

    public double getBlockCount() {
        return this.blockCount;
    }

    public int getBlockUnit() {
        return this.blockUnit;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean useGMT() {
        return this.useGMT;
    }

    public void setBlockCount(double d) {
        this.blockCount = d;
    }

    public void setBlockUnit(int n) {
        this.blockUnit = n;
    }

    public void setStartTime(long d) {
        this.startTime = d;
    }

    public void setUseGMT(boolean b) {
        this.useGMT = b;
    }

    public void setTriggerOnToolResult(ToolBoxItem item, boolean triggerIfNonZero) {
        if (item != null) {
            this.tooldef = item.toDefOnlyMessage();
        }
        this.nonzero = triggerIfNonZero;
    }

    public String getToolName() {
        if (this.tooldef == null) {
            return "";
        }
        ToolBoxItem item = ToolBoxItem.loadDefOnlyFromMessage(this.tooldef);
        return item.getName();
    }

    public String getToolID() {
        if (this.tooldef == null) {
            return "";
        }
        ToolBoxItem item = ToolBoxItem.loadDefOnlyFromMessage(this.tooldef);
        return item.getID();
    }

    public boolean getTriggerIfNonZero() {
        return this.nonzero;
    }

    public ToolBoxItem getToolBoxItem() {
        if (this.tooldef == null) {
            return null;
        }
        ToolBoxItem item = ToolBoxItem.loadDefOnlyFromMessage(this.tooldef);
        return item;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        if (this.tooldef == null) {
            m.append((String)null);
        } else {
            try {
                m.append(MessageUtils.compress((Message)this.tooldef));
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
        m.append(this.nonzero);
        m.append(this.blockCount);
        m.append(this.blockUnit);
        m.append(this.startTime);
        m.append(this.useGMT);
        if (LocalSwitches.DEV_acculogAlertPropagation) {
            Acculog.log("[CustomToolThreshold] Serialised custom tool threshold, start time is " + new Date(this.startTime) + " " + (this.useGMT ? "GMT" : "MachineTime") + ", repeat every " + this.blockCount + " u=" + this.blockUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        if (m.getNextType() == 0) {
            m.getNextString();
            this.tooldef = null;
        } else {
            try {
                this.tooldef = MessageUtils.decompress((Message)m.getNextMessage());
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
        this.nonzero = m.getNextBoolean();
        this.blockCount = m.getNextDouble();
        this.blockUnit = m.getNextInt();
        this.startTime = m.getNextLong();
        this.useGMT = m.getNextBoolean();
        if (CentralDebugging.ALERT_TOOL_RUNNING_TIMING) {
            System.out.println("[CustomToolThreshold] Reloaded custom tool threshold, start time is " + new Date(this.startTime) + " " + (this.useGMT ? "GMT" : "MachineTime") + ", repeat every " + this.blockCount + " u=" + this.blockUnit);
        }
        if (LocalSwitches.DEV_acculogAlertPropagation) {
            Acculog.log("[CustomToolThreshold] Reloaded custom tool threshold, start time is " + new Date(this.startTime) + " " + (this.useGMT ? "GMT" : "MachineTime") + ", repeat every " + this.blockCount + " u=" + this.blockUnit);
        }
        Object object = runs_LOCK;
        synchronized (object) {
            nextRun.remove(this.getID());
        }
        if (this.isOneOff()) {
            if (System.currentTimeMillis() < this.startTime) {
                object = runs_LOCK;
                synchronized (object) {
                    runs.remove(this.getID());
                }
            }
            object = runs_LOCK;
            synchronized (object) {
                runs.put(this.getID(), this.startTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(ToolBoxItem item, ToolBoxResult result) {
        Object object = runs_LOCK;
        synchronized (object) {
            results.put(item.getID(), result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToolBoxResult getResult(ToolBoxItem item) {
        Object object = runs_LOCK;
        synchronized (object) {
            return results.get(item.getID());
        }
    }

    public boolean mustRun() {
        long lastRun = this.getMyLastRun();
        if (this.isOneOff()) {
            if (lastRun == 0L && System.currentTimeMillis() > this.startTime) {
                this.setMyLastRun(this.startTime);
                if (CentralDebugging.ALERT_TOOL_RUNNING_TIMING) {
                    System.out.println("[CustomToolThreshold] We are a one-off scheduled tool run and should RUN!");
                }
                return true;
            }
            if (lastRun == 0L) {
                if (CentralDebugging.ALERT_TOOL_RUNNING_TIMING) {
                    System.out.println("[CustomToolThreshold] We are a one-off scheduled tool run but our target time has not arrived yet");
                }
            } else if (CentralDebugging.ALERT_TOOL_RUNNING_TIMING) {
                System.out.println("[CustomToolThreshold] We are a one-off scheduled tool run but we have (or have assumed we have) already run");
            }
            return false;
        }
        if (CentralDebugging.ALERT_TOOL_RUNNING_TIMING) {
            System.out.println("[CustomToolThreshold] Last time we actually ran was " + new Date(lastRun));
        }
        long prevRun = this.getPreviousRun();
        if (CentralDebugging.ALERT_TOOL_RUNNING_TIMING) {
            System.out.println("[CustomToolThreshold] Previous run should have happened at " + new Date(prevRun));
        }
        if (lastRun == 0L) {
            this.setMyLastRun(prevRun);
            if (CentralDebugging.ALERT_TOOL_RUNNING_TIMING) {
                System.out.println("[CustomToolThreshold] We have never run, so will assume our last run was same as previous run " + new Date(prevRun) + ", and run next time");
            }
            return false;
        }
        if (lastRun < prevRun) {
            this.setMyLastRun(prevRun);
            if (CentralDebugging.ALERT_TOOL_RUNNING_TIMING) {
                System.out.println("[CustomToolThreshold] Last run doesn't match previous run, time to RUN!");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMyLastRun() {
        Object object = runs_LOCK;
        synchronized (object) {
            Long val = runs.get(this.getID());
            if (val == null) {
                return 0L;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMyLastRun(long run) {
        Object object = runs_LOCK;
        synchronized (object) {
            runs.put(this.getID(), run);
        }
    }

    private boolean isOneOff() {
        return this.blockCount > 1.0E8;
    }

    private long getBlockMillis() {
        long blockMillis = this.blockUnit == 0 ? (long)(this.blockCount * 1000.0) : (this.blockUnit == 1 ? (long)(this.blockCount * 60000.0) : (this.blockUnit == 2 ? (long)(this.blockCount * 60.0 * 60000.0) : (long)(this.blockCount * 24.0 * 60.0 * 60000.0)));
        return Math.max(blockMillis, (long)GlobalEvents.GRANULARITY_MS);
    }

    public long getPreviousRun() {
        if (this.isOneOff()) {
            return this.getNextRun();
        }
        return this.getNextRun() - this.getBlockMillis();
    }

    public long getCurrentTimeProperTimezone() {
        long curTime = System.currentTimeMillis();
        if (!this.useGMT) {
            curTime += (long)TimeZone.getDefault().getOffset(curTime);
        }
        return curTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextRun() {
        Object object = runs_LOCK;
        synchronized (object) {
            if (this.isOneOff()) {
                return this.startTime;
            }
            Long next = nextRun.get(this.getID());
            if (next == null) {
                next = this.startTime;
                nextRun.put(this.getID(), next);
            }
            long curTime = this.getCurrentTimeProperTimezone();
            long blockMillis = this.getBlockMillis();
            boolean mustSet = false;
            if (System.currentTimeMillis() > next) {
                mustSet = true;
                long minBlocks = (System.currentTimeMillis() - next) / blockMillis;
                next = next + blockMillis * minBlocks;
            }
            while (System.currentTimeMillis() > next) {
                next = next + blockMillis;
            }
            if (mustSet) {
                nextRun.put(this.getID(), next);
            }
            return next;
        }
    }

    @Override
    public void timePassed() {
        if (!this.mustRun()) {
            return;
        }
        if (this.currentRun != null) {
            if (CentralDebugging.ALERT_TOOL_RUNNING_DEBUG) {
                System.out.println("[ToolRunningThreshold] Unable to launch previous datapoint run, previous run is still up");
            }
        } else {
            this.currentRun = new ToolboxDatapointRun();
            this.currentRun.start();
        }
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_RETCODE);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_RETCODE, this.matched);
        return map;
    }

    class ToolboxDatapointRun
    extends Thread {
        ToolboxDatapointRun() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ToolBoxResult result;
                ToolBoxItem item = ToolboxDatapointThreshold.this.getToolBoxItem();
                if (item == null) {
                    if (CentralDebugging.ALERT_TOOL_RUNNING_DEBUG) {
                        System.out.println("[ToolRunningThreshold] Custom tool is null");
                    }
                    return;
                }
                int targetOS = item.getTargetOperatingSystem();
                OS.isWindows();
                if (targetOS != OS.base_type) {
                    if (CentralDebugging.ALERT_TOOL_RUNNING_DEBUG) {
                        System.out.println("[ToolRunningThreshold] Custom tool " + item.getName() + " cannot run on this OS");
                    }
                    return;
                }
                if (ToolResourceLocator.INSTANCE == null) {
                    if (CentralDebugging.ALERT_TOOL_RUNNING_DEBUG) {
                        System.out.println("[ToolRunningThreshold] Unable to run " + item.getName() + ", ToolResourceLocator is null, perhaps SG service needs updating?");
                    }
                    return;
                }
                String serverUrl = ToolResourceLocator.INSTANCE.getMapping(ToolboxDatapointThreshold.this);
                if (serverUrl == null) {
                    if (CentralDebugging.ALERT_TOOL_RUNNING_DEBUG) {
                        System.out.println("[ToolRunningThreshold] Unable to run " + item.getName() + ", no toolbox resource mapping found for this threshold");
                    }
                    return;
                }
                if (CentralDebugging.ALERT_TOOL_RUNNING_DEBUG) {
                    System.out.println("[ToolRunningThreshold] Checking to see if custom tool " + item.getName() + " returns " + (ToolboxDatapointThreshold.this.nonzero ? "non-zero" : "zero") + " (toolId:" + item.getID() + ",server:" + serverUrl + ")");
                }
                if (ToolboxDatapointThreshold.this.amCorollary()) {
                    result = ToolboxDatapointThreshold.this.getResult(item);
                    if (result == null) {
                        if (CentralDebugging.ALERT_TOOL_RUNNING_DEBUG) {
                            System.out.println("[ToolRunningThreshold] We are corollary threshold but there is no result stored for the tool run yet");
                        }
                        return;
                    }
                } else {
                    URLParser parser = new URLParser(serverUrl);
                    String hostname = parser.getHostname();
                    int port = parser.getPort(true);
                    result = ToolBoxRunner.runToolBoxItem(item, hostname, port, null);
                    ToolboxDatapointThreshold.this.setResult(item, result);
                }
                if (CentralDebugging.ALERT_TOOL_RUNNING_DEBUG) {
                    System.out.println("\tStdout: " + result.stdout);
                }
                if (CentralDebugging.ALERT_TOOL_RUNNING_DEBUG) {
                    System.out.println("\tStderr: " + result.stderr);
                }
                int retcode = result.returnCode;
                ToolboxDatapointThreshold.this.matched = "" + retcode;
                ToolboxDatapointThreshold.this.reason = "${TOOLBOX_RETURNED_CODE} " + ToolboxDatapointThreshold.this.matched;
                try {
                    if (result.stdout != null) {
                        StringBuilder builder = new StringBuilder();
                        Pattern p = Pattern.compile("<tool_reason>(.*)</tool_reason>");
                        Matcher matcher = p.matcher(result.stdout);
                        while (matcher.find()) {
                            String reasonAppendage;
                            if (matcher.groupCount() <= 0 || (reasonAppendage = matcher.group(1)) == null) continue;
                            builder.append("\n").append(reasonAppendage);
                        }
                        if (builder.length() > 0) {
                            ToolboxDatapointThreshold.this.reason = builder.length() > 1024 ? ToolboxDatapointThreshold.this.reason + "\n" + builder.substring(0, 1020) + " ..." : ToolboxDatapointThreshold.this.reason + "\n" + builder.toString();
                        }
                    }
                }
                catch (Throwable t) {
                    System.out.println("[ToolboxDatapointThreshold] Unable to parse stdout");
                    t.printStackTrace();
                }
                boolean state = retcode == 0 && !ToolboxDatapointThreshold.this.nonzero ? true : retcode != 0 && ToolboxDatapointThreshold.this.nonzero;
                if (CentralDebugging.ALERT_TOOL_RUNNING_DEBUG) {
                    System.out.println("\tResult is retcode=" + retcode + ". Final state=" + state);
                }
                ToolboxDatapointThreshold.this.updateTriggeredState(state);
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            finally {
                ToolboxDatapointThreshold.this.currentRun = null;
            }
        }
    }
}

