/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import jwrapper.jwutils.JWWmi;
import jwrapper.jwutils.wmi.JWWmiQueryResult;
import utils.message.Message;
import utils.message.TypedMap;
import utils.osstats.Stats;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.string.CharStack;
import utils.string.SimpleRegex;

public class ServiceRunningThreshold
extends Alert {
    public static final Object ID = "ServiceRunningTrigger";
    private String nameMatch = null;
    private boolean running = true;
    String matched;
    String reason;
    public static final String KEY_MATCHED = "${CONTEXT_KEY_MATCHED_SERV}";
    private static boolean checkedForServiceCommand = false;
    private static String serviceCommand = null;
    private static boolean checkedForInitCtlCommand = false;
    private static String initctlCommand = null;
    private static boolean checkedForSystemCtlCommand = false;
    private static String systemCtlCommand = null;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_SERVICE_RUN_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_SERVICE_RUN_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/window.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/users/runner.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.running) {
            return Language.get("ALERT_SERVICE_RUNNING", this.nameMatch);
        }
        return Language.get("ALERT_SERVICE_NOTRUNNING", this.nameMatch);
    }

    @Override
    public Alert createCorollary() {
        ServiceRunningThreshold clone = (ServiceRunningThreshold)this.cloneWithNewID();
        clone.running = !clone.running;
        return clone;
    }

    public void setTriggerOnService(String nameMatch, boolean running) {
        this.running = running;
        this.nameMatch = nameMatch;
    }

    public String getServiceName() {
        return this.nameMatch;
    }

    public boolean getTriggerIfRunning() {
        return this.running;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.nameMatch);
        m.append(this.running);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.nameMatch = m.getNextString();
        this.running = m.getNextBoolean();
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_MATCHED);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_MATCHED, this.matched);
        return map;
    }

    @Override
    public void machineStats(Stats stats) {
        StringBuffer sb;
        Pattern pattern;
        int result;
        boolean isRunning;
        if (CentralDebugging.ALERT_SERVICE_RUNNING_DEBUG) {
            System.out.println("[ServiceRunningThreshold] Checking to see if process " + this.nameMatch + " running=" + this.running);
        }
        boolean bl = isRunning = (result = ServiceRunningThreshold.isServiceRunning(pattern = SimpleRegex.simpleToPattern(this.nameMatch, false), sb = new StringBuffer())) == 1;
        if (isRunning) {
            this.matched = sb.toString();
            this.reason = "${ALERT_CONTEXT_FOUND_SERVICE}" + sb;
        } else {
            this.matched = null;
            this.reason = "${ALERT_CONTEXT_NO_MATCHED_SERV}";
        }
        boolean state = this.running && isRunning ? true : !this.running && !isRunning;
        if (CentralDebugging.ALERT_SERVICE_RUNNING_DEBUG) {
            System.out.println("\tResult is running=" + this.running + " and isRunning=" + isRunning + ". Final state=" + state);
        }
        this.updateTriggeredState(state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int isServiceRunning(Pattern pattern, StringBuffer serviceInfo) {
        if (OS.isWindows()) {
            JWWmiQueryResult result = JWWmi.runQuery((String)"SELECT DisplayName,Name,State FROM Win32_Service");
            if (!result.hasProperties()) return -1;
            for (Properties p : result.getProperties()) {
                String name = p.getProperty("Name");
                String displayName = p.getProperty("DisplayName");
                String serviceState = p.getProperty("State");
                if (CentralDebugging.ALERT_SERVICE_RUNNING_DEBUG) {
                    System.out.println("\t[ServiceRunningThreshold] Checking " + name + " / " + displayName + " / " + serviceState);
                }
                if ((name == null || !pattern.matcher(name).matches()) && (displayName == null || !pattern.matcher(displayName).matches())) continue;
                if (!serviceState.equalsIgnoreCase("running")) return -1;
                if (CentralDebugging.ALERT_SERVICE_RUNNING_DEBUG) {
                    System.out.println("\t[ServiceRunningThreshold] Matched service is running");
                }
                if (displayName != null) {
                    serviceInfo.append(displayName);
                }
                if (name == null) return 1;
                if (serviceInfo.length() > 0) {
                    serviceInfo.append(" (" + name + ")");
                    return 1;
                } else {
                    serviceInfo.append(name);
                }
                return 1;
            }
            return -1;
        } else if (OS.isMacOS()) {
            RunCommandGetOutput.CommandResponse commandResponse = RunCommandGetOutput.runCommand((String[])new String[]{"launchctl", "list"});
            if (commandResponse == null || commandResponse.stdout == null) return -1;
            CharStack stack = new CharStack(commandResponse.stdout);
            stack.popUntil('\n', false);
            stack.popWhitespace();
            while (!stack.isEmpty()) {
                String pid = stack.popText(true);
                stack.popWhitespace();
                stack.popText(true);
                stack.popWhitespace();
                String label = stack.popText(true);
                stack.popWhitespace();
                if (label == null || !pattern.matcher(label).matches()) continue;
                if (pid.equalsIgnoreCase("-")) return 0;
                serviceInfo.append(label);
                return 1;
            }
            return -1;
        } else {
            RunCommandGetOutput.CommandResponse commandResponse;
            String service;
            RunCommandGetOutput.CommandResponse commandResponse2;
            String systemctl;
            RunCommandGetOutput.CommandResponse commandResponse3;
            if (!OS.isLinux()) return -1;
            String initCtl = ServiceRunningThreshold.getInitctlCommand();
            if (initCtl != null && (commandResponse3 = RunCommandGetOutput.runCommand((String[])new String[]{initCtl, "list"})) != null && commandResponse3.stdout != null) {
                String[] lines;
                for (String line : lines = commandResponse3.stdout.split("\n")) {
                    String[] parts;
                    int comma = line.indexOf(44);
                    if (comma != -1) {
                        line = line.substring(0, comma);
                    }
                    if ((parts = line.split(" ")).length <= 1) continue;
                    String name = parts[0];
                    String status = parts[1];
                    if (name == null || !pattern.matcher(name).matches()) continue;
                    if (!status.contains("/running")) return 0;
                    serviceInfo.append(name);
                    return 1;
                }
            }
            if ((systemctl = ServiceRunningThreshold.getSystemCtlCommand()) != null && (commandResponse2 = RunCommandGetOutput.runCommand((String[])new String[]{initCtl, "list-units", "--type=service"})) != null && commandResponse2.stdout != null) {
                CharStack result = new CharStack(commandResponse2.stdout);
                result.popUntil('\n', false);
                result.popWhitespace();
                while (!result.isEmpty()) {
                    String name = result.popText(true);
                    result.popWhitespace();
                    String load = result.popText(true);
                    result.popWhitespace();
                    String sub = result.popText(true);
                    if (name != null && pattern.matcher(name).matches()) {
                        if (!load.contains("active") || !sub.contains("running")) return 0;
                        return 1;
                    }
                    result.popUntil('\n', false);
                }
            }
            if ((service = ServiceRunningThreshold.getServiceCommand()) == null || (commandResponse = RunCommandGetOutput.runCommand((String[])new String[]{service, "--status-all"})) == null || commandResponse.stdout == null) return -1;
            CharStack result = new CharStack(commandResponse.stdout.trim());
            while (!result.isEmpty()) {
                result.popWhitespace();
                result.pop();
                result.popWhitespace();
                char state = result.pop();
                result.popWhitespace();
                result.pop();
                result.popWhitespace();
                String name = result.popText(true);
                if (name != null && pattern.matcher(name).matches()) {
                    if (state != '+') return 0;
                    return 1;
                }
                result.popUntil('\n', false);
            }
        }
        return -1;
    }

    private static String detectCommand(String name) {
        File service = new File("/usr/sbin/" + name);
        if (service.exists()) {
            return service.getPath();
        }
        service = new File("/sbin/" + name);
        if (service.exists()) {
            return service.getPath();
        }
        RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand((String[])new String[]{"/bin/sh", "which", name});
        if (response != null && response.returnCode == 0) {
            return response.stdout.trim();
        }
        return null;
    }

    public static String getServiceCommand() {
        if (checkedForServiceCommand) {
            return serviceCommand;
        }
        try {
            String string = serviceCommand = ServiceRunningThreshold.detectCommand("service");
            return string;
        }
        finally {
            System.out.println("[ServiceRunningThreshold] Detected (" + serviceCommand + ")");
            checkedForServiceCommand = true;
        }
    }

    public static String getInitctlCommand() {
        if (checkedForInitCtlCommand) {
            return initctlCommand;
        }
        try {
            String string = initctlCommand = ServiceRunningThreshold.detectCommand("initctl");
            return string;
        }
        finally {
            System.out.println("[ServiceRunningThreshold] Detected (" + initctlCommand + ")");
            checkedForInitCtlCommand = true;
        }
    }

    public static String getSystemCtlCommand() {
        if (checkedForSystemCtlCommand) {
            return systemCtlCommand;
        }
        try {
            String string = systemCtlCommand = ServiceRunningThreshold.detectCommand("systemctl");
            return string;
        }
        finally {
            System.out.println("[ServiceRunningThreshold] Detected (" + systemCtlCommand + ")");
            checkedForSystemCtlCommand = true;
        }
    }

    public static void main(String[] args) {
        Pattern p = SimpleRegex.simpleToPattern(args[0], false);
        System.out.println(ServiceRunningThreshold.isServiceRunning(p, new StringBuffer()));
    }
}

