/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.alerts.threshold.generic.SimpleProcessThreshold;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Pattern;
import utils.message.Message;
import utils.message.TypedMap;
import utils.osstats.Stats;
import utils.string.SimpleRegex;

public class ProcMemoryUsageThreshold
extends Alert
implements SimpleProcessThreshold {
    public static final Object ID = "ProcMemoryUsageTrigger";
    double trig = 90.0;
    boolean over = true;
    String procMatch = null;
    public static final String KEY_MEM = "${CONTEXT_KEY_PMEM}";
    public static final String KEY_MEM_PROC = "${CONTEXT_KEY_PMEM_PROC}";
    public static final String KEY_MEM_PID = "${CONTEXT_KEY_PMEM_PID}";
    public static final String KEY_MEM_CMD = "${CONTEXT_KEY_PMEM_CMD}";
    public static final String KEY_MEM_SUMMARY = "${CONTEXT_KEY_PMEM_SUMMARY}";
    public static final String KEY_MEM_PROCS = "${CONTEXT_KEY_PMEM_PROCS}";
    String reason;
    DecimalFormat df = new DecimalFormat("########0.0");
    String memProcs;
    String memCmd;
    String memProc;
    String memPid;
    String memSummary;
    double memUsage = -99.0;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_PROC_MEM_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_PROC_MEM_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/window.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/computing/memory.svg,24";
    }

    @Override
    public String getResourceKey() {
        return "ALERT_CONFIG_TRIGGER_MEMORY_LVL";
    }

    @Override
    public String getResourceUnit() {
        return "%";
    }

    private String getProcName() {
        if (this.procMatch == null) {
            this.procMatch = "";
        }
        if (this.procMatch.length() == 0) {
            return Language.get("ALERT_ANY");
        }
        return "'" + this.procMatch + "'";
    }

    @Override
    public String getDefaultName() {
        if (this.over) {
            return Language.get("ALERT_PROC_MEM_OVER", this.getProcName(), this.trig + "%");
        }
        return Language.get("ALERT_PROC_MEM_UNDER", this.getProcName(), this.trig + "%");
    }

    @Override
    public Alert createCorollary() {
        ProcMemoryUsageThreshold clone = (ProcMemoryUsageThreshold)this.cloneWithNewID();
        clone.over = !clone.over;
        return clone;
    }

    @Override
    public void setTriggerOnOver(boolean b) {
        this.over = b;
    }

    @Override
    public void setTriggerPercent(double d) {
        this.trig = d;
    }

    @Override
    public double getTriggerPercent() {
        return this.trig;
    }

    @Override
    public boolean getTriggerOnOver() {
        return this.over;
    }

    @Override
    public void setMatchString(String s) {
        this.procMatch = s;
    }

    @Override
    public String getMatchString() {
        return this.procMatch;
    }

    public boolean isMatchRequired() {
        return false;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.trig);
        m.append(this.over);
        m.append(this.procMatch);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.trig = m.getNextDouble();
        this.over = m.getNextBoolean();
        this.procMatch = m.getNextString();
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_MEM);
        keys.add(KEY_MEM_PROC);
        keys.add(KEY_MEM_PID);
        keys.add(KEY_MEM_CMD);
        keys.add(KEY_MEM_SUMMARY);
        keys.add(KEY_MEM_PROCS);
        return keys;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_MEM, this.df.format(this.memUsage));
        map.setString(KEY_MEM_PROC, this.memProc);
        map.setString(KEY_MEM_CMD, this.memCmd);
        map.setString(KEY_MEM_PID, this.memPid);
        map.setString(KEY_MEM_SUMMARY, this.memSummary);
        map.setString(KEY_MEM_PROCS, this.memProcs);
        return map;
    }

    @Override
    public void machineStats(Stats stats) {
        Stats.ProcessStatistic[] procs = (Stats.ProcessStatistic[])stats.getProcessStatistics().clone();
        double max = 0.0;
        if (this.procMatch == null) {
            this.procMatch = "";
        }
        Pattern pattern = null;
        if (this.procMatch.length() > 0) {
            pattern = SimpleRegex.simpleToPattern(this.procMatch, false);
        }
        Stats.ProcessStatistic matchedProc = null;
        for (Stats.ProcessStatistic proc : procs) {
            if (pattern == null) {
                if (!((double)proc.memPercentage > max)) continue;
                matchedProc = proc;
                max = proc.memPercentage;
                continue;
            }
            if (!pattern.matcher(proc.name).matches() || !((double)proc.memPercentage > max)) continue;
            matchedProc = proc;
            max = proc.memPercentage;
        }
        boolean state = this.over && max > this.trig ? true : !this.over && max < this.trig;
        if (matchedProc != null) {
            this.reason = max > this.trig ? "${PROCESS} " + matchedProc.name + " (" + matchedProc.id + ") ${MEMORY} " + matchedProc.memPercentage + "% > " + this.trig + "%" : "${PROCESS} " + matchedProc.name + " (" + matchedProc.id + ") ${MEMORY} " + matchedProc.memPercentage + "% < " + this.trig + "%";
            this.memSummary = matchedProc.memPercentage + "% " + matchedProc.name + " (" + matchedProc.id + ") [" + matchedProc.cmdLineArgs + "]";
            this.memCmd = matchedProc.cmdLineArgs;
            this.memProc = matchedProc.name;
            this.memPid = matchedProc.id;
            this.memUsage = matchedProc.memPercentage;
        } else {
            this.reason = "${ALERT_CONTEXT_NO_MATCHED_PROC}";
            this.memSummary = null;
            this.memCmd = null;
            this.memProc = null;
            this.memPid = null;
            this.memUsage = 0.0;
        }
        Arrays.sort(procs, new Comparator<Stats.ProcessStatistic>(){

            @Override
            public int compare(Stats.ProcessStatistic o1, Stats.ProcessStatistic o2) {
                Integer i1 = o1.memPercentage;
                Integer i2 = o2.memPercentage;
                return i2.compareTo(i1);
            }
        });
        int documented = 0;
        HashMap<String, String> pids = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < procs.length; ++i) {
            String PID = "" + procs[i].id;
            if (!pids.containsKey(PID)) {
                pids.put(PID, PID);
                ++documented;
                sb.append(procs[i].memPercentage).append("%");
                sb.append(" ").append(procs[i].name);
                sb.append(" (").append(procs[i].id).append(")");
                sb.append(" [").append(procs[i].cmdLineArgs).append("]");
                sb.append("\n\n");
            }
            if (documented >= 15) break;
        }
        this.memProcs = sb.toString();
        this.updateTriggeredState(state);
    }
}

