/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.alerts.threshold.generic.SimplePercentThreshold;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import utils.message.Message;
import utils.message.TypedMap;
import utils.osstats.Stats;

public class MemoryUsageThreshold
extends Alert
implements SimplePercentThreshold {
    public static final Object ID = "MemoryUsageTrigger";
    double trig = 90.0;
    boolean over = true;
    public static final String KEY_MEMORY = "${CONTEXT_KEY_MEMORY_PC}";
    public static final String KEY_MEMORY_USED = "${CONTEXT_KEY_MEMORY_USED}";
    public static final String KEY_MEMORY_FREE = "${CONTEXT_KEY_MEMORY_FREE}";
    public static final String KEY_MEMORY_PROCS = "${CONTEXT_KEY_MEMORY_PROCS}";
    DecimalFormat df = new DecimalFormat("#####################0.0");
    double memoryPercent;
    long memoryUsed;
    long memoryFree;
    String memoryProcs;
    String reason;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_MEM_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_MEM_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/technology/screen.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/computing/memory.svg,24";
    }

    @Override
    public String getResourceKey() {
        return "ALERT_CONFIG_TRIGGER_MEMORY_LVL";
    }

    @Override
    public String getResourceUnit() {
        return "%";
    }

    @Override
    public String getDefaultName() {
        if (this.over) {
            return Language.get("ALERT_MEM_OVER", this.trig + "%");
        }
        return Language.get("ALERT_MEM_UNDER", this.trig + "%");
    }

    @Override
    public Alert createCorollary() {
        MemoryUsageThreshold clone = (MemoryUsageThreshold)this.cloneWithNewID();
        clone.over = !clone.over;
        return clone;
    }

    @Override
    public void setTriggerOnOver(boolean b) {
        this.over = b;
    }

    @Override
    public void setTriggerPercent(double d) {
        this.trig = d;
    }

    @Override
    public boolean getTriggerOnOver() {
        return this.over;
    }

    @Override
    public double getTriggerPercent() {
        return this.trig;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.trig);
        m.append(this.over);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.trig = m.getNextDouble();
        this.over = m.getNextBoolean();
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_MEMORY);
        keys.add(KEY_MEMORY_USED);
        keys.add(KEY_MEMORY_FREE);
        keys.add(KEY_MEMORY_PROCS);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_MEMORY, this.df.format(this.memoryPercent));
        map.setString(KEY_MEMORY_USED, "" + this.memoryUsed);
        map.setString(KEY_MEMORY_FREE, "" + this.memoryFree);
        map.setString(KEY_MEMORY_PROCS, "" + this.memoryProcs);
        return map;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void machineStats(Stats stats) {
        boolean state;
        double memoryUsedPercent;
        this.memoryPercent = memoryUsedPercent = stats.getMemoryUsedPercent();
        this.memoryFree = (long)stats.getMemoryFree();
        this.memoryUsed = (long)stats.getMemoryUsed();
        Stats.ProcessStatistic[] procs = (Stats.ProcessStatistic[])stats.getProcessStatistics().clone();
        Arrays.sort(procs, new Comparator<Stats.ProcessStatistic>(){

            @Override
            public int compare(Stats.ProcessStatistic o1, Stats.ProcessStatistic o2) {
                Integer i1 = o1.memPercentage;
                Integer i2 = o2.memPercentage;
                return i2.compareTo(i1);
            }
        });
        int documented = 0;
        HashMap<String, String> pids = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < procs.length; ++i) {
            String PID = "" + procs[i].id;
            if (!pids.containsKey(PID)) {
                pids.put(PID, PID);
                ++documented;
                sb.append(procs[i].memPercentage).append("%");
                sb.append(" ").append(procs[i].name);
                sb.append(" (").append(procs[i].id).append(")");
                sb.append(" [").append(procs[i].cmdLineArgs).append("]");
                sb.append("\n\n");
            }
            if (documented >= 15) break;
        }
        this.memoryProcs = sb.toString();
        if (CentralDebugging.ALERT_MEMORY_DEBUG) {
            System.out.println("[MemoryUsageThreshold] Memory usage is currently " + memoryUsedPercent);
        }
        if (this.over && memoryUsedPercent > this.trig) {
            state = true;
            this.reason = "${ALERT_CONTEXT_MEM} " + this.df.format(memoryUsedPercent) + "% > " + this.trig + "%";
        } else if (!this.over && memoryUsedPercent < this.trig) {
            state = true;
            this.reason = "${ALERT_CONTEXT_MEM} " + this.df.format(memoryUsedPercent) + "% < " + this.trig + "%";
        } else {
            state = false;
            this.reason = this.over ? "${ALERT_CONTEXT_MEM} " + this.df.format(memoryUsedPercent) + "% <= " + this.trig + "%" : "${ALERT_CONTEXT_MEM} " + this.df.format(memoryUsedPercent) + "% >= " + this.trig + "%";
        }
        this.updateTriggeredState(state);
    }
}

