/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.alerts.threshold.generic.SimplePercentThreshold;
import com.aem.shelp.util.SimpleRegex;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;
import utils.message.Message;
import utils.message.TypedMap;
import utils.osstats.Stats;
import utils.progtools.DataUtil;

public class DiskSpaceThreshold
extends Alert
implements SimplePercentThreshold {
    public static final String ID = "DiskSpaceTrigger";
    public static final byte MODE_PERCENTAGE = 0;
    public static final byte MODE_FREE_SPACE = 1;
    private byte mode = 0;
    private double diskSpacePercentageThreshold = 90.0;
    private double freeSpaceThresholdValue;
    private long freeSpaceThresholdUnits;
    private boolean over = true;
    private double minimumDiskSize;
    private long minimumDiskSizeUnits;
    private DecimalFormat df = new DecimalFormat("###,###,###,###,###,###,##0");
    String diskStatus;
    String reason;
    private String[] exclusions;
    private final Object LOCK = new Object();
    private transient Pattern[] exclusionPatterns;
    private boolean isExclude = true;
    public static final String KEY_DISKS_STATUS = "${CONTEXT_KEY_DISKS}";

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_DISKS_STATUS);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_DISKS_STATUS, this.diskStatus);
        return map;
    }

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public Alert createCorollary() {
        DiskSpaceThreshold clone = (DiskSpaceThreshold)this.cloneWithNewID();
        clone.over = !clone.over;
        return clone;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_DISK_SPACE_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_DISK_SPACE_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/technology/screen.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/computing/database.svg,24";
    }

    @Override
    public String getResourceKey() {
        return "ALERT_CONFIG_TRIGGER_DISK_LVL";
    }

    @Override
    public String getResourceUnit() {
        return "%";
    }

    @Override
    public String getDefaultName() {
        if (this.mode == 0) {
            if (this.over) {
                return Language.get("ALERT_DISK_SPACE_OVER", this.diskSpacePercentageThreshold + "%");
            }
            return Language.get("ALERT_DISK_SPACE_UNDER", this.diskSpacePercentageThreshold + "%");
        }
        String sensibleSize = DataUtil.getSensibleSize((long)((long)((double)this.freeSpaceThresholdUnits * this.freeSpaceThresholdValue)));
        if (this.over) {
            return Language.get("ALERT_DISK_FREE_SPACE_OVER", sensibleSize);
        }
        return Language.get("ALERT_DISK_FREE_SPACE_UNDER", sensibleSize);
    }

    public boolean isPercentageMode() {
        return this.mode == 0;
    }

    @Override
    public void setTriggerOnOver(boolean b) {
        this.over = b;
    }

    @Override
    public boolean getTriggerOnOver() {
        return this.over;
    }

    @Override
    public void setTriggerPercent(double d) {
        this.diskSpacePercentageThreshold = d;
    }

    @Override
    public double getTriggerPercent() {
        return this.diskSpacePercentageThreshold;
    }

    public void setFreeSpace(double value, long units) {
        this.freeSpaceThresholdUnits = units;
        this.freeSpaceThresholdValue = value;
    }

    public double getFreeSpaceValue() {
        return this.freeSpaceThresholdValue;
    }

    public long getFreeSpaceUnits() {
        return this.freeSpaceThresholdUnits;
    }

    public double getMinimumDiskSize() {
        return this.minimumDiskSize;
    }

    public long getMinimumDiskSizeUnits() {
        return this.minimumDiskSizeUnits;
    }

    public void setMinimumDiskSize(double size, long units) {
        this.minimumDiskSize = size;
        this.minimumDiskSizeUnits = units;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.diskSpacePercentageThreshold);
        m.append(this.over);
        m.append(this.mode);
        m.append(this.freeSpaceThresholdValue);
        m.append(this.freeSpaceThresholdUnits);
        m.append(this.minimumDiskSize);
        m.append(this.minimumDiskSizeUnits);
        if (this.exclusions == null) {
            m.append(new String[0]);
        } else {
            m.append(this.exclusions);
        }
        m.append(this.isExclude);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.diskSpacePercentageThreshold = m.getNextDouble();
        this.over = m.getNextBoolean();
        if (this.version >= 10) {
            this.mode = m.getNextByte();
            this.freeSpaceThresholdValue = m.getNextDouble();
            this.freeSpaceThresholdUnits = m.getNextLong();
            this.minimumDiskSize = m.getNextDouble();
            this.minimumDiskSizeUnits = m.getNextLong();
            this.exclusions = m.getNextStringArray();
            this.exclusionPatterns = null;
            if (this.version >= 14) {
                this.isExclude = m.getNextBoolean();
            }
        } else {
            this.mode = 0;
        }
    }

    @Override
    public void machineStats(Stats stats) {
        boolean ON;
        long minimumDiskSizeBytes = (long)((double)this.minimumDiskSizeUnits * this.minimumDiskSize);
        StringBuilder status = new StringBuilder();
        if (stats.getDiskSpaceStatistic() != null) {
            for (Stats.DiskSpaceStatistic diskSpaceStatistic : stats.getDiskSpaceStatistic()) {
                if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
                    System.out.println("[DiskSpaceThreshold] Disk: " + diskSpaceStatistic.name + " / used:" + diskSpaceStatistic.used + " / free:" + diskSpaceStatistic.free + " / perc:" + diskSpaceStatistic.getDiskUsagePercent() + " / " + diskSpaceStatistic.isRecovery + " / " + diskSpaceStatistic.isShared);
                }
                status.append("${ALERT_CONTEXT_DISK_NAME}").append(diskSpaceStatistic.name).append(" / ${ALERT_CONTEXT_DISK_USED}").append(diskSpaceStatistic.used).append(" / ${ALERT_CONTEXT_DISK_FREE}").append(diskSpaceStatistic.free).append(" / ${ALERT_CONTEXT_DISK_PERC}").append(diskSpaceStatistic.getDiskUsagePercent()).append(" / ${ALERT_CONTEXT_DISK_RECOVERY}").append(diskSpaceStatistic.isRecovery).append(" / ${ALERT_CONTEXT_DISK_SHARED}").append(diskSpaceStatistic.isShared);
                status.append("\n");
            }
        }
        this.diskStatus = status.toString();
        if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
            System.out.println("[DiskSpaceThreshold] Minimum size is " + minimumDiskSizeBytes);
        }
        if (this.exclusions != null) {
            for (String string : this.exclusions) {
                if (!CentralDebugging.ALERT_DISK_SPACE_DEBUG) continue;
                System.out.println("[DiskSpaceThreshold] " + (this.isExclude ? "Excluding" : "Including") + " '" + string + "'");
            }
        }
        if (this.mode == 0) {
            if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
                System.out.println("[DiskSpaceThreshold] Checking percentage " + this.diskSpacePercentageThreshold + " over:" + this.over);
            }
            StringBuffer stringBuffer = new StringBuffer();
            double max = stats.getMaxDiskUsagePercent(minimumDiskSizeBytes, this.getExclusionPatterns(), this.isExclude, stringBuffer);
            if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
                System.out.println("[DiskSpaceThreshold] Max disk usage percentage is " + max);
            }
            if (max > this.diskSpacePercentageThreshold) {
                this.reason = stringBuffer.toString() + " " + this.df.format(max) + "% ${ALERT_CONTEXT_DISK_MAX_USED} > " + this.diskSpacePercentageThreshold + "%";
                ON = this.over;
            } else {
                this.reason = stringBuffer.toString() + " " + this.df.format(max) + "% ${ALERT_CONTEXT_DISK_MAX_USED} < " + this.diskSpacePercentageThreshold + "%";
                ON = !this.over;
            }
        } else {
            Stats.DiskSpaceStatistic[] drives;
            if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
                System.out.println("[DiskSpaceThreshold] Checking free space size " + this.freeSpaceThresholdValue + "/" + this.freeSpaceThresholdUnits + " over:" + this.over);
            }
            ON = false;
            long l = (long)((double)this.freeSpaceThresholdUnits * this.freeSpaceThresholdValue);
            if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
                System.out.println("[DiskSpaceThreshold] Threshold free disk space is " + l + " bytes");
            }
            for (Stats.DiskSpaceStatistic drive : drives = stats.getMeaningfulDriveList(this.getExclusionPatterns(), this.isExclude)) {
                long free = drive.free;
                if (CentralDebugging.ALERT_DISK_SPACE_DEBUG) {
                    System.out.println("[DiskSpaceThreshold] Disk free is " + free);
                }
                if ((!this.over || free <= l) && (this.over || free >= l)) continue;
                this.reason = this.over ? drive.name + " " + this.df.format(free) + " ${ALERT_CONTEXT_DISK_FREE_SPACE} > " + this.df.format(l) : drive.name + " " + this.df.format(free) + " ${ALERT_CONTEXT_DISK_FREE_SPACE} < " + this.df.format(l);
                ON = true;
                break;
            }
            this.reason = "${ALERT_CONTEXT_DISK_FREE_OK}";
        }
        this.updateTriggeredState(ON);
    }

    public String[] getExclusions() {
        return this.exclusions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern[] getExclusionPatterns() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.exclusionPatterns == null) {
                this.exclusionPatterns = new Pattern[this.exclusions.length];
                for (int i = 0; i < this.exclusions.length; ++i) {
                    this.exclusionPatterns[i] = SimpleRegex.simpleToPattern(this.exclusions[i], true);
                }
            }
        }
        return this.exclusionPatterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExclusions(String[] exclusions) {
        Object object = this.LOCK;
        synchronized (object) {
            this.exclusions = exclusions;
            this.exclusionPatterns = null;
        }
    }

    public boolean isExclude() {
        return this.isExclude;
    }

    public void setExclude(boolean isExclude) {
        this.isExclude = isExclude;
    }
}

