/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.util.ArrayList;
import utils.message.Message;
import utils.osstats.av.SecurityProduct;
import utils.ostools.OS;

public class AntiVirusThreshold
extends Alert {
    public static final Object ID = "AntiVirusTrigger";
    boolean triggerIfMissing = true;
    boolean triggerWindows = true;
    boolean triggerMac = true;
    boolean acceptDefender = true;
    String reason;

    @Override
    public Alert createCorollary() {
        AntiVirusThreshold clone = (AntiVirusThreshold)this.cloneWithNewID();
        clone.triggerIfMissing = !clone.triggerIfMissing;
        return clone;
    }

    public boolean canAcceptDefender() {
        return this.acceptDefender;
    }

    public void setAcceptDefender(boolean acceptDefender) {
        this.acceptDefender = acceptDefender;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_PROC_AV_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_PROC_AV_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/window.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/security/shield.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.triggerIfMissing) {
            return Language.get("ALERT_AV_NOTVERIFIED");
        }
        return Language.get("ALERT_AV_VERIFIED");
    }

    public void setTriggerIfMissing(boolean b) {
        this.triggerIfMissing = b;
    }

    public boolean getTriggerIfMissing() {
        return this.triggerIfMissing;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        Message extras = new Message();
        extras.append(this.acceptDefender);
        m.append(extras);
        m.append(this.triggerIfMissing);
        m.append(this.triggerWindows);
        m.append(this.triggerMac);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        if (m.getNextType() == 4) {
            Message extras = m.getNextMessage();
            this.acceptDefender = extras.getNextBoolean();
        }
        this.triggerIfMissing = m.getNextBoolean();
        this.triggerWindows = m.getNextBoolean();
        this.triggerMac = m.getNextBoolean();
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void securityStats(ArrayList<SecurityProduct> secs) {
        if (OS.isWindows() && this.triggerWindows) {
            boolean foundAndOk = false;
            for (SecurityProduct sec : secs) {
                if (!this.acceptDefender && sec.getName().toLowerCase().contains("windows defender") || sec.isFirewall() || !sec.isActive() || !sec.isUpToDate()) continue;
                foundAndOk = true;
                this.reason = "${ALERT_CONTEXT_AV_OK} " + sec.getName();
            }
            if (!foundAndOk) {
                this.reason = "${ALERT_CONTEXT_AV_NONE}";
            }
            if (foundAndOk) {
                if (!this.triggerIfMissing) {
                    this.updateTriggeredState(true);
                } else {
                    this.updateTriggeredState(false);
                }
            } else if (this.triggerIfMissing) {
                this.updateTriggeredState(true);
            } else {
                this.updateTriggeredState(false);
            }
        } else if (!OS.isMacOS() || !this.triggerMac) {
            this.updateTriggeredState(false);
        }
    }
}

