/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import bcutil.BCUtil;
import com.aem.shelp.proxy.logging.access.RemoteMachineOfflineExtended;
import com.aem.shelp.proxy.types.ActionableResourceContainer;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.filters.LogFilter;
import utils.loggingframework.logmapping.LogMapping;
import utils.loggingframework.targets.AbstractTarget;
import utils.message.Message;
import utils.string.StringUtil;

public class ServerEvent
extends ActionableResourceContainer
implements LogMapping {
    public static final String SERIALISATION_ID = "ServerEvent";
    private transient Object uiMetadata = null;
    private String[] logEventIDs;
    private LogFilter[] filters = null;
    private MachineName eventName;
    private String id = ServerEvent.nextID();
    private long remoteAccessMachineExtendedTimeout = 300000L;

    public void setRemoteAccessExtendedTimeout(long timeout) {
        this.remoteAccessMachineExtendedTimeout = timeout;
    }

    public static String nextID() {
        return "SE-" + Math.abs(BCUtil.getSecureRandom().nextLong());
    }

    @Override
    public String[] getLogEventIDs() {
        return this.logEventIDs;
    }

    public void setLogEventIDs(String[] logIDs) {
        this.logEventIDs = logIDs;
    }

    public void setName(String s) {
        this.eventName = new MachineName(s);
    }

    @Override
    public void setName(MachineName name) {
        this.eventName = name;
    }

    @Override
    public MachineName getName() {
        return this.eventName;
    }

    public static ServerEvent createTestAlert() {
        ServerEvent sea = new ServerEvent();
        return sea;
    }

    @Override
    public Machine.MachineChanges copyStateFrom(TreeElement sourceElement) {
        ServerEvent source = (ServerEvent)sourceElement;
        Machine.MachineChanges changes = new Machine.MachineChanges();
        changes.nameChange = false;
        if (!sourceElement.getName().equals(this.getName())) {
            changes.nameChange = true;
        }
        this.filters = source.getFilters();
        this.logEventIDs = source.logEventIDs;
        this.triggerTargets = source.triggerTargets;
        this.resetTargets = source.resetTargets;
        return changes;
    }

    @Override
    public AbstractTarget[] getTargets() {
        return this.triggerTargets;
    }

    public void setTargets(AbstractTarget[] target) {
        this.triggerTargets = target;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public boolean matchesFilter(String filter) {
        filter = filter.toLowerCase();
        MachineName name = this.getName();
        return name.toString().toLowerCase().contains(filter);
    }

    public Object getUIMetadata() {
        return this.uiMetadata;
    }

    public void setUIMetadata(Object metadata) {
        this.uiMetadata = metadata;
    }

    public String toString() {
        return this.getName().toString();
    }

    public long getPreviousTriggerTime() {
        return 0L;
    }

    public long getTriggerDuration() {
        return 0L;
    }

    public boolean equals(Object o) {
        if (o instanceof ServerEvent) {
            ServerEvent m = (ServerEvent)o;
            return StringUtil.equal((String)m.getID(), (String)this.getID());
        }
        return false;
    }

    public long getRemoteAccessMachineExtendedTimeout() {
        return this.remoteAccessMachineExtendedTimeout;
    }

    public boolean includesRemoteAccessOfflineExtendedEvent() {
        if (this.logEventIDs == null) {
            return false;
        }
        for (String logEventID : this.logEventIDs) {
            if (!logEventID.equals("RemoteMachineOfflineExt")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void fromMessage(byte version, Message m) {
        super.fromMessage(version, m);
        this.id = m.getNextString();
        this.eventName = MachineName.extractFromNameWithGroup(m.getNextString());
        this.logEventIDs = m.getNextStringArray();
        int filterCount = m.getNextInt();
        this.filters = new LogFilter[filterCount];
        for (int i = 0; i < filterCount; ++i) {
            LogFilter f;
            Message filterMessage = m.getNextMessage();
            this.filters[i] = f = LogFilter.newFromMessage(filterMessage);
        }
        if (m.hasNext()) {
            Message newerStuff = m.getNextMessage();
            this.fromMessageAppend(newerStuff);
        }
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.id);
        if (this.eventName == null) {
            m.append((String)null);
        } else {
            m.append(this.eventName.toString());
        }
        m.append(this.logEventIDs);
        if (this.filters == null) {
            m.append(0);
        } else {
            m.append(this.filters.length);
            for (LogFilter filter : this.filters) {
                Message filterMessage = new Message();
                filter.toMessage(filterMessage);
                m.append(filterMessage);
            }
        }
        m.append(this.toMessageAppend());
    }

    @Override
    protected Message toMessageAppend() {
        Message m = new Message();
        Message parent = super.toMessageAppend();
        m.append(parent);
        if (this.includesRemoteAccessOfflineExtendedEvent()) {
            m.append(this.remoteAccessMachineExtendedTimeout);
        }
        return m;
    }

    @Override
    protected void fromMessageAppend(Message m) {
        super.fromMessageAppend(m.getNextMessage());
        if (this.version >= 12 && this.includesRemoteAccessOfflineExtendedEvent()) {
            this.remoteAccessMachineExtendedTimeout = m.getNextLong();
        }
    }

    @Override
    public LogFilter[] getFilters() {
        return this.filters;
    }

    @Override
    public String getSerialisationID() {
        return SERIALISATION_ID;
    }

    public void setFilters(LogFilter[] filters) {
        this.filters = filters;
    }

    @Override
    public String getLogMappingDescription() {
        return this.toString();
    }

    @Override
    public boolean canLogEvent(LogEvent event) {
        if (!this.isActive()) {
            return false;
        }
        if (this.logEventIDs != null) {
            for (String supportedID : this.logEventIDs) {
                long offlineDuration;
                if (!supportedID.equalsIgnoreCase(event.getID()) || event instanceof RemoteMachineOfflineExtended && (offlineDuration = ((RemoteMachineOfflineExtended)event).offlineDuration) < this.remoteAccessMachineExtendedTimeout) continue;
                if (this.filters == null || this.filters.length == 0) {
                    return true;
                }
                for (LogFilter filter : this.filters) {
                    if (!filter.includeEvent(event)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

