/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.proxy.MachineChange;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.NetAdapter;
import com.aem.shelp.proxy.types.TypeUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Random;
import java.util.TimeZone;
import jwrapper.jwutils.JWWindowsOS;
import utils.encryption.aes.RijndaelDecryptionStream;
import utils.encryption.aes.RijndaelEncryptionStream;
import utils.files.AtomicFileOutputStream;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.osstats.types.BasicInfo;
import utils.progtools.TimeConverter;
import utils.software.OSSoftwareUtil;
import utils.software.types.software.Software;
import utils.string.SafeCmp;
import utils.switches.Switches;
import utils.xml.XML14Util;

public class MachineInfo
implements TypeUtil.XMLListener {
    private static Message EMPTY_STATS_MESSAGE = null;
    private static final Message EMPTY_MESSAGE = new Message();
    private static final boolean TRUNCATE_FRACTIONS_FROM_STATS = true;
    public static final int VER = 22;
    public long transientRegId;
    public long transientRegStarted;
    public int transientRegChanges;
    private boolean noLongerValidMustSplit = false;
    public int transientAlertStructureCount;
    public long transientRecoveryKeySent;
    public long transientOneClockSent;
    private long transientAssumeUpdatingUntil;
    private String notes;
    private String warnings;
    private boolean allowMonitoring = false;
    private boolean allowScripting = true;
    private long alertModtime = 0L;
    private long alertRegHash = 0L;
    private long transient_lastAccessTime = 0L;
    private long genstoreLastPoint = 0L;
    private byte screenCount = 1;
    private final Object alerts_LOCK = new Object();
    private final ArrayList<String> alertsTriggered = new ArrayList();
    private BasicInfo hardwareDetails;
    private byte[] loadAverages;
    private long lastPingTimeMillis = 0L;
    private final Object SOFTWARE_LOCK = new Object();
    private Software software;
    private Message softwareMessage;
    private JWWindowsOS.RDPSessionInfo[] rdpSessions = null;
    private byte[] screenJpegSmall;
    private long smallScreenDelete;
    private int smallHash = -1;
    private Object smallScreenImage;
    private String machineID;
    private MachineName nameCustom;
    private MachineName nameInServiceConfig;
    private String shBuild;
    private String jwBuild;
    private boolean isMonitoring;
    private int cpuPtr = 0;
    private double[] cpuPc = new double[10];
    private int memPtr = 0;
    private double[] memPc = new double[10];
    private double wifiMbit = -1.0;
    private double wifiSignalPc;
    private Message disks;
    private Message procs;
    private byte[] screenJpegBig;
    private long bigScreenDelete;
    private int bigHash;
    private String consoleUser;
    private int osBase = 3;
    private int osVariant = -1;
    private boolean is64bit = false;
    private String osNameWithBitness = "Unknown";
    private String hostname;
    private String[] localip = new String[0];
    private String wanip;
    private long lastRestartedUTC = 0L;
    private Long auth1 = 0L;
    private Long auth2 = 0L;
    private long lastRequestedBasics = 0L;
    private int serialisationVersion = 22;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTriggeredAlerts() {
        Object object = this.alerts_LOCK;
        synchronized (object) {
            return this.alertsTriggered.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean asmAlertTriggered(String id) {
        Object object = this.alerts_LOCK;
        synchronized (object) {
            if (!this.alertsTriggered.contains(id)) {
                this.alertsTriggered.add(id);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean asmAlertReset(String id) {
        Object object = this.alerts_LOCK;
        synchronized (object) {
            boolean modified = false;
            while (this.alertsTriggered.contains(id)) {
                this.alertsTriggered.remove(id);
                modified = true;
            }
            return modified;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlertTriggered(String id) {
        if (this.alertsTriggered.size() == 0) {
            return false;
        }
        Object object = this.alerts_LOCK;
        synchronized (object) {
            return this.alertsTriggered.indexOf(id) != -1;
        }
    }

    public ArrayList<String> getTriggeredAlertIDs() {
        return new ArrayList<String>(this.alertsTriggered);
    }

    public void setDoneUdpating_Transient() {
        this.transientAssumeUpdatingUntil = 0L;
    }

    public void setTemporarilyUpdating_Transient() {
        this.transientAssumeUpdatingUntil = SafeClock.currentTimeMillis() + 60000L;
    }

    public void setGenStoreLastDataPoint(long lastPoint) {
        this.genstoreLastPoint = lastPoint;
    }

    public long getGenstoreLastPoint() {
        return this.genstoreLastPoint;
    }

    public boolean amTemporarilyUpdating_Transient() {
        return SafeClock.currentTimeMillis() < this.transientAssumeUpdatingUntil;
    }

    public void setAlertRegistryHash(long hash) {
        this.alertRegHash = hash;
    }

    public boolean haveAlertRegistryHash() {
        return this.alertRegHash != 0L;
    }

    public long getAlertRegistryHash() {
        return this.alertRegHash;
    }

    public void setLastPingTimeMillis(long lastPingTimeMillis) {
        this.lastPingTimeMillis = lastPingTimeMillis;
    }

    public long getLastPingTimeMillis() {
        return this.lastPingTimeMillis;
    }

    public void setAlertModtime(long t) {
        this.alertModtime = t;
    }

    public long getAlertModtime() {
        return this.alertModtime;
    }

    public long getLastSessionTime_Transient() {
        return this.transient_lastAccessTime;
    }

    public byte getScreenCount() {
        return this.screenCount;
    }

    public void setScreenCount(byte screenCount) {
        this.screenCount = screenCount;
    }

    public void setLastSessionTime_Transient(long currentTimeMillis) {
        this.transient_lastAccessTime = currentTimeMillis;
    }

    public void setSHBuildVersion(String ver) {
        boolean notify = false;
        if (MachineChange.exists() && SafeCmp.nequal(this.shBuild, ver)) {
            notify = true;
        }
        this.shBuild = ver;
        if (notify) {
            MachineChange.machineFilterableInfoChanged(this.machineID);
        }
    }

    public void setJWBuildVersion(String ver) {
        boolean notify = false;
        if (MachineChange.exists() && SafeCmp.nequal(this.jwBuild, ver)) {
            notify = true;
        }
        this.jwBuild = ver;
        if (notify) {
            MachineChange.machineFilterableInfoChanged(this.machineID);
        }
    }

    public String getSHBuildVersion() {
        return this.shBuild;
    }

    public String getJWBuildVersion() {
        return this.jwBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toComparisonString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nameCustom).append("&");
        sb.append(this.shBuild).append("&");
        sb.append(this.jwBuild).append("&");
        for (double aCpuPc : this.cpuPc) {
            sb.append(aCpuPc).append("&");
        }
        for (double aMemPc : this.memPc) {
            sb.append(aMemPc).append("&");
        }
        sb.append(this.disks).append("&");
        sb.append(this.procs).append("&");
        sb.append(this.smallHash).append("&");
        sb.append(this.bigHash).append("&");
        sb.append(this.consoleUser).append("&");
        sb.append(this.osBase).append("&");
        sb.append(this.osVariant).append("&");
        sb.append(this.is64bit).append("&");
        sb.append(this.osNameWithBitness).append("&");
        if (this.hostname != null) {
            sb.append(this.hostname.trim()).append("&");
        }
        for (String aLocalip : this.localip) {
            sb.append(aLocalip).append("&");
        }
        sb.append(this.wanip).append("&");
        sb.append(this.allowMonitoring).append("&");
        sb.append(this.allowScripting).append("&");
        sb.append(this.alertModtime).append("&");
        Object object = this.alerts_LOCK;
        synchronized (object) {
            sb.append(this.alertsTriggered.size()).append("&");
            for (String alert : this.alertsTriggered) {
                sb.append(alert).append("&");
            }
        }
        sb.append(this.wifiMbit);
        sb.append(this.wifiSignalPc);
        sb.append(this.lastRestartedUTC);
        sb.append(this.genstoreLastPoint);
        return sb.toString();
    }

    public void setIsMonitoring(boolean b) {
        boolean isChanged = this.isMonitoring != b;
        this.isMonitoring = b;
        if (MachineChange.exists() && isChanged) {
            MachineChange.machineDataChanged(this.machineID);
        }
    }

    public boolean isMonitoring() {
        return this.isMonitoring;
    }

    public void addOsBasicStats(double cpu, double mem) {
        this.cpuPc[this.cpuPtr++] = cpu;
        this.memPc[this.memPtr++] = mem;
        if (this.cpuPtr >= this.cpuPc.length) {
            this.cpuPtr = 0;
        }
        if (this.memPtr >= this.memPc.length) {
            this.memPtr = 0;
        }
    }

    public void setWifiStats(double mbit, double signalpc) {
        this.wifiMbit = mbit;
        this.wifiSignalPc = signalpc;
    }

    public double getWifiMbit() {
        return this.wifiMbit;
    }

    public double getWifiSignalPc() {
        return this.wifiSignalPc;
    }

    public double[] getCpu() {
        int ptr = this.cpuPtr % this.cpuPc.length;
        double[] tmp = new double[this.cpuPc.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.cpuPc[ptr++];
            if (ptr != tmp.length) continue;
            ptr = 0;
        }
        return tmp;
    }

    public double[] getMem() {
        int ptr = this.memPtr % this.memPc.length;
        double[] tmp = new double[this.memPc.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.memPc[ptr++];
            if (ptr != tmp.length) continue;
            ptr = 0;
        }
        return tmp;
    }

    public void setOsDetailedStats(Message disks, Message procs) {
        this.disks = disks;
        this.procs = procs;
    }

    public Message getDetailedProcs() {
        return this.procs;
    }

    public Message getDetailedDisks() {
        return this.disks;
    }

    public void setSmallScreenImage(Object o) {
        this.smallScreenImage = o;
    }

    public Object getSmallScreenImage() {
        return this.smallScreenImage;
    }

    public void setSmallScreenJpeg(byte[] jpeg) {
        this.screenJpegSmall = jpeg;
        this.smallHash = (int)(System.currentTimeMillis() % 2000000000L);
        this.smallScreenDelete = System.currentTimeMillis() + 120000L;
        this.smallScreenImage = null;
    }

    public byte[] getSmallScreenJpeg() {
        if (System.currentTimeMillis() > this.smallScreenDelete) {
            this.screenJpegSmall = null;
            this.smallScreenImage = null;
            this.smallHash = -1;
        }
        return this.screenJpegSmall;
    }

    public int getSmallScreenHash() {
        return this.smallHash;
    }

    public void setBigScreenJpeg(byte[] jpeg) {
        this.screenJpegBig = jpeg;
        this.bigHash = (int)(System.currentTimeMillis() % 2000000000L);
        this.bigScreenDelete = System.currentTimeMillis() + 120000L;
    }

    public byte[] getBigScreenJpeg() {
        if (System.currentTimeMillis() > this.bigScreenDelete) {
            this.screenJpegBig = null;
            this.bigHash = -1;
        }
        return this.screenJpegBig;
    }

    public int getBigScreenHash() {
        return this.bigHash;
    }

    public void setConsoleUser(String username) {
        boolean notify = false;
        if (MachineChange.exists() && SafeCmp.nequal(this.consoleUser, username)) {
            notify = true;
        }
        this.consoleUser = username;
        if (notify) {
            MachineChange.machineFilterableInfoChanged(this.machineID);
        }
    }

    public String getConsoleUser() {
        return this.consoleUser;
    }

    public void setUptimeMs(long uptimeMs) {
        this.lastRestartedUTC = TimeConverter.toUTC((long)(System.currentTimeMillis() - uptimeMs), (TimeZone)TimeZone.getDefault());
    }

    private void setLastRestartedUTC(long timeUTC) {
        this.lastRestartedUTC = timeUTC;
    }

    public void setOS(int os, int variant, boolean is64, String osnameWB) {
        boolean notify = false;
        if (MachineChange.exists() && (SafeCmp.nequal(this.osNameWithBitness, osnameWB) || SafeCmp.nequal(this.hostname, this.hostname))) {
            notify = true;
        }
        this.osBase = os;
        this.osVariant = variant;
        this.is64bit = is64;
        this.osNameWithBitness = osnameWB;
        if (notify) {
            MachineChange.machineFilterableInfoChanged(this.machineID);
        }
    }

    public void setHostname(String hostname) {
        boolean notify = false;
        if (SafeCmp.nequal(this.hostname, hostname)) {
            notify = true;
        }
        this.hostname = hostname;
        if (notify) {
            MachineChange.machineFilterableInfoChanged(this.machineID);
        }
    }

    public void setIpsMacWanIP(String[] localIP, String wanIP) {
        boolean notify = false;
        if ((localIP = MachineInfo.sortIPMacStrings(localIP)).length > 0 && SafeCmp.nequal(this.localip, localIP) || wanIP.length() > 0 && SafeCmp.nequal(this.wanip, wanIP)) {
            notify = true;
        }
        if (localIP.length > 0) {
            this.localip = localIP;
        }
        if (wanIP.length() > 0) {
            this.wanip = wanIP;
        }
        if (notify) {
            MachineChange.machineFilterableInfoChanged(this.machineID);
        }
    }

    public int getOS() {
        return this.osBase;
    }

    public int getOsVariant() {
        return this.osVariant;
    }

    public boolean is64bit() {
        return this.is64bit;
    }

    public String getOsNameWithBitness() {
        return this.osNameWithBitness;
    }

    public long getLastRestartedUTC() {
        return this.lastRestartedUTC;
    }

    public long getLastRestartedLocal() {
        return TimeConverter.toLocalTime((long)this.lastRestartedUTC, (TimeZone)TimeZone.getDefault());
    }

    public static void main(String[] args) {
    }

    public String getHostname() {
        return this.hostname;
    }

    public String[] getLocalIpMacs() {
        return this.localip;
    }

    public NetAdapter[] getNetAdapters() {
        if (this.localip == null) {
            return new NetAdapter[0];
        }
        ArrayList<NetAdapter> result = new ArrayList<NetAdapter>();
        for (String aLocalip : this.localip) {
            String[] tmp;
            if (aLocalip == null || (tmp = aLocalip.split("/")).length < 3) continue;
            NetAdapter na = new NetAdapter(tmp[0], tmp[1], tmp[2]);
            result.add(na);
        }
        return result.toArray(new NetAdapter[0]);
    }

    public String getWanIP() {
        return this.wanip;
    }

    public MachineInfo(String id) {
        this.machineID = id;
        if (Switches.SH_longerCpuGraphs) {
            this.cpuPc = new double[120];
            this.memPc = new double[120];
        }
    }

    public long lastRequestedBasics() {
        return this.lastRequestedBasics;
    }

    public boolean shouldRequestBasics() {
        return System.currentTimeMillis() - this.lastRequestedBasics > 60000L;
    }

    public void willRequestBasics() {
        this.lastRequestedBasics = System.currentTimeMillis();
    }

    public boolean verifyUnclaimed() {
        return this.auth1 == 0L && this.auth2 == 0L;
    }

    public boolean verifyID(Long claim1, Long claim2) {
        return this.auth1.longValue() == claim1.longValue() && this.auth2.longValue() == claim2.longValue();
    }

    public boolean claimID(Long claim1, Long claim2) {
        if (this.auth1 == 0L && this.auth2 == 0L) {
            this.auth1 = claim1;
            this.auth2 = claim2;
            return true;
        }
        return false;
    }

    public String getMachineID() {
        return this.machineID;
    }

    public boolean hasBasicInfo() {
        return this.nameCustom != null;
    }

    public MachineName getMachineName() {
        if (this.nameCustom != null) {
            return this.nameCustom;
        }
        if (this.nameInServiceConfig != null) {
            return this.nameInServiceConfig;
        }
        return MachineName.extractFromNameWithGroup(this.getMachineID());
    }

    public void setOverwriteName(MachineName machineName) {
        boolean notify = false;
        if (MachineChange.exists() && machineName.equals(this.nameCustom)) {
            notify = true;
        }
        this.nameCustom = machineName;
        if (notify) {
            MachineChange.machineFilterableInfoChanged(this.machineID);
        }
    }

    public void setServiceConfigAndOverrideNameNoUpdate(MachineName machineName) {
        this.nameInServiceConfig = machineName;
        this.nameCustom = machineName;
    }

    public boolean setServiceConfigAndOverrideName(MachineName machineName) {
        boolean overwriteName;
        boolean notify = false;
        boolean bl = overwriteName = !machineName.equals(this.nameInServiceConfig);
        if (overwriteName) {
            this.nameInServiceConfig = machineName;
            this.nameCustom = machineName;
            if (MachineChange.exists()) {
                notify = true;
            }
        }
        if (notify) {
            MachineChange.machineFilterableInfoChanged(this.machineID);
        }
        return overwriteName;
    }

    public void toXML(StringBuffer buffer, int tabCount) {
        int i;
        String tab = TypeUtil.getTabString(tabCount);
        buffer.append(tab).append("<MachineInfo>\n");
        TypeUtil.append(buffer, "MachineID", this.machineID, tabCount + 1);
        TypeUtil.append(buffer, "Name", this.getMachineName().toString(), tabCount + 1);
        TypeUtil.append(buffer, "OSBaseType", this.osBase, tabCount + 1);
        TypeUtil.append(buffer, "OSVariant", this.osVariant, tabCount + 1);
        TypeUtil.append(buffer, "OSLinuxArch", this.is64bit, tabCount + 1);
        TypeUtil.append(buffer, "OSSummary", this.osNameWithBitness, tabCount + 1);
        TypeUtil.append(buffer, "Hostname", this.hostname, tabCount + 1);
        TypeUtil.append(buffer, "LastRestarted", this.lastRestartedUTC, tabCount + 1);
        TypeUtil.append(buffer, "LocalIPSize", this.localip.length, tabCount + 1);
        for (i = 0; i < this.localip.length; ++i) {
            TypeUtil.append(buffer, "LocalIP", this.localip[i], Integer.toString(i), tabCount + 1);
        }
        TypeUtil.append(buffer, "WanIP", this.wanip, tabCount + 1);
        TypeUtil.append(buffer, "SHBuild", this.shBuild, tabCount + 1);
        TypeUtil.append(buffer, "JWBuild", this.jwBuild, tabCount + 1);
        TypeUtil.append(buffer, "Notes", XML14Util.escape((String)this.notes), tabCount + 1);
        TypeUtil.append(buffer, "Warnings", XML14Util.escape((String)this.warnings), tabCount + 1);
        TypeUtil.append(buffer, "AlertModtime", this.alertModtime, tabCount + 1);
        TypeUtil.append(buffer, "AlertsTriggeredSize", this.alertsTriggered.size(), tabCount + 1);
        for (i = 0; i < this.alertsTriggered.size(); ++i) {
            TypeUtil.append(buffer, "AlertTrigggered", this.alertsTriggered.get(i), Integer.toString(i), tabCount + 1);
        }
        TypeUtil.append(buffer, "NoLongerValidMustSplit", this.noLongerValidMustSplit + "", tabCount + 1);
        TypeUtil.append(buffer, "GenStoreLastData", this.genstoreLastPoint + "", tabCount + 1);
        buffer.append(tab).append("</MachineInfo>\n");
    }

    @Override
    public void handleXMLElement(String element, String value, String attribute) {
        if (element.equals("MachineID")) {
            this.machineID = value;
        } else if (element.equals("Name")) {
            this.nameInServiceConfig = MachineName.extractFromNameWithGroup(value);
        } else if (element.equals("OSBaseType")) {
            this.osBase = Integer.parseInt(value);
        } else if (element.equals("OSVariant")) {
            this.osVariant = Integer.parseInt(value);
        } else if (element.equals("OSLinuxArch")) {
            this.is64bit = Boolean.parseBoolean(value);
        } else if (element.equals("OSSummary")) {
            this.osNameWithBitness = value;
        } else if (element.equals("Hostname")) {
            this.hostname = value;
        } else if (element.equals("LastRestarted")) {
            this.lastRestartedUTC = Long.parseLong(value);
        } else if (element.equals("WanIP")) {
            this.wanip = value;
        } else if (element.equals("SHBuild")) {
            this.shBuild = value;
        } else if (element.equals("JWBuild")) {
            this.jwBuild = value;
        } else if (element.equals("Notes")) {
            this.notes = XML14Util.unescape((String)value);
        } else if (element.equals("Warnings")) {
            this.warnings = XML14Util.unescape((String)value);
        } else if (element.equals("AlertModtime")) {
            this.alertModtime = Long.parseLong(value);
        } else if (element.equals("GenStoreLastData")) {
            this.genstoreLastPoint = Long.parseLong(value);
        } else if (element.equals("NoLongerValidMustSplit")) {
            this.noLongerValidMustSplit = value.equals("true");
        } else if (element.equals("LocalIPSize")) {
            int size = Integer.parseInt(value);
            this.localip = new String[size];
        } else if (element.startsWith("LocalIP")) {
            int index = Integer.parseInt(attribute);
            this.localip[index] = value;
        } else if (element.equals("AlertsTriggeredSize")) {
            this.alertsTriggered.clear();
        } else if (element.startsWith("AlertTriggered")) {
            this.alertsTriggered.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message toMessage(boolean expensive, boolean longTermStorage) {
        Message m = new Message();
        m.append(22);
        m.append(this.machineID);
        m.append(this.nameCustom != null);
        if (this.nameCustom != null) {
            this.nameCustom.toMessage(m);
        }
        m.append(this.nameInServiceConfig != null);
        if (this.nameInServiceConfig != null) {
            this.nameInServiceConfig.toMessage(m);
        }
        if (longTermStorage) {
            m.append(this.auth1);
            m.append(this.auth2);
        }
        m.append(this.osBase);
        m.append(this.osVariant);
        m.append(this.is64bit);
        if (!longTermStorage) {
            Message sub;
            m.append(this.consoleUser);
            if (expensive) {
                m.append(this.cpuPtr);
                sub = new Message();
                for (double aCpuPc : this.cpuPc) {
                    sub.append(Math.floor(aCpuPc));
                }
                m.append(sub);
            } else {
                m.append(0);
                m.append(EMPTY_STATS_MESSAGE);
            }
            if (expensive) {
                m.append(this.memPtr);
                sub = new Message();
                for (double aMemPc : this.memPc) {
                    sub.append(Math.floor(aMemPc));
                }
                m.append(sub);
            } else {
                m.append(0);
                m.append(EMPTY_STATS_MESSAGE);
            }
            if (expensive) {
                m.append(this.disks);
                m.append(this.procs);
            } else {
                m.append(EMPTY_MESSAGE);
                m.append(EMPTY_MESSAGE);
            }
        }
        m.append(this.osNameWithBitness);
        m.append(this.hostname);
        m.append(expensive);
        if (expensive) {
            byte[] thumb = this.getSmallScreenJpeg();
            if (thumb != null) {
                m.append(thumb);
            } else {
                m.append(new byte[0]);
            }
        }
        Message ips = new Message();
        for (String aLocalip : this.localip) {
            ips.append(aLocalip);
        }
        m.append(ips);
        m.append(this.wanip);
        m.append(this.shBuild);
        m.append(this.jwBuild);
        m.append(this.notes);
        m.append(this.isMonitoring);
        m.append(this.allowMonitoring);
        m.append(this.allowScripting);
        m.append(this.warnings);
        m.append(this.alertModtime);
        if (!longTermStorage) {
            if (this.rdpSessions == null) {
                m.append(0);
            } else {
                m.append(this.rdpSessions.length);
                for (JWWindowsOS.RDPSessionInfo session : this.rdpSessions) {
                    m.append(MachineInfo.rdpSessionInfoToMessage(session));
                }
            }
        }
        Object object = this.alerts_LOCK;
        synchronized (object) {
            m.append(this.alertsTriggered.size());
            for (String alert : this.alertsTriggered) {
                m.append(alert);
            }
        }
        m.append(this.wifiMbit);
        m.append(Math.floor(this.wifiSignalPc));
        m.append(this.lastRestartedUTC);
        if (!longTermStorage) {
            m.append(this.screenCount);
        }
        if (this.hardwareDetails != null) {
            m.append(this.hardwareDetails.toMessage());
        } else {
            m.append((Message)null);
        }
        m.append(this.loadAverages);
        m.append(this.noLongerValidMustSplit);
        m.append(this.genstoreLastPoint);
        m.append(this.lastPingTimeMillis);
        if (longTermStorage) {
            Object object2 = this.SOFTWARE_LOCK;
            synchronized (object2) {
                m.append(this.softwareMessage);
            }
        }
        return m;
    }

    public static JWWindowsOS.RDPSessionInfo rdpSessionInfoFromMessage(Message m) {
        JWWindowsOS.RDPSessionInfo info = new JWWindowsOS.RDPSessionInfo();
        info.sessionID = m.getNextInt();
        info.state = m.getNextInt();
        info.username = m.getNextString();
        info.winStationName = m.getNextString();
        return info;
    }

    public static Message rdpSessionInfoToMessage(JWWindowsOS.RDPSessionInfo info) {
        Message m = new Message();
        m.append(info.sessionID);
        m.append(info.state);
        m.append(info.username);
        m.append(info.winStationName);
        return m;
    }

    public static MachineInfo fromMessage(Message m, boolean longTermStorage) {
        Message mm;
        boolean expensive;
        int FVER = m.getNextInt();
        MachineInfo minfo = new MachineInfo(m.getNextString());
        minfo.serialisationVersion = FVER;
        if (FVER > 4) {
            boolean nameExists = m.getNextBoolean();
            if (nameExists) {
                minfo.nameCustom = MachineName.fromMessage(m);
            }
            if (nameExists = m.getNextBoolean()) {
                minfo.nameInServiceConfig = MachineName.fromMessage(m);
            }
        } else {
            minfo.nameCustom = MachineName.extractFromNameWithGroup(m.getNextString());
        }
        if (longTermStorage) {
            minfo.auth1 = m.getNextLong();
            minfo.auth2 = m.getNextLong();
        }
        minfo.osBase = m.getNextInt();
        minfo.osVariant = m.getNextInt();
        minfo.is64bit = m.getNextBoolean();
        if (!longTermStorage) {
            int i;
            minfo.consoleUser = m.getNextString();
            minfo.cpuPtr = m.getNextInt();
            Message sub = m.getNextMessage();
            minfo.cpuPc = new double[sub.length()];
            for (i = 0; i < sub.length(); ++i) {
                minfo.cpuPc[i] = sub.getNextDouble();
            }
            minfo.memPtr = m.getNextInt();
            sub = m.getNextMessage();
            sub.resetIndex();
            minfo.memPc = new double[sub.length()];
            for (i = 0; i < sub.length(); ++i) {
                minfo.memPc[i] = sub.getNextDouble();
            }
            minfo.disks = m.getNextMessage();
            minfo.procs = m.getNextMessage();
        }
        if (FVER > 0) {
            minfo.osNameWithBitness = m.getNextString();
            minfo.hostname = m.getNextString();
        }
        if (FVER > 1 && (expensive = m.getNextBoolean())) {
            byte[] small = m.getNextByteArray();
            if (small.length > 0) {
                minfo.screenJpegSmall = small;
                minfo.smallScreenDelete = System.currentTimeMillis() + 240000L;
            } else {
                minfo.screenJpegSmall = null;
            }
        }
        if (FVER > 2) {
            Message tmp = m.getNextMessage();
            String[] ips = new String[tmp.length()];
            for (int i = 0; i < ips.length; ++i) {
                ips[i] = tmp.getAsString(i);
            }
            minfo.localip = ips;
            minfo.wanip = m.getNextString();
        }
        if (FVER > 3) {
            minfo.shBuild = m.getNextString();
            minfo.jwBuild = m.getNextString();
        }
        if (FVER > 5) {
            minfo.notes = m.getNextString();
        }
        if (FVER > 6) {
            minfo.isMonitoring = m.getNextBoolean();
        }
        if (FVER > 7) {
            minfo.allowMonitoring = m.getNextBoolean();
            minfo.allowScripting = m.getNextBoolean();
        }
        if (FVER > 8) {
            minfo.warnings = m.getNextString();
        }
        if (FVER > 9) {
            minfo.alertModtime = m.getNextLong();
        }
        if (FVER > 10 && !longTermStorage) {
            int count = m.getNextInt();
            minfo.rdpSessions = new JWWindowsOS.RDPSessionInfo[count];
            for (int i = 0; i < count; ++i) {
                minfo.rdpSessions[i] = MachineInfo.rdpSessionInfoFromMessage(m.getNextMessage());
            }
        }
        if (FVER > 11) {
            int count = m.getNextInt();
            minfo.alertsTriggered.clear();
            for (int i = 0; i < count; ++i) {
                minfo.asmAlertTriggered(m.getNextString());
            }
        }
        if (FVER > 12) {
            double wifiMbit = m.getNextDouble();
            double wifiPc = m.getNextDouble();
            minfo.setWifiStats(wifiMbit, wifiPc);
        }
        if (FVER > 13) {
            long lastRestarted = m.getNextLong();
            minfo.setLastRestartedUTC(lastRestarted);
        }
        if (FVER > 14 && !longTermStorage) {
            byte screenCount = m.getNextByte();
            minfo.setScreenCount(screenCount);
        }
        if (FVER > 15 && (mm = m.getNextMessage()) != null) {
            minfo.setHardwareDetails(BasicInfo.fromMessage((Message)mm));
        }
        if (FVER > 16) {
            minfo.setLoadAverageData(m.getNextByteArray());
        }
        if (FVER > 17) {
            minfo.setNoLongerValidMustSplit(m.getNextBoolean());
        }
        if (FVER > 19) {
            minfo.setGenStoreLastDataPoint(m.getNextLong());
        }
        if (FVER > 20) {
            minfo.setLastPingTimeMillis(m.getNextLong());
        }
        if (FVER > 21 && longTermStorage) {
            minfo.softwareMessage = m.getNextMessage();
        }
        return minfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Software loadSoftware() {
        Object object = this.SOFTWARE_LOCK;
        synchronized (object) {
            if (this.software != null) {
                return this.software;
            }
            if (this.softwareMessage == null) {
                return null;
            }
            this.software = OSSoftwareUtil.fromMessage(this.softwareMessage);
            return this.software;
        }
    }

    public void legacy_save(File f) {
        try {
            RijndaelEncryptionStream rout = new RijndaelEncryptionStream((OutputStream)new BufferedOutputStream((OutputStream)new AtomicFileOutputStream(f)), "shdakjhk1237****88231678214gi14y980---4378295678235ibdjhsv bbnnbdiewdhiuer783294%%%767sdhai20000ffuhher[pq;q,zmznbvy");
            this.save((OutputStream)rout);
            rout.close();
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    public void save(OutputStream rout) throws IOException {
        MessageUtils.writeMessageNoFlush((OutputStream)rout, (Message)this.toMessage(false, true));
    }

    public static MachineInfo load(InputStream in) throws IOException {
        Message m = MessageUtils.readMessage((InputStream)in);
        if (m == null) {
            return null;
        }
        return MachineInfo.fromMessage(m, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MachineInfo legacy_load(File f) {
        MachineInfo machineInfo;
        if (!f.exists()) {
            return null;
        }
        AtomicFileOutputStream.prepareForReading((File)f);
        RijndaelDecryptionStream rin = new RijndaelDecryptionStream((InputStream)new BufferedInputStream(new FileInputStream(f)), "shdakjhk1237****88231678214gi14y980---4378295678235ibdjhsv bbnnbdiewdhiuer783294%%%767sdhai20000ffuhher[pq;q,zmznbvy");
        try {
            MachineInfo info = MachineInfo.load((InputStream)rin);
            if (info == null) {
                f.delete();
            }
            machineInfo = info;
        }
        catch (Throwable throwable) {
            try {
                rin.close();
                throw throwable;
            }
            catch (IOException x) {
                f.delete();
                x.printStackTrace();
                return null;
            }
        }
        rin.close();
        return machineInfo;
    }

    public static MachineInfo createTestData(String id) {
        MachineInfo inf = new MachineInfo(id);
        Random r = new Random();
        inf.setServiceConfigAndOverrideName(MachineName.extractFromNameWithGroup("Group " + r.nextInt(20) + "/SubGroup " + r.nextInt(5) + "/" + Customer.firstNames[r.nextInt(Customer.firstNames.length)] + "'s server [" + r.nextInt() + "]"));
        int randomOS = r.nextInt(4);
        int randomVariant = r.nextInt(6) + 1;
        boolean is64 = r.nextBoolean();
        inf.setOS(randomOS, randomVariant, is64, MachineInfo.getRandomOSName(randomOS, randomVariant, is64));
        inf.setHostname("Random Hostname " + r.nextInt(1000));
        inf.setConsoleUser("User" + r.nextInt(10));
        inf.setIpsMacWanIP(new String[]{"192.168.1." + r.nextInt(250) + "/72:00:00:a5:52:f2/en0", "192.168.1." + r.nextInt(250) + "/72:00:00:a5:52:f1/p2p0"}, r.nextInt(250) + "." + r.nextInt(250) + "." + r.nextInt(250) + "." + r.nextInt(250));
        inf.allowMonitoring = r.nextBoolean();
        if (r.nextBoolean()) {
            inf.alertsTriggered.add("AL-1");
            inf.alertsTriggered.add("AL-2");
        }
        inf.rdpSessions = new JWWindowsOS.RDPSessionInfo[r.nextInt(5)];
        for (int i = 0; i < inf.rdpSessions.length; ++i) {
            inf.rdpSessions[i] = new JWWindowsOS.RDPSessionInfo();
            inf.rdpSessions[i].sessionID = i;
            inf.rdpSessions[i].state = i;
            inf.rdpSessions[i].username = "User " + i;
            inf.rdpSessions[i].winStationName = "Station " + i;
        }
        inf.loadAverages = new byte[]{(byte)r.nextInt(100), (byte)r.nextInt(100), (byte)r.nextInt(100), (byte)r.nextInt(100), (byte)r.nextInt(100), (byte)r.nextInt(100)};
        double base = Math.random() * 100.0;
        double cpubase = Math.random() * 60.0;
        int cpuFlipChance = (int)(Math.random() * 3.0);
        for (int z = 0; z < 150; ++z) {
            double mem = base + (Math.random() - 0.5) * 5.0;
            mem = Math.max(mem, 0.0);
            mem = Math.min(mem, 100.0);
            if (100.0 * Math.random() < (double)cpuFlipChance) {
                cpubase = Math.random() * 80.0;
            }
            double cpu = cpubase + (Math.random() - 0.5) * 20.0;
            cpu = Math.max(cpu, 0.0);
            cpu = Math.min(cpu, 100.0);
            inf.addOsBasicStats(cpu, mem);
        }
        Message disks = new Message();
        int count = r.nextInt(15);
        for (int z = 0; z < count; ++z) {
            disks.append("Some Disk Named " + z);
            disks.append((double)r.nextInt(100));
        }
        Message procs = new Message();
        count = r.nextInt(15);
        for (int z = 0; z < count; ++z) {
            procs.append("Process " + z);
            procs.append((double)r.nextInt(100));
        }
        Message nets = new Message();
        count = r.nextInt(10);
        for (int z = 0; z < count; ++z) {
            nets.append("192.168.1." + z + "/AA:BB:CC:DD:EE:FF:" + z + "/adapter " + z);
        }
        return inf;
    }

    private static String getRandomOSName(int randomOS, int randomVariant, boolean is64) {
        Random r = new Random();
        if (randomOS == 0) {
            if (randomVariant == 3) {
                return "Windows XP";
            }
            if (randomVariant == 4) {
                return "Windows Server 2003";
            }
            if (randomVariant == 7) {
                return "Windows 7";
            }
            if (randomVariant == 6) {
                switch (r.nextInt(5)) {
                    case 0: {
                        return "Windows 8";
                    }
                    case 1: {
                        return "Windows 10";
                    }
                    case 2: {
                        return "Windows Server 2008";
                    }
                    case 3: {
                        return "Windows Server 2012";
                    }
                    case 4: {
                        return "Windows Server 2016";
                    }
                }
                return "Windows 2008";
            }
            if (randomVariant == 1) {
                return "Windows Vista";
            }
        } else {
            if (randomOS == 1) {
                switch (r.nextInt(6)) {
                    case 0: {
                        return "Yosemite";
                    }
                    case 1: {
                        return "El Capitan";
                    }
                    case 2: {
                        return "Sierra";
                    }
                    case 3: {
                        return "High Sierra";
                    }
                    case 4: {
                        return "Mojave";
                    }
                    case 5: {
                        return "Mavericks";
                    }
                }
                return "Yosemite";
            }
            if (randomOS == 2) {
                if (r.nextBoolean()) {
                    return "CentOS 7";
                }
                return "Ubuntu 18.04";
            }
        }
        return "-";
    }

    public boolean matchesFilter(String filter) {
        if (this.hostname != null && this.hostname.toLowerCase().contains(filter)) {
            return true;
        }
        for (String aLocalip : this.localip) {
            if (aLocalip == null || !aLocalip.toLowerCase().contains(filter)) continue;
            return true;
        }
        if (this.wanip != null && this.wanip.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.consoleUser != null && this.consoleUser.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.osNameWithBitness != null && this.osNameWithBitness.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.notes != null && this.notes.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.warnings != null && this.warnings.toLowerCase().contains(filter)) {
            return true;
        }
        MachineName name = this.getMachineName();
        if (name != null && name.toString().toLowerCase().contains(filter)) {
            return true;
        }
        return this.hardwareDetails != null && this.hardwareDetails.matchesFilter(filter);
    }

    public void setNotes(String notes) {
        boolean notify = false;
        if (SafeCmp.nequal(this.notes, notes)) {
            notify = true;
        }
        this.notes = notes;
        if (notify) {
            MachineChange.machineFilterableInfoChanged(this.machineID);
        }
    }

    public String getNotes() {
        return this.notes;
    }

    public void setWarnings(String warnings) {
        boolean notify = false;
        if (SafeCmp.nequal(this.warnings, warnings)) {
            notify = true;
        }
        this.warnings = warnings;
        if (notify) {
            MachineChange.machineFilterableInfoChanged(this.machineID);
        }
    }

    public String getWarnings() {
        return this.warnings;
    }

    public void setAllowMonitoring(boolean allowMonitoring) {
        boolean notify = false;
        if (this.allowMonitoring != allowMonitoring) {
            notify = true;
        }
        this.allowMonitoring = allowMonitoring;
        if (notify) {
            MachineChange.machineFilterableInfoChanged(this.machineID);
        }
    }

    public void setAllowScripting(boolean allowScripting) {
        boolean notify = false;
        if (this.allowScripting != allowScripting) {
            notify = true;
        }
        this.allowScripting = allowScripting;
        if (notify) {
            MachineChange.machineFilterableInfoChanged(this.machineID);
        }
    }

    public boolean allowMonitoring() {
        return this.allowMonitoring;
    }

    public boolean allowScripting() {
        return this.allowScripting;
    }

    private static String[] sortIPMacStrings(String[] ips) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> priorityList = new ArrayList<String>();
        for (String s : ips) {
            if (s == null) continue;
            String[] parts = s.split("/");
            if (parts.length != 3) {
                list.add(s);
                continue;
            }
            if (parts[0].length() <= 0) continue;
            if (parts[2].startsWith("en") || parts[2].startsWith("eth")) {
                priorityList.add(s);
                continue;
            }
            list.add(s);
        }
        priorityList.addAll(list);
        return priorityList.toArray(new String[0]);
    }

    public JWWindowsOS.RDPSessionInfo[] getRDPSessions() {
        return this.rdpSessions;
    }

    public int getRDPSessionCount() {
        if (this.rdpSessions == null) {
            return 0;
        }
        return this.rdpSessions.length;
    }

    public void setRDPSessions(JWWindowsOS.RDPSessionInfo[] rdpSessions) {
        this.rdpSessions = rdpSessions;
    }

    public double getLatestCPU() {
        int ptr = this.cpuPtr % this.cpuPc.length;
        if (--ptr < 0) {
            ptr = this.cpuPc.length - 1;
        }
        return this.cpuPc[ptr];
    }

    public double getLatestMem() {
        int ptr = this.memPtr % this.memPc.length;
        if (--ptr < 0) {
            ptr = this.memPc.length - 1;
        }
        return this.memPc[ptr];
    }

    public void setHardwareDetails(BasicInfo hardwareDetails) {
        this.hardwareDetails = hardwareDetails;
    }

    public BasicInfo getHardwareDetails() {
        return this.hardwareDetails;
    }

    public void setLoadAverageData(byte[] loadAverageData) {
        this.loadAverages = loadAverageData;
    }

    public byte[] getLoadAverageData() {
        return this.loadAverages;
    }

    public void setNoLongerValidMustSplit(boolean b) {
        this.noLongerValidMustSplit = b;
    }

    public boolean isNoLongerValidMustSplit() {
        return this.noLongerValidMustSplit;
    }

    public int getSerialisationVersion() {
        return this.serialisationVersion;
    }

    public void setSoftware(Software software, Message softwareMessage) {
        this.software = software;
        this.softwareMessage = softwareMessage;
    }

    public Message getSoftwareMessage() {
        return this.softwareMessage;
    }

    public String getMostRelevantLanIP() {
        String nullIP = null;
        String lanIP = null;
        String realIP = null;
        for (NetAdapter adapter : this.getNetAdapters()) {
            if (adapter == null || adapter.ip == null || adapter.ip.length() <= 0) continue;
            String newIP = adapter.ip;
            if (newIP.equals("0.0.0.0") || newIP.equals("0:0:0:0:0:0:0:0") || newIP.equals("::")) {
                if (nullIP != null) continue;
                nullIP = newIP;
                continue;
            }
            if (newIP.startsWith("10.") || newIP.startsWith("192.168.") || newIP.startsWith("172.")) {
                if (lanIP != null) continue;
                lanIP = newIP;
                continue;
            }
            if (realIP != null) continue;
            realIP = newIP;
        }
        if (realIP != null) {
            return realIP;
        }
        if (lanIP != null) {
            return lanIP;
        }
        if (nullIP != null) {
            return nullIP;
        }
        return null;
    }

    public DiskInfo[] getDiskInfo() {
        ArrayList<DiskInfo> diskInfo = new ArrayList<DiskInfo>();
        if (this.disks != null) {
            for (int i = 0; i < this.disks.length(); i += 2) {
                DiskInfo dInfo = new DiskInfo();
                dInfo.name = this.disks.getAsString(i);
                dInfo.percentage = this.disks.getAsDouble(i + 1);
                diskInfo.add(dInfo);
            }
        }
        return diskInfo.toArray(new DiskInfo[0]);
    }

    public ProcessInfo[] getProcessInfo() {
        ArrayList<ProcessInfo> processInfos = new ArrayList<ProcessInfo>();
        if (this.procs != null) {
            for (int i = 0; i < this.procs.length(); i += 2) {
                ProcessInfo newInfo = new ProcessInfo();
                newInfo.name = this.procs.getAsString(i);
                newInfo.percentage = this.procs.getAsDouble(i + 1);
                processInfos.add(newInfo);
            }
        }
        return processInfos.toArray(new ProcessInfo[0]);
    }

    static {
        EMPTY_STATS_MESSAGE = new Message();
        for (int i = 0; i < 10; ++i) {
            EMPTY_STATS_MESSAGE.append(0.0);
        }
    }

    public static class DiskInfo {
        public String name;
        public double percentage;
    }

    public static class ProcessInfo {
        public String name;
        public double percentage;
    }
}

