/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import com.aem.CentralDebugging;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.AlertInput;
import java.util.ArrayList;
import java.util.Date;
import utils.osstats.Stats;
import utils.osstats.av.SecurityProduct;

public class GlobalEvents
implements AlertInput {
    private static GlobalEvents INSTANCE = new GlobalEvents();
    private ArrayList<AlertInput> alerts = new ArrayList();
    public static int GRANULARITY_MS = 3000;
    Object thread_LOCK = new Object();
    TimerThread thread;

    public synchronized void setAllAlerts(ArrayList<AlertInput> alerts) {
        this.alerts = alerts;
        this.initTimer();
    }

    public synchronized ArrayList<AlertInput> getAllAlerts() {
        ArrayList<AlertInput> tmp = new ArrayList<AlertInput>();
        for (AlertInput input : this.alerts) {
            tmp.add(input);
        }
        return tmp;
    }

    public synchronized boolean hasAlerts() {
        return this.alerts.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initTimer() {
        Object object = this.thread_LOCK;
        synchronized (object) {
            if (this.thread == null) {
                this.thread = new TimerThread();
                this.thread.start();
            }
        }
    }

    public static GlobalEvents get() {
        return INSTANCE;
    }

    @Override
    public synchronized void timePassed() {
        for (AlertInput alert : this.alerts) {
            try {
                alert.timePassed();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void machineStats(Stats stats) {
        if (CentralDebugging.SG_ALERTS_DUMP_STATS) {
            System.out.println("[StatsDump] " + stats);
        }
        for (AlertInput alert : this.alerts) {
            alert.machineStats(stats);
        }
    }

    @Override
    public synchronized void securityStats(ArrayList<SecurityProduct> stats) {
        if (CentralDebugging.SG_ALERTS_DUMP_STATS) {
            for (SecurityProduct prod : stats) {
                System.out.println("[SecurityDump] " + prod);
            }
        }
        for (AlertInput alert : this.alerts) {
            alert.securityStats(stats);
        }
    }

    @Override
    public synchronized void alertTriggered(Alert alertx) {
        System.out.println("[GlobalEvents] " + alertx.getName() + " triggered " + new Date());
        for (AlertInput alert : this.alerts) {
            alert.alertTriggered(alertx);
        }
    }

    @Override
    public synchronized void alertReset(Alert alertx) {
        System.out.println("[GlobalEvents] " + alertx.getName() + " reset " + new Date());
        for (AlertInput alert : this.alerts) {
            alert.alertReset(alertx);
        }
    }

    class TimerThread
    extends Thread {
        public TimerThread() {
            this.setName("GlobalEvents-Timer");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(GRANULARITY_MS);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                try {
                    GlobalEvents.get().timePassed();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

