/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.targets.runtool;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.common.ProxyServerAPI;
import com.aem.shelp.proxy.logging.alerts.LocatedAlertLogEvent;
import com.aem.shelp.proxy.logging.targets.runtool.RunToolTargetUI;
import org.w3c.dom.Element;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.LocatableTarget;
import utils.loggingframework.targets.TargetUI;
import utils.message.Message;
import utils.xml.XML14Util;

public class RunToolTarget
extends AbstractTarget
implements LocatableTarget {
    public static final String ID = "RunToolTarget";
    private static ProxyServerAPI proxyServerAPI;
    private int toolBoxOwnerID;
    private String toolBoxOwnerName;
    private String toolToRunID;
    private String toolName;
    private boolean runPerMachine;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return Language.get("RUN_TOOL_TARGET_NAME");
    }

    @Override
    public String getDescription() {
        return Language.get("RUN_TOOL_TARGET_DESC");
    }

    @Override
    public String getTargetSummary() {
        if (this.toolName != null && this.toolName.length() > 0) {
            return this.getName() + " [" + this.toolName + "]";
        }
        return this.getName();
    }

    @Override
    public void logEvent(LogEvent event) throws Exception {
        if (event instanceof LocatedAlertLogEvent) {
            LocatedAlertLogEvent e = (LocatedAlertLogEvent)event;
            proxyServerAPI.runToolInThread(e, this.toolBoxOwnerID, this.toolToRunID);
        }
    }

    @Override
    public boolean isAvailableTarget() {
        return true;
    }

    @Override
    public TargetUI getTargetUI() {
        return new RunToolTargetUI();
    }

    @Override
    protected void fromMessage(byte version, Message m) {
        this.toolBoxOwnerID = m.getNextInt();
        this.toolToRunID = m.getNextString();
        this.toolName = m.getNextString();
        this.toolBoxOwnerName = m.getNextString();
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.toolBoxOwnerID);
        m.append(this.toolToRunID);
        m.append(this.toolName);
        m.append(this.toolBoxOwnerName);
    }

    @Override
    protected void saveToXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent((int)indent)).append("<").append(this.getID()).append(">\n");
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"ToolBoxOwnerID", (String)Integer.toString(this.toolBoxOwnerID));
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"ToolToRunID", (String)this.toolToRunID);
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"ToolName", (String)this.toolName);
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"ToolBoxOwnerName", (String)this.toolBoxOwnerName);
        buffer.append(XML14Util.getIndent((int)indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void loadFromXML(Element root) {
        this.toolBoxOwnerID = Integer.parseInt(XML14Util.getChildText((Element)root, (String)"ToolBoxOwnerID", (String)"-1"));
        this.toolToRunID = XML14Util.getChildText((Element)root, (String)"ToolToRunID", null);
        this.toolName = XML14Util.getChildText((Element)root, (String)"ToolName", null);
        this.toolBoxOwnerName = XML14Util.getChildText((Element)root, (String)"ToolBoxOwnerName", null);
    }

    @Override
    public boolean runPerMachineIsOptional() {
        return false;
    }

    @Override
    public boolean runPerMachine() {
        return true;
    }

    @Override
    public void setRunPerMachine(boolean b) {
    }

    public void setTooToRun(String toolBoxItemID, String toolBoxItemName, int toolBoxOwner, String toolBoxOwnerName) {
        this.toolToRunID = toolBoxItemID;
        this.toolName = toolBoxItemName;
        this.toolBoxOwnerName = toolBoxOwnerName;
        this.toolBoxOwnerID = toolBoxOwner;
    }

    public String getToolBoxItemID() {
        return this.toolToRunID;
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getToolBoxOwnerName() {
        return this.toolBoxOwnerName;
    }

    public int getToolBoxOwnerID() {
        return this.toolBoxOwnerID;
    }

    public static void setProxyServerAPI(ProxyServerAPI proxyServerAPI) {
        RunToolTarget.proxyServerAPI = proxyServerAPI;
    }
}

