/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.access;

import com.aem.sgateway.SGGroupUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class TechJoinAccessSessionEvent
extends SimpleHelpLogEvent {
    public static final String ID = "TechJoinAccessSessionEvent";
    public TechUser techUser;
    public String remoteMachine;
    public String machineName;
    public String machineGroups;
    public String ipAddress;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.get("EVENT_TECH_JOIN_ACCESS");
    }

    @Override
    public String getDescription() {
        return "A technician starts a remote access session to a remote machine.";
    }

    @Override
    public String getLogText() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[").append(this.getEventID()).append("] Technician started a remote access session:\n");
        buffer.append("\tTechnician:\n");
        buffer.append(this.techUser.getLogString(2));
        buffer.append("\tRemote Machine:\n");
        buffer.append("\t\t").append(this.remoteMachine);
        return buffer.toString();
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/access/technician_join");
    }

    public static TechJoinAccessSessionEvent createEvent(TechUser techUser, String remoteMachine, String technicianIPAddress) {
        TechJoinAccessSessionEvent event = new TechJoinAccessSessionEvent();
        event.remoteMachine = remoteMachine;
        event.techUser = techUser;
        event.machineName = SGGroupUtil.getMachineName(remoteMachine);
        event.machineGroups = SGGroupUtil.getGroupsString(remoteMachine);
        event.ipAddress = technicianIPAddress;
        return event;
    }

    @Override
    public String getEventID() {
        return "TechnicianJoinAccessSession";
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent((int)indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        if (this.techUser != null) {
            this.techUser.appendToXML(buffer, indent + 1);
        }
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"remoteMachine", (String)this.remoteMachine);
        if (this.machineName != null && this.machineName.length() > 0) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"machineName", (String)this.machineName);
        }
        if (this.machineGroups != null && this.machineGroups.length() > 0) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"machineGroups", (String)this.machineGroups);
        }
        if (this.ipAddress != null) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"ipAddress", (String)this.ipAddress);
        }
        buffer.append(XML14Util.getIndent((int)indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "remoteMachine", this.remoteMachine);
        this.safePut(properties, "techUser", this.techUser.toString());
        this.safePut(properties, "machineName", this.machineName);
        this.safePut(properties, "machineGroups", this.machineGroups);
        this.safePut(properties, "ipAddress", this.ipAddress);
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
        variableList.add(new LogEvent.LogEventVariable("remoteMachine", null, this.remoteMachine));
        variableList.add(new LogEvent.LogEventVariable("machineName", null, this.machineName));
        variableList.add(new LogEvent.LogEventVariable("machineGroups", null, this.machineGroups));
        variableList.add(new LogEvent.LogEventVariable("ipAddress", null, this.ipAddress));
    }
}

