/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.config;

import com.aem.CentralDebugging;
import com.aem.ServerManagement;
import com.aem.shelp.common.CommonEncryptors;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.proxy.LoginType;
import com.aem.shelp.proxy.config.LazyEncryptedPassword;
import com.aem.shelp.proxy.config.LazyHashPassword;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechFilterProvider;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.types.AbstractMachine;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.filters.CombinedMachineFilter;
import com.aem.shelp.proxy.types.filters.CustomerFilter;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.proxy.types.filters.SimpleMachineFilter;
import com.aem.utils.authentication.ChallengeFailedException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.net.ssl.TrustManager;
import utils.files.FileUtil;
import utils.radius.ChallengeHandler;
import utils.xml.XML14Util;

public class TechUser
implements Comparable<TechUser>,
TechFilterProvider {
    public static final int ANONYMOUS_ID = -2;
    public static final int UNKNOWN_ID = -1;
    public static final int SIMPLEHELP_ADMIN_ID = 0;
    public static final int SIMPLEHELP_ADMIN_GROUP_ID = 2000001;
    public static final int ADMIN_GROUP_ID = 2000002;
    private int uniqueID;
    private LazyEncryptedPassword displayName;
    private LazyEncryptedPassword login;
    private LazyHashPassword techHashedPassword;
    private LazyEncryptedPassword emailAddress;
    private CustomerFilter[] customerFilters = new CustomerFilter[0];
    private final CombinedMachineFilter machineFilters = new CombinedMachineFilter();
    public TechGroup[] groups = new TechGroup[0];
    public TechGroup[] groupsUserCanAdmin = new TechGroup[0];
    public transient byte[] avatarImageBytes = null;
    private boolean isAnonymous;
    private boolean allowLocallyAuthenticatedLogins = true;
    private boolean accountEnabled = true;
    private long enabledUntilTime = 0L;
    private boolean isForAppProfilesOnly = false;
    private LazyEncryptedPassword secretKey = null;

    public TechUser(int id, String defaultName, String login, LazyHashPassword hashedPassword, String email, boolean isAnonymous, boolean allowLocalAuthentication, boolean accountEnabled) {
        this(id, new LazyEncryptedPassword(defaultName), new LazyEncryptedPassword(login), hashedPassword, new LazyEncryptedPassword(email), isAnonymous, allowLocalAuthentication, accountEnabled);
    }

    public TechUser(int id, LazyEncryptedPassword defaultName, LazyEncryptedPassword login, LazyHashPassword hashedPassword, LazyEncryptedPassword email, boolean isAnonymous, boolean allowLocalAuthentication, boolean accountEnabled) {
        this.uniqueID = id;
        this.displayName = defaultName;
        this.login = login;
        this.techHashedPassword = hashedPassword;
        this.accountEnabled = accountEnabled;
        this.emailAddress = email;
        this.isAnonymous = isAnonymous;
        this.allowLocallyAuthenticatedLogins = allowLocalAuthentication;
    }

    public TechUser(int id) {
        this.uniqueID = id;
    }

    public boolean equals(Object o) {
        return o instanceof TechUser && ((TechUser)o).uniqueID == this.uniqueID;
    }

    public int getUserID() {
        return this.uniqueID;
    }

    public boolean isServerAdmin() {
        return this.uniqueID == 0;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean allowLocallyAuthenticatedLogins() {
        return this.allowLocallyAuthenticatedLogins;
    }

    public boolean isForAppProfilesOnly() {
        return this.isForAppProfilesOnly;
    }

    public void setIsForAppProfilesOnly(boolean b) {
        this.isForAppProfilesOnly = b;
    }

    @Override
    public CombinedMachineFilter getMachineFilters() {
        return this.machineFilters;
    }

    @Override
    public CustomerFilter[] getCustomerFilters() {
        return this.customerFilters;
    }

    public String getDefaultName() {
        if (this.displayName == null) {
            return this.login.getDecryptedPassword();
        }
        return this.displayName.getDecryptedPassword();
    }

    public boolean canUseSH() {
        boolean canDo = true;
        if (this.groups != null && this.groups.length > 0) {
            canDo = false;
            for (TechGroup group : this.groups) {
                if (!group.getPermissions().canRemoteSupport()) continue;
                return true;
            }
        }
        return canDo;
    }

    public boolean canUseSG() {
        boolean canDo = true;
        if (this.groups != null && this.groups.length > 0) {
            canDo = false;
            for (TechGroup group : this.groups) {
                if (!group.getPermissions().canRemoteAccess()) continue;
                return true;
            }
        }
        return canDo;
    }

    public void setDefaultName(String defaultName) {
        if (this.displayName == null) {
            this.displayName = new LazyEncryptedPassword(defaultName);
        } else {
            this.displayName.setDecryptedPassword(defaultName);
        }
    }

    public String getLogin() {
        return this.login.getDecryptedPassword();
    }

    public void setLogin(String login) {
        if (this.login == null) {
            this.login = new LazyEncryptedPassword(login);
        } else {
            this.login.setDecryptedPassword(login);
        }
    }

    public LazyHashPassword getPassword() {
        return this.techHashedPassword;
    }

    public void setGroups(TechGroup[] groups) {
        this.groups = groups;
    }

    public TechGroup[] getGroups() {
        return this.groups;
    }

    public void setGroupsToAdmin(TechGroup[] groupsUserCanAdmin) {
        this.groupsUserCanAdmin = groupsUserCanAdmin;
    }

    public TechGroup[] getGroupsToAdmin() {
        return this.groupsUserCanAdmin;
    }

    public boolean canAdministerGroups() {
        return this.groupsUserCanAdmin != null && this.groupsUserCanAdmin.length > 0;
    }

    public TechGroup getFirstGroup() {
        if (this.groups == null || this.groups.length == 0) {
            return null;
        }
        return this.groups[0];
    }

    public TechGroup resolveChosenGroupToNamedGroup(TechGroup loggedInContext) {
        if (this.groups.length == 1) {
            return this.groups[0];
        }
        if (loggedInContext != null && this.isInGroup(loggedInContext)) {
            return loggedInContext;
        }
        if (this.groups.length > 0) {
            return this.groups[0];
        }
        return null;
    }

    public void setPassword(LazyHashPassword password) {
        this.techHashedPassword = password;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getDefaultName());
        if (this.login != null) {
            buffer.append(" - ").append(this.getLogin());
        }
        if (this.groups == null || this.groups.length == 0) {
            return buffer.toString();
        }
        buffer.append("  [ ");
        for (int i = 0; i < this.groups.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.groups[i].toString());
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    @Override
    public int compareTo(TechUser arg0) {
        return this.toString().compareTo(arg0.toString());
    }

    public String getEmail() {
        if (this.emailAddress != null) {
            return this.emailAddress.getDecryptedPassword();
        }
        return null;
    }

    public void setEmail(String emailAddress) {
        if (this.emailAddress == null) {
            this.emailAddress = new LazyEncryptedPassword(emailAddress);
        } else {
            this.emailAddress.setDecryptedPassword(emailAddress);
        }
    }

    public String getFullEmailAddress() {
        String email;
        if (this.emailAddress != null && (email = this.emailAddress.getDecryptedPassword()) != null && email.length() > 0) {
            if (email.indexOf(60) == -1) {
                return "\"" + this.getDefaultName() + "\" <" + this.getEmail() + ">";
            }
            return email;
        }
        return "\"" + ServerConfig.get().smtpFromName + "\" <" + ServerConfig.get().smtpFromEmail + ">";
    }

    public void addGroup(TechGroup group) {
        if (this.groups == null) {
            this.groups = new TechGroup[0];
        }
        if (!this.isInGroup(group)) {
            TechGroup[] newGroups = new TechGroup[this.groups.length + 1];
            System.arraycopy(this.groups, 0, newGroups, 0, this.groups.length);
            newGroups[this.groups.length] = group;
            this.groups = newGroups;
        }
    }

    public void removeGroup(TechGroup group) {
        if (this.groups == null) {
            return;
        }
        if (this.isInGroup(group)) {
            this.removeGroupToAdminister(group);
            TechGroup[] newGroups = new TechGroup[this.groups.length - 1];
            int count = 0;
            for (TechGroup group1 : this.groups) {
                if (group.equals(group1)) continue;
                newGroups[count++] = group1;
            }
            this.groups = newGroups;
        }
    }

    public boolean isInGroup(MergedTechGroup mergedGroup) {
        if (this.groups == null) {
            return false;
        }
        for (TechGroup group : this.groups) {
            if (!mergedGroup.containsGroupByIntID(group.getGroupID())) continue;
            return true;
        }
        return false;
    }

    public boolean isInGroup(int techGroupID) {
        if (this.groups == null) {
            return false;
        }
        for (TechGroup group : this.groups) {
            if (group.getGroupID() != techGroupID) continue;
            return true;
        }
        return false;
    }

    public boolean isInGroup(TechGroup group) {
        return this.isInGroup(group.getGroupID());
    }

    public boolean authenticate(TechCredentials credentials, LoginType type, ChallengeHandler challengeHandler, TrustManager[] trustManagers) throws ChallengeFailedException {
        TechGroup[] techgroups;
        if (!this.isAccountEnabledAndNotTimedOut()) {
            System.out.println("[Authentication] Technician '" + credentials + "' account disabled or timed out.");
            return false;
        }
        if (!credentials.getUsername().equals(this.getLogin())) {
            return false;
        }
        System.out.println("[Authentication] Technician '" + credentials + "' found.");
        if (this.allowLocallyAuthenticatedLogins()) {
            if (this.getPassword() != null && this.getPassword().matches(credentials.getPassword())) {
                type.loginType = 1;
                return true;
            }
            System.out.println("[Authentication] Password mismatch - checking group level authentication.");
        } else {
            System.out.println("[Authentication] Tech user " + credentials + " is not allowed to log in with SimpleHelp credentials - checking group level authentication.");
        }
        for (TechGroup techgroup : techgroups = this.getGroups()) {
            if (!techgroup.authenticate(credentials, type, challengeHandler, trustManagers)) continue;
            return true;
        }
        return false;
    }

    public boolean canTechUserSeeCustomerFromAnyGroup(Customer customer) {
        MergedTechGroup group = this.getMergedTechGroupInstance();
        return this.canLoggedInTechUserSeeCustomer(customer, group);
    }

    public boolean canTechUserSeeMachineFromAnyGroup(Machine m) {
        MergedTechGroup group = this.getMergedTechGroupInstance();
        return this.canLoggedInTechUserSeeMachine(m, group);
    }

    public boolean canLoggedInTechUserSeeCustomer(Customer customer, MergedTechGroup loggedInContext) {
        if (customer.hasOneTimeTechFilters() && !customer.includesTechnicianInFilter(this, loggedInContext)) {
            return false;
        }
        return TechUser.canLoggedInTechUserSee(customer, this.customerFilters, null, loggedInContext);
    }

    private static boolean canLoggedInTechUserSee(AbstractMachine customerOrMachine, Filter[] techFilters, SimpleMachineFilter techSimpleFilter, MergedTechGroup group) {
        boolean accountFiltersDefaultShow = true;
        int accountFilterCount = 0;
        if (techFilters != null) {
            for (Filter filter : techFilters) {
                ++accountFilterCount;
                if (filter.include(customerOrMachine)) {
                    return filter.isShow();
                }
                if (!filter.isShow()) continue;
                accountFiltersDefaultShow = false;
            }
        }
        if (techSimpleFilter != null && customerOrMachine instanceof Machine && !techSimpleFilter.isEmpty()) {
            ++accountFilterCount;
            Machine machine = (Machine)customerOrMachine;
            Boolean state = techSimpleFilter.getStateFor(machine, true);
            if (state != null) {
                return state;
            }
            if (techSimpleFilter.containsAnyIncludes()) {
                accountFiltersDefaultShow = false;
            }
        }
        int groupCount = 0;
        int groupFilterCount = 0;
        int groupsThatExplicitlyShow = 0;
        int groupsThatExplicitlyHide = 0;
        int groupsThatDefaultShow = 0;
        if (group != null) {
            for (TechGroup childGroup : group) {
                ++groupCount;
                Filter[] groupFilters = null;
                SimpleMachineFilter groupSimpleFilter = null;
                if (customerOrMachine instanceof Customer) {
                    groupFilters = childGroup.getCustomerFilters();
                } else if (customerOrMachine instanceof Machine) {
                    Machine machine = (Machine)customerOrMachine;
                    CombinedMachineFilter machineFilters = childGroup.getMachineFilters();
                    if (machineFilters.showAllMachines()) {
                        groupFilters = null;
                        groupSimpleFilter = null;
                    } else if (machineFilters.useSimpleFilter()) {
                        groupFilters = null;
                        groupSimpleFilter = machineFilters.getSimpleMachineFilter();
                    } else if (machineFilters.useAdvancedFilter()) {
                        groupSimpleFilter = null;
                        groupFilters = machineFilters.getAdvancedFilters();
                    }
                    if (childGroup.getFilterByAllowedGroups()) {
                        ArrayList<ArrayList<String>> allowed = childGroup.getRemoteAccessGroupRestrictions();
                        String[] groupArray = machine.getMachineName().getGroup();
                        if (groupArray == null) continue;
                        for (ArrayList<String> check : allowed) {
                            if (check.size() != groupArray.length) continue;
                            boolean matched = true;
                            for (int i = 0; i < check.size(); ++i) {
                                if (check.get(i).equals(groupArray[i])) continue;
                                matched = false;
                                break;
                            }
                            if (!matched) continue;
                            return true;
                        }
                        continue;
                    }
                    if (groupSimpleFilter != null) {
                        if (groupSimpleFilter.isEmpty()) {
                            ++groupsThatDefaultShow;
                        } else {
                            ++groupFilterCount;
                            Boolean state = groupSimpleFilter.getStateFor(machine, true);
                            if (state != null) {
                                if (state.booleanValue()) {
                                    ++groupsThatExplicitlyShow;
                                } else {
                                    ++groupsThatExplicitlyHide;
                                }
                            } else if (!groupSimpleFilter.containsAnyIncludes()) {
                                ++groupsThatDefaultShow;
                            }
                        }
                    }
                }
                if (groupFilters != null && groupFilters.length > 0) {
                    boolean groupFiltersAreAllHide = true;
                    for (CustomerFilter customerFilter : groupFilters) {
                        ++groupFilterCount;
                        if (((Filter)customerFilter).include(customerOrMachine)) {
                            if (customerFilter.isShow()) {
                                ++groupsThatExplicitlyShow;
                                groupFiltersAreAllHide = false;
                                break;
                            }
                            ++groupsThatExplicitlyHide;
                            break;
                        }
                        if (!customerFilter.isShow()) continue;
                        groupFiltersAreAllHide = false;
                    }
                    if (groupFiltersAreAllHide) {
                        ++groupsThatDefaultShow;
                    }
                }
                if (groupFilters != null || groupSimpleFilter != null) continue;
                ++groupsThatDefaultShow;
            }
        }
        if (accountFilterCount == 0 && groupFilterCount == 0) {
            return true;
        }
        if (groupFilterCount > 0) {
            if (groupsThatExplicitlyShow > 0) {
                return true;
            }
            if (groupsThatExplicitlyHide > 0) {
                return false;
            }
            return groupsThatDefaultShow > 0;
        }
        return accountFiltersDefaultShow;
    }

    public boolean canLoggedInTechUserSeeMachine(Machine machine, MergedTechGroup loggedInContext) {
        if (this.machineFilters.showAllMachines()) {
            return TechUser.canLoggedInTechUserSee(machine, null, null, loggedInContext);
        }
        if (this.machineFilters.useSimpleFilter()) {
            return TechUser.canLoggedInTechUserSee(machine, null, this.machineFilters.getSimpleMachineFilter(), loggedInContext);
        }
        return TechUser.canLoggedInTechUserSee(machine, this.machineFilters.getAdvancedFilters(), null, loggedInContext);
    }

    public String getGroupsAsString() {
        if (this.groups == null || this.groups.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.groups.length; ++i) {
            TechGroup group = this.groups[i];
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(group.getName());
        }
        return buffer.toString();
    }

    public TransientTechUser getTransientProperties(MergedTechGroup loggedInGroup, LoginType loginType) {
        TransientTechUser user = new TransientTechUser();
        user.username = this.getLogin();
        user.uniqueID = this.uniqueID;
        if (loggedInGroup != null) {
            user.loggedInGroupIDs = loggedInGroup.getGroupIDs();
            user.loggedInGroupNames = loggedInGroup.getGroupNames();
            user.permissions = loggedInGroup.getPermissions();
            user.defaultSGMachineName = loggedInGroup.getDefaultSGServiceName();
            user.maxFileTransferSize = loggedInGroup.getMaxFileTransferSize();
            if (loggedInGroup.isSessionLimited()) {
                user.sessionSpeedLimitKbps = loggedInGroup.getSessionLimitKbps();
            }
            if (loggedInGroup.isFPSLimited()) {
                user.fpsDelay = loggedInGroup.getFPSDelay();
            }
            user.inactivityTimeout = loggedInGroup.getInactivityTimeout();
            user.requestConnectionTimeout = loggedInGroup.getRequestAccessTimeout();
        }
        if (this.getEmail() != null) {
            user.emailAddress = this.getEmail();
        }
        if (this.getGroupsAsString() != null) {
            user.groupList = this.getGroupsAsString();
        }
        if (this.getDefaultName() != null) {
            user.displayName = this.getDefaultName();
        }
        user.isAnonymousLogin = this.isAnonymous;
        user.loginType = loginType.loginType;
        user.canAdministerGroup = this.groupsUserCanAdmin.length > 0;
        for (TechGroup group : this.groups) {
            if (!group.getPermissions().canAdminServer()) continue;
            user.canAdministerServer = true;
            break;
        }
        return user;
    }

    public String getLogString(int indent) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            buffer.append("\t");
        }
        buffer.append(this.getLogin()).append(" (").append(this.getDefaultName()).append(")(").append(this.getGroupsAsString()).append(")").append("\n");
        return buffer.toString();
    }

    public void setAvatar(byte[] imageBytes) {
        if (ServerManagement.isServerJVM()) {
            try {
                File avatarDirectory = new File("configuration/technicians/" + this.uniqueID);
                avatarDirectory.mkdirs();
                File avatar = new File(avatarDirectory, "avatar");
                if (imageBytes == null) {
                    avatar.delete();
                }
                CommonEncryptors.generalEncryptor.writeFile(avatar.getAbsolutePath(), avatar, imageBytes);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.avatarImageBytes = imageBytes;
    }

    public void migrateTechnicianDirectory() {
        File oldAvatar;
        File techDirectory = new File("configuration/technicians/" + this.getLogin());
        if (techDirectory.exists() && (oldAvatar = new File(techDirectory, "avatar")).exists()) {
            try {
                byte[] data = FileUtil.readFile((File)oldAvatar);
                this.setAvatar(data);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        FileUtil.deleteDir((File)techDirectory);
    }

    public byte[] getAvatar() {
        if (this.avatarImageBytes != null) {
            return this.avatarImageBytes;
        }
        if (ServerManagement.isServerJVM()) {
            try {
                File avatar;
                File avatarDirectory = new File("configuration/technicians/" + this.uniqueID);
                if (avatarDirectory.exists() && (avatar = new File(avatarDirectory, "avatar")).exists()) {
                    this.avatarImageBytes = CommonEncryptors.generalEncryptor.readFile(avatar.getAbsolutePath(), avatar);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return this.avatarImageBytes;
    }

    public void cleanupUsedResources() {
        File techDirectory = new File("configuration/technicians/" + this.getLogin());
        FileUtil.deleteDir((File)techDirectory);
        techDirectory = new File("configuration/technicians/" + this.uniqueID);
        FileUtil.deleteDir((File)techDirectory);
    }

    public void setAllowLocallyAuthenicatedLogins(boolean allowLocalLogins) {
        this.allowLocallyAuthenticatedLogins = allowLocalLogins;
    }

    public void setAccountEnabled(boolean enabled) {
        this.accountEnabled = enabled;
    }

    public boolean isAccountEnabledAndNotTimedOut() {
        if (!this.isAccountEnabled()) {
            return false;
        }
        if (this.enabledUntilTime <= 0L) {
            return true;
        }
        return System.currentTimeMillis() <= this.enabledUntilTime;
    }

    public boolean isAccountEnabled() {
        return this.accountEnabled;
    }

    @Override
    public void setCustomerFilters(CustomerFilter[] customerFilters) {
        this.customerFilters = customerFilters;
    }

    public void appendToXML(StringBuffer buffer, int indent) {
        XML14Util.appendTextNode((StringBuffer)buffer, (int)indent, (String)"techUser", (String)this.toString());
    }

    public boolean canUseSharedToolbox(ToolBoxGroup sharedToolBox) {
        if (sharedToolBox == null) {
            return false;
        }
        if (CentralDebugging.PX_TOOLBOX) {
            System.out.println("[TechUser] canUseSharedToolbox(" + sharedToolBox + ") - sharedOwnerID:" + sharedToolBox.getSharedOwnerID() + " userID:" + this.getUserID() + " sharingMode:" + sharedToolBox.getSharingMode());
        }
        if (sharedToolBox.getSharedOwnerID() == this.getUserID()) {
            return false;
        }
        if (sharedToolBox.getSharingMode() == 0) {
            return false;
        }
        if (sharedToolBox.getSharingMode() == 2) {
            return true;
        }
        if (sharedToolBox.getSharingMode() == 1) {
            TechUser toolBoxOwner = ServerConfig.get().getTechnicianByID(sharedToolBox.getSharedOwnerID());
            for (TechGroup group : this.groups) {
                if (!toolBoxOwner.isInGroup(group)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public LazyEncryptedPassword getTOTPKey() {
        return this.secretKey;
    }

    public void setTOTPKey(LazyEncryptedPassword key) {
        this.secretKey = key;
    }

    public boolean inGroupWithTOTPAuthentication() {
        for (TechGroup group : this.groups) {
            if (!group.isMultiTierApp()) continue;
            return true;
        }
        return false;
    }

    public MergedTechGroup getMergedTechGroupInstance() {
        if (this.groups == null || this.groups.length == 0) {
            return new MergedTechGroup(new TechGroup[0]);
        }
        return new MergedTechGroup(this.groups);
    }

    public boolean isGroupAdminFor(TechGroup group) {
        if (this.groupsUserCanAdmin == null) {
            return false;
        }
        for (TechGroup admin : this.groupsUserCanAdmin) {
            if (admin.getGroupID() != group.getGroupID()) continue;
            return true;
        }
        return false;
    }

    public boolean canAdministerServer() {
        if (this.isServerAdmin()) {
            return true;
        }
        for (TechGroup group : this.groups) {
            if (!group.getPermissions().canAdminServer()) continue;
            return true;
        }
        return false;
    }

    public boolean canAdministerGroup(TechGroup groupToCheck) {
        for (TechGroup group : this.groupsUserCanAdmin) {
            if (!group.equals(groupToCheck)) continue;
            return true;
        }
        return false;
    }

    public void addGroupToAdminister(TechGroup group) {
        if (this.groupsUserCanAdmin == null) {
            this.groupsUserCanAdmin = new TechGroup[0];
        }
        if (!this.canAdministerGroup(group)) {
            TechGroup[] newGroups = new TechGroup[this.groupsUserCanAdmin.length + 1];
            System.arraycopy(this.groupsUserCanAdmin, 0, newGroups, 0, this.groupsUserCanAdmin.length);
            newGroups[this.groupsUserCanAdmin.length] = group;
            this.groupsUserCanAdmin = newGroups;
        }
    }

    public void removeGroupToAdminister(TechGroup group) {
        if (this.groupsUserCanAdmin == null) {
            return;
        }
        if (this.canAdministerGroup(group)) {
            TechGroup[] newGroups = new TechGroup[this.groupsUserCanAdmin.length - 1];
            int count = 0;
            for (TechGroup group1 : this.groupsUserCanAdmin) {
                if (group.equals(group1)) continue;
                newGroups[count++] = group1;
            }
            this.groupsUserCanAdmin = newGroups;
        }
    }

    public void setUserID(int uniqueID) {
        this.uniqueID = uniqueID;
    }

    public LazyEncryptedPassword getDefaultNameEncrypted() {
        return this.displayName;
    }

    public LazyEncryptedPassword getLoginEncrypted() {
        return this.login;
    }

    public LazyEncryptedPassword getEmailEncrypted() {
        return this.emailAddress;
    }

    public long getEnabledUntilTime() {
        return this.enabledUntilTime;
    }

    public void setEnabledUntilTime(long enabledUntilTime) {
        this.enabledUntilTime = enabledUntilTime;
        if (enabledUntilTime > 0L && enabledUntilTime < System.currentTimeMillis()) {
            this.setAccountEnabled(false);
        }
    }
}

