/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.config;

import bcutil.SaltedHashPasswordUtil;
import java.io.IOException;

public class LazyHashPassword {
    private String saltedHashPassword = null;
    private String originalPassword = null;

    public LazyHashPassword(String saltedHashPassword) {
        this.saltedHashPassword = saltedHashPassword;
    }

    private LazyHashPassword() {
    }

    public static LazyHashPassword createWithNewPassword(String originalPassword) {
        LazyHashPassword password = new LazyHashPassword();
        password.originalPassword = originalPassword;
        return password;
    }

    public boolean isNull() {
        return this.saltedHashPassword == null && this.originalPassword == null;
    }

    public String getHashedPassword() {
        if (this.isNull()) {
            return null;
        }
        if (this.saltedHashPassword != null) {
            return this.saltedHashPassword;
        }
        try {
            this.saltedHashPassword = SaltedHashPasswordUtil.hashPassword(this.originalPassword);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return this.saltedHashPassword;
    }

    public boolean matches(String potentialPassword) {
        if (potentialPassword == null) {
            return false;
        }
        if (this.isNull()) {
            return false;
        }
        if (this.saltedHashPassword != null) {
            try {
                return SaltedHashPasswordUtil.checkHashMatchesPassword(this.saltedHashPassword, potentialPassword);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return potentialPassword.equals(this.originalPassword);
    }

    public void setOriginalPassword(String originalPassword) {
        if (originalPassword == null || this.originalPassword == null || !this.originalPassword.equals(originalPassword)) {
            this.originalPassword = originalPassword;
            this.saltedHashPassword = null;
        }
    }
}

