/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.config;

import com.aem.shelp.proxy.config.ServerConfig;
import java.io.IOException;

public class LazyEncryptedPassword {
    private boolean isNull = false;
    private String decryptedPassword = null;
    private String encryptedPassword = null;
    private boolean isLegacy = false;

    public LazyEncryptedPassword(String encryptedPassword, boolean isLegacy) {
        this.encryptedPassword = encryptedPassword;
        this.isLegacy = isLegacy;
    }

    public LazyEncryptedPassword(String decryptedPassword) {
        this.decryptedPassword = decryptedPassword;
    }

    public boolean isNull() {
        return this.decryptedPassword == null && this.encryptedPassword == null;
    }

    public String getEncryptedPassword() {
        if (!this.isLegacy && this.encryptedPassword != null) {
            return this.encryptedPassword;
        }
        if (this.decryptedPassword == null) {
            return null;
        }
        this.encryptedPassword = ServerConfig.encryptPassv2(this.decryptedPassword);
        this.isLegacy = false;
        return this.encryptedPassword;
    }

    public String getDecryptedPassword() {
        if (this.isNull) {
            return null;
        }
        if (this.decryptedPassword == null) {
            if (this.encryptedPassword == null) {
                return null;
            }
            try {
                this.decryptedPassword = this.isLegacy ? ServerConfig.decryptPass_legacy(this.encryptedPassword) : ServerConfig.decryptPassv2(this.encryptedPassword);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.isNull = true;
            }
        }
        return this.decryptedPassword;
    }

    public void setDecryptedPassword(String decryptedPassword) {
        if (decryptedPassword == null || this.decryptedPassword == null || !this.decryptedPassword.equals(decryptedPassword)) {
            this.decryptedPassword = decryptedPassword;
            this.encryptedPassword = null;
            this.isLegacy = false;
        }
    }

    public boolean matches(String decryptedPassword) {
        if (decryptedPassword == null || this.getDecryptedPassword() == null) {
            return false;
        }
        return this.getDecryptedPassword().equals(decryptedPassword);
    }
}

