/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.common.notifications;

import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.proxy.logging.alerts.LocatedAlertLogEvent;
import utils.loggingframework.events.LogEvent;
import utils.message.Message;

public class AlertErrorNotification
extends Notification {
    public AlertErrorNotification() {
    }

    public AlertErrorNotification(LocatedAlertLogEvent logEvent, String reason) {
        super((byte)5, (byte)1, System.currentTimeMillis(), "${ALERT_ERROR, <I>" + logEvent.alert.getAlert().getName() + "</I>}", "${ALERT_ERROR_MESSAGE, '" + logEvent.alert.getAlert().getName() + "', " + (logEvent.isTrigger ? "ALERT_TRIGGER" : "ALERT_RESET") + "}", new AlertErrorMetadata(logEvent.alert.getAlert().getName(), logEvent.isTrigger, reason));
    }

    public AlertErrorNotification(LogEvent logEvent, String reason) {
        super((byte)5, (byte)1, System.currentTimeMillis(), "${ALERT_ERROR, <I>" + logEvent.getDisplayName() + "</I>}", "${SERVER_ALERT_ERROR_MESSAGE, '" + logEvent.getDisplayName() + "'}", new AlertErrorMetadata(logEvent.getDisplayName(), false, reason));
    }

    @Override
    protected void loadMetadataFrom(Message m) {
        this.metadata = new AlertErrorMetadata();
        this.metadata.fromMessage(m);
    }

    public AlertErrorMetadata getMetadata() {
        return (AlertErrorMetadata)this.metadata;
    }

    public static class AlertErrorMetadata
    implements Notification.NotificationMetadata {
        public String alertName;
        public boolean isTrigger;
        public String reason;

        public AlertErrorMetadata(String alertName, boolean isTrigger, String reason) {
            this.alertName = alertName;
            this.isTrigger = isTrigger;
            this.reason = reason;
        }

        private AlertErrorMetadata() {
        }

        @Override
        public Message toMessage() {
            Message m = new Message();
            m.append(this.alertName);
            m.append(this.isTrigger);
            m.append(this.reason);
            return m;
        }

        @Override
        public void fromMessage(Message m) {
            this.alertName = m.getNextString();
            this.isTrigger = m.getNextBoolean();
            this.reason = m.getNextString();
        }
    }
}

