/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.adminclient;

import bcutil.BCUtil;
import bcutil.BCUtilInputStream;
import bcutil.BCUtilOutputStream;
import com.aem.BuildDateUtil;
import com.aem.VersionUtil;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.shelp.common.PC;
import com.aem.shelp.proxy.adminclient.AdminClientHandler;
import com.aem.shelp.proxy.adminclient.AdminClientHandlerInterface;
import com.aem.shelp.proxy.adminclient.AdminClientHandlerLegacy;
import com.aem.shelp.tech.admin.enterprise.PeerConfig;
import com.aem.shelp.util.BCUtilMessenger;
import com.aem.shelp.util.SHelpNodelinkConnector;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import utils.message.Message;
import utils.stream.StreamUtils;

public class AdminClient
implements NodeLinkStatusListener,
PC,
AdminClientHandlerInterface {
    public static int ADMIN_CLIENT_PROTOCOL_VERSION = 1;
    private final AdminClientHandlerInterface handler;
    private final boolean isLegacy;
    private NodeLink sock;
    private BCUtil bcu;
    private int adminClientProtocolVersion;

    public AdminClient(String hostname, int port, String adminPass) throws Exception {
        this.isLegacy = !AdminClient.isGDPROrLater(hostname, port);
        this.sock = SHelpNodelinkConnector.getConnection(hostname, port, this);
        InputStream unencryptedInputStream = this.sock.getInputStream();
        OutputStream unencryptedOutputStream = this.sock.getOutputStream();
        StreamUtils.writeLong((OutputStream)unencryptedOutputStream, (long)BuildDateUtil.getAdminClientMagicBuildDate());
        unencryptedOutputStream.flush();
        try {
            long remoteMagic = StreamUtils.readLong((InputStream)unencryptedInputStream);
            if (BuildDateUtil.getAdminClientMagicBuildDate() != remoteMagic) {
                System.out.println(BuildDateUtil.getAdminClientMagicBuildDate() + " != " + remoteMagic);
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.sock.stop("Server does not support Peer Admin services, may be too old");
            throw new IOException("Server does not support Peer Admin services, may be too old");
        }
        this.bcu = new BCUtil();
        this.bcu.setValidHashRequired(false);
        this.bcu.handshake(unencryptedInputStream, unencryptedOutputStream, true, null);
        System.out.println("[AdminClient] Handshake done");
        Message login = new Message(5002000);
        login.append(adminPass);
        BCUtilMessenger.writeMsg(this.bcu, unencryptedOutputStream, login);
        unencryptedOutputStream.flush();
        if (this.isLegacy) {
            if (1 != StreamUtils.readInt((InputStream)this.sock.getInputStream())) {
                this.sock.stop("AdminClient login failed");
                throw new Exception("AdminClient login failed");
            }
            int serverVersion = StreamUtils.readInt((InputStream)this.sock.getInputStream());
            this.handler = new AdminClientHandlerLegacy(this.sock, this.bcu);
        } else {
            Message ret = BCUtilMessenger.readMsg(this.bcu, unencryptedInputStream);
            if (ret.getType() != 1) {
                this.sock.stop("AdminClient login failed");
                throw new Exception("AdminClient login failed");
            }
            this.adminClientProtocolVersion = ret.getNextInt();
            System.out.println("[AdminClient] Protocol version " + this.adminClientProtocolVersion);
            BCUtilOutputStream out = new BCUtilOutputStream((OutputStream)new BufferedOutputStream(unencryptedOutputStream), this.bcu);
            BCUtilInputStream in = new BCUtilInputStream((InputStream)new BufferedInputStream(unencryptedInputStream), this.bcu);
            unencryptedInputStream = null;
            unencryptedOutputStream = null;
            this.handler = new AdminClientHandler(this.sock, (InputStream)in, (OutputStream)out);
        }
    }

    public static boolean isGDPROrLater(String hostname, int port) throws IOException {
        return AdminClient.isGDPROrLater(hostname + ":" + port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGDPROrLater(String hostnamePort) throws IOException {
        boolean bl;
        URL url = new URL("http://" + hostnamePort + "/version");
        InputStream in = url.openStream();
        try {
            String ver = StreamUtils.readAllAsStringASCII((InputStream)in);
            bl = VersionUtil.isFullVersionLaterThan("SSuite-5-0-20180516-160556", ver);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Throwable t) {
                return true;
            }
        }
        in.close();
        return bl;
    }

    public String getPubkeyHashFromConnect() {
        return this.bcu.getSavedPublicKeyAuthHash();
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
    }

    @Override
    public void linkOK(NodeLink link) {
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
    }

    @Override
    public byte[] getServerKeysDat() throws IOException {
        return this.handler.getServerKeysDat();
    }

    @Override
    public String getBigPipeAuthToken(String clientHostname) throws IOException {
        return this.handler.getBigPipeAuthToken(clientHostname);
    }

    @Override
    public String getServerPeerName() throws IOException {
        return this.handler.getServerPeerName();
    }

    @Override
    public void setUpPeer(PeerConfig config) throws IOException {
        this.handler.setUpPeer(config);
    }

    @Override
    public void reloadPeers() throws IOException {
        this.handler.reloadPeers();
    }

    @Override
    public void shutdown() {
        this.handler.shutdown();
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }
}

