/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import utils.stream.StreamUtils;

public class Templates {
    private static final File INVITATIONS = new File("lib/templates/invitations");
    private static final File INVITATIONS_CONFIGURATION = new File("configuration/templates/invitations");
    private static final File TWOTIER = new File("lib/templates/twotier");
    private static final File TWOTIER_CONFIGURATION = new File("configuration/templates/twotier");
    private static final File RECORDINGS = new File("DEPLOY/html");
    private static final File RECORDINGS_CONFIGURATION = new File("configuration/html");
    public static String invitationEmailSubject = "";
    public static String invitationEmailContent = "";
    public static String invitationQuickSubject = "";
    public static String invitationQuickContent = "";
    public static String twoTierActivationSubject = "";
    public static String twoTierActivationContent = "";
    public static String adminTwoTierActivationSubject = "";
    public static String adminTwoTierActivationContent = "";
    public static String recordingsHtmlPrefix;
    public static String recordingsHtmlSuffix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] processFile(File templateFile) {
        if (!templateFile.exists()) {
            templateFile = new File(templateFile.getAbsolutePath() + ".default");
        }
        String[] result = new String[]{"", ""};
        if (!templateFile.exists()) {
            System.out.println("[Server Config] Email template not found: " + templateFile);
        } else {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(templateFile), StandardCharsets.UTF_8));
                String line = reader.readLine();
                boolean first = true;
                while (line != null) {
                    if (!(line = line.trim()).startsWith("#")) {
                        if (first) {
                            result[0] = line;
                            first = false;
                        } else {
                            result[1] = result[1].length() > 0 ? result[1] + "\n" + line : result[1] + line;
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable t) {
                System.out.println("[Server Config] [ERROR] Error reading template '" + templateFile + "' (" + t.getMessage() + ")");
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Throwable line) {}
            }
        }
        return result;
    }

    public static void main(String[] args) {
        Templates.loadTemplates();
    }

    private static File pickAppropriateFile(File original, File configuration, String filename) {
        File file = new File(configuration, filename);
        if (file.exists()) {
            return file;
        }
        file = new File(configuration, filename + ".default");
        if (file.exists()) {
            return file;
        }
        file = new File(original, filename);
        if (file.exists()) {
            return file;
        }
        file = new File(original, filename + ".default");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadTemplates() {
        String[] data;
        if (INVITATIONS.exists()) {
            data = Templates.processFile(Templates.pickAppropriateFile(INVITATIONS, INVITATIONS_CONFIGURATION, "invitation_support_email"));
            if (data[0] != null) {
                invitationEmailSubject = data[0];
            }
            if (data[1] != null) {
                invitationEmailContent = data[1];
            }
            if ((data = Templates.processFile(Templates.pickAppropriateFile(INVITATIONS, INVITATIONS_CONFIGURATION, "invitation_quick_email")))[0] != null) {
                invitationQuickSubject = data[0];
            }
            if (data[1] != null) {
                invitationQuickContent = data[1];
            }
        }
        if (TWOTIER.exists()) {
            data = Templates.processFile(Templates.pickAppropriateFile(TWOTIER, TWOTIER_CONFIGURATION, "authenticationcode"));
            if (data[0] != null) {
                twoTierActivationSubject = data[0];
            }
            if (data[1] != null) {
                twoTierActivationContent = data[1];
            }
        }
        if (TWOTIER.exists()) {
            data = Templates.processFile(Templates.pickAppropriateFile(TWOTIER, TWOTIER_CONFIGURATION, "admin_authenticationcode"));
            if (data[0] != null) {
                adminTwoTierActivationSubject = data[0];
            }
            if (data[1] != null) {
                adminTwoTierActivationContent = data[1];
            }
        }
        if (RECORDINGS.exists()) {
            File videoFile = Templates.pickAppropriateFile(RECORDINGS, RECORDINGS_CONFIGURATION, "video.html");
            System.out.println("[Server Config] Processed recordings template file: " + videoFile);
            InputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(videoFile));
                String recordingsHtml = StreamUtils.readAllAsStringUTF8((InputStream)in);
                String[] result = recordingsHtml.split("\\$\\{ScreenData\\}");
                recordingsHtmlPrefix = result[0];
                recordingsHtmlSuffix = result[1];
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException recordingsHtml) {}
            }
        }
    }
}

