/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.fs;

import com.aem.shelp.mdupload.fs.FSConstants;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.GenericFS;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FSUtils {
    public static void upload(GenericFS sourceFS, GFile source, GenericFS targetFS, GFile target) throws IOException {
        FSUtils.upload(sourceFS, source, targetFS, target, null);
    }

    public static void upload(GenericFS sourceFS, GFile source, GenericFS targetFS, GFile target, FSListener listener) throws IOException {
        FSUtils.upload(sourceFS, source, 0L, sourceFS.getFileSize(source), targetFS, target, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upload(GenericFS sourceFS, GFile source, long sourceOffset, long sourceLength, GenericFS targetFS, GFile target, FSListener listener) throws IOException {
        try {
            byte[] readFileChunk;
            long locLastModified = sourceFS.getLastModifiedTime(source);
            targetFS.closeFile(target);
            long tot = 0L;
            System.out.println("[FSUtils] Uploading " + sourceLength + " bytes");
            while (tot < sourceLength && (readFileChunk = sourceFS.readFileChunk(source, sourceOffset + tot, FSConstants.FILE_DOWNLOAD_CHUNK)).length != 0) {
                targetFS.writeFileChunk(target, tot, readFileChunk, 0, readFileChunk.length, locLastModified);
                System.out.println("[FSUtils] Processed " + (tot += (long)readFileChunk.length) + "/" + sourceLength);
                if (listener == null) continue;
                double progress = (double)tot / (double)sourceLength;
                listener.transferProgress(progress, readFileChunk.length, tot);
                if (!listener.cancelled()) continue;
                System.out.println("[FSUtils] Upload cancelled");
                return;
            }
            targetFS.setLength(target, sourceLength);
        }
        finally {
            try {
                sourceFS.closeFile(source);
            }
            catch (Throwable throwable) {}
            try {
                targetFS.closeFile(target);
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upload(GenericFS remoteFS, File local, GFile remote) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(local));
        try {
            long locLastModified = local.lastModified();
            byte[] dat = new byte[FSConstants.FILE_DOWNLOAD_CHUNK];
            int n = 0;
            long tot = 0L;
            remoteFS.closeFile(remote);
            while (n != -1) {
                n = ((InputStream)in).read(dat);
                if (n <= 0) continue;
                remoteFS.writeFileChunk(remote, tot, dat, 0, n, locLastModified);
                tot += (long)n;
            }
            remoteFS.closeFile(remote);
        }
        finally {
            try {
                remoteFS.closeFile(remote);
            }
            catch (Throwable throwable) {}
            try {
                ((InputStream)in).close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static interface FSListener {
        public void transferProgress(double var1, long var3, long var5);

        public boolean cancelled();
    }
}

