/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.shelp.mdupload.LossyClient;
import com.aem.shelp.mdupload.LossyTransport;
import com.aem.shelp.mdupload.SecureMessenger;
import com.aem.shelp.mdupload.SecureMessengerListener;
import com.aem.shelp.mdupload.SecureMessengerTransportProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import utils.ddebug.DDLog;
import utils.files.AtomicFileOutputStream;
import utils.progtools.Cache;
import utils.progtools.CacheListener;
import utils.string.Normaliser;
import utils.switches.Switches;

public class SecureMessengerDB {
    private static HashMap<String, Long> clients = new HashMap();
    private static final Object clients_LOCK = new Object();
    private static Cache<Long, SecureMessenger> routmap = null;
    private static final Object routing_LOCK = new Object();
    private static File DB;
    private static SecMsgDeleteListener deleteListener;
    private static boolean mergeDuplicateTargets;
    private static SecureMessengerTransportProvider stdTprov;
    private static final Object secmsgSave_LOCK;

    public static void noMergeDuplicateTargets() {
        mergeDuplicateTargets = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAllSecureMessengers() {
        File[] files = DB.listFiles();
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
        Object object = clients_LOCK;
        synchronized (object) {
            clients.clear();
        }
        Object object2 = routing_LOCK;
        synchronized (object2) {
            routmap.clear();
        }
    }

    public static void clearSecureMessenger(String messengerID, String reason) {
        SecureMessengerDB.clearSecureMessenger(messengerID, false, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearSecureMessenger(String messengerID, boolean ignoreCache, String reason) {
        Long routingID;
        Object object = clients_LOCK;
        synchronized (object) {
            routingID = clients.remove(messengerID);
        }
        if (routingID != null && !ignoreCache) {
            object = routing_LOCK;
            synchronized (object) {
                routmap.removeFromCache((Object)routingID);
            }
        }
        System.out.println("[SecureMessengerDB] Cleared secmsg " + messengerID + " (id " + routingID + ") (" + reason + ")");
        SecureMessengerDB.getSecureMessengerFile(messengerID, ".secmsg").delete();
        SecureMessengerDB.getSecureMessengerFile(messengerID, ".bcutil").delete();
    }

    public static void setDatabaseFolder(File folder, SecureMessengerTransportProvider tprov, int maximumSize) {
        System.out.println("[SecureMessengerDB] Initialising secure messenger DB with size " + maximumSize);
        DB = folder;
        DB.mkdirs();
        if (routmap == null) {
            routmap = new Cache("SecureMessengerDB", maximumSize);
        }
        stdTprov = tprov;
        if (tprov != null) {
            SecureMessengerDB.loadAll(tprov);
        }
    }

    private static File getSecureMessengerFile(String clientID, String ext) {
        File f = new File(DB, "secmsg-" + Normaliser.safeWithoutNormalising((String)clientID) + ext);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        Object object = clients_LOCK;
        synchronized (object) {
            for (String clientID : clients.keySet()) {
                SecureMessenger sm;
                Long routingID = clients.get(clientID);
                Object object2 = routing_LOCK;
                synchronized (object2) {
                    sm = (SecureMessenger)routmap.getFromCache((Object)routingID);
                }
                if (sm == null) continue;
                SecureMessengerDB.saveSecureMessenger(sm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceBCUtilForRemoteInstance(long remoteInstanceID, SecureMessenger source) {
        Object object = clients_LOCK;
        synchronized (object) {
            for (String clientID : clients.keySet()) {
                SecureMessenger sm;
                Long routingID = clients.get(clientID);
                Object object2 = routing_LOCK;
                synchronized (object2) {
                    sm = (SecureMessenger)routmap.getFromCache((Object)routingID);
                }
                if (sm == null || !mergeDuplicateTargets) continue;
                System.out.println("[SecureMessengerDB] Checking for duplicate targets: " + sm);
                if (source == sm || sm.serverInstanceID != remoteInstanceID) continue;
                sm.bcutil = source.bcutil;
                sm.myRoutingID = source.myRoutingID;
                System.out.println("[SecureMessengerDB] Replacing BCU and RouteID for SecureMessenger " + sm);
                SecureMessengerDB.saveSecureMessenger(sm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSecureMessenger(SecureMessenger sm) {
        block10: {
            System.out.println("[SecureMessengerDB] saving secmsg for " + sm.myMessengerID + "/" + sm.myRoutingID);
            sm.lastSaved = System.currentTimeMillis();
            byte[] bcupass = new byte[64];
            BCUtil.getSecureRandom().nextBytes(bcupass);
            try {
                File target = SecureMessengerDB.getSecureMessengerFile(sm.myMessengerID, ".secmsg");
                System.out.println("[SecureMessengerDB] " + sm.myMessengerID + "/" + sm.myRoutingID + " ->> " + target.getPath());
                if (Switches.SH_syncedSecmsgSaves) {
                    Object object = secmsgSave_LOCK;
                    synchronized (object) {
                        DataOutputStream dout = new DataOutputStream(new BufferedOutputStream((OutputStream)new AtomicFileOutputStream(target)));
                        dout.writeInt(SecureMessenger.VER);
                        dout.writeUTF(sm.myMessengerID);
                        dout.writeLong(sm.myRoutingID);
                        dout.writeUTF(sm.myName);
                        dout.writeInt(bcupass.length);
                        dout.write(bcupass);
                        dout.writeLong(sm.lastUsed);
                        dout.close();
                        try {
                            File bcufile = SecureMessengerDB.getSecureMessengerFile(sm.myMessengerID, ".bcutil");
                            sm.bcutil.saveBCUtil(bcufile, bcupass);
                        }
                        catch (IOException x) {
                            System.out.println("[SecureMessengerDB] unable to store BCU for " + sm.myMessengerID + " : " + x);
                        }
                        break block10;
                    }
                }
                DataOutputStream dout = new DataOutputStream(new BufferedOutputStream((OutputStream)new AtomicFileOutputStream(target)));
                dout.writeInt(SecureMessenger.VER);
                dout.writeUTF(sm.myMessengerID);
                dout.writeLong(sm.myRoutingID);
                dout.writeUTF(sm.myName);
                dout.writeInt(bcupass.length);
                dout.write(bcupass);
                dout.writeLong(sm.lastUsed);
                dout.close();
                try {
                    File bcufile = SecureMessengerDB.getSecureMessengerFile(sm.myMessengerID, ".bcutil");
                    sm.bcutil.saveBCUtil(bcufile, bcupass);
                }
                catch (IOException x) {
                    System.out.println("[SecureMessengerDB] unable to store BCU for " + sm.myMessengerID + " : " + x);
                }
            }
            catch (IOException x) {
                System.out.println("[SecureMessengerDB] unable to store client-routing mapping for " + sm.myMessengerID + " : " + x);
            }
        }
    }

    private static void loadAll(SecureMessengerTransportProvider tprov) {
        long mostRecent = 0L;
        ArrayList<SecureMessenger> loaded = new ArrayList<SecureMessenger>();
        File[] files = DB.listFiles();
        if (files != null) {
            for (File smfile : files) {
                File secmsgfile;
                String name = smfile.getName();
                if (name.endsWith(".secmsg")) {
                    File bcufile = new File(DB, name.substring(0, name.length() - 7) + ".bcutil");
                    SecureMessenger sm = SecureMessengerDB.loadSecureMessenger(smfile, bcufile, tprov);
                    if (sm == null) continue;
                    loaded.add(sm);
                    if (sm.lastUsed <= mostRecent) continue;
                    mostRecent = sm.lastUsed;
                    continue;
                }
                if (!name.endsWith(".bcutil") || (secmsgfile = new File(DB, name.substring(0, name.length() - 7) + ".secmsg")).exists()) continue;
                System.out.println("[SecureMessengerDB] Deleting orphan bcutil file " + smfile.getName());
                smfile.delete();
            }
        }
        System.out.println("[SecureMessengerDB] Most recent contact was " + new Date(mostRecent));
        for (SecureMessenger sm : loaded) {
            long diff = mostRecent - sm.lastUsed;
            long oneday = 86400000L;
            if (diff <= 3L * oneday) continue;
            SecureMessengerDB.clearSecureMessenger(sm.myMessengerID, "very old SecMsg, unused for days");
        }
    }

    public static SecureMessenger loadSecureMessenger(String messengerID, LossyClient client, LossyTransport transport, SecureMessengerListener listener) {
        File smfile = SecureMessengerDB.getSecureMessengerFile(messengerID, ".secmsg");
        File bcufile = SecureMessengerDB.getSecureMessengerFile(messengerID, ".bcutil");
        return SecureMessengerDB.loadSecureMessenger(smfile, bcufile, new SingleTransportProvider(client, transport, listener));
    }

    public static SecureMessenger loadSecureMessenger(String messengerID, SecureMessengerTransportProvider tprov) {
        File smfile = SecureMessengerDB.getSecureMessengerFile(messengerID, ".secmsg");
        File bcufile = SecureMessengerDB.getSecureMessengerFile(messengerID, ".bcutil");
        return SecureMessengerDB.loadSecureMessenger(smfile, bcufile, tprov);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecureMessenger loadSecureMessenger(File smfile, File bcufile, SecureMessengerTransportProvider tprov) {
        try {
            System.out.println("[SecureMessengerDB] Loading secmsg from " + smfile.getPath());
            if (!smfile.exists()) {
                throw new FileNotFoundException("[SecureMessengerDB] Secmsg not found for " + smfile.getPath());
            }
            AtomicFileOutputStream.prepareForReading((File)smfile);
            DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(smfile)));
            int MYVER = din.readInt();
            SecureMessenger sm = new SecureMessenger();
            sm.myMessengerID = din.readUTF();
            sm.myRoutingID = din.readLong();
            sm.myName = din.readUTF();
            byte[] bcupass = new byte[din.readInt()];
            din.readFully(bcupass);
            if (MYVER >= 2) {
                sm.lastUsed = din.readLong();
            }
            sm.bcutil = new BCUtil();
            sm.bcutil.loadBCUtil(bcufile, bcupass);
            din.close();
            sm.lossy = tprov.getLossyClient();
            sm.transport = tprov.getLossyTransportFor(sm.myMessengerID);
            sm.listener = tprov.getListener();
            if (sm.lossy == null) {
                System.out.println("[SecureMessengerDB] no L-Client for secmsg " + smfile.getName() + " (unable to load " + sm + ")");
                return null;
            }
            if (sm.transport == null) {
                System.out.println("[SecureMessengerDB] no L-Transport for secmsg " + smfile.getName() + " (unable to load " + sm + ")");
                return null;
            }
            Object object = routing_LOCK;
            synchronized (object) {
                routmap.addToCache((Object)sm.myRoutingID, (Object)sm, (CacheListener)deleteListener);
            }
            object = clients_LOCK;
            synchronized (object) {
                clients.put(sm.myMessengerID, sm.myRoutingID);
            }
            System.out.println("[SecureMessengerDB] Loaded " + sm + " OK");
            return sm;
        }
        catch (FileNotFoundException x) {
            System.out.println("[SecureMessengerDB] Secmsg file not found for " + smfile.getName());
        }
        catch (Throwable x) {
            System.out.println("[SecureMessengerDB] Unable to load secmsg for " + smfile.getName() + " : " + x);
            x.printStackTrace();
            smfile.delete();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long getRoutingID(String clientID) {
        Object object = clients_LOCK;
        synchronized (object) {
            return clients.get(clientID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void secureMessengerCreated(Long routingID, SecureMessenger sm) {
        Long oldRoute;
        Object object = routing_LOCK;
        synchronized (object) {
            System.out.println("[SecureMsg] Adding new SecureMessenger " + sm.myMessengerID + " under route " + sm.myRoutingID + " (routes: " + routmap.size() + " +1)");
            routmap.addToCache((Object)sm.myRoutingID, (Object)sm, (CacheListener)deleteListener);
        }
        Object object2 = clients_LOCK;
        synchronized (object2) {
            oldRoute = clients.get(sm.myMessengerID);
            clients.put(sm.myMessengerID, sm.myRoutingID);
        }
        if (!mergeDuplicateTargets) {
            return;
        }
        if (oldRoute != null) {
            object2 = routing_LOCK;
            synchronized (object2) {
                routmap.removeFromCache((Object)oldRoute);
            }
            System.out.println("[SecureMsg] Deleted replaced SecureMessenger (route " + oldRoute + ") (routes: " + routmap.size() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SecureMessenger fetchSecureMessengerForRoutingID(Long routingID) {
        SecureMessenger sm;
        Object object = routing_LOCK;
        synchronized (object) {
            sm = (SecureMessenger)routmap.getFromCache((Object)routingID);
        }
        return sm;
    }

    public static SecureMessenger waitForAnyExistingSetup(String messengerID) {
        return SecureMessengerDB.fetchSecureMessenger(messengerID, LossyClient.STD_TIMEOUT);
    }

    public static SecureMessenger fetchSecureMessenger(String messengerID) {
        return SecureMessengerDB.fetchSecureMessenger(messengerID, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecureMessenger fetchSecureMessenger(String messengerID, long waitForSetup) {
        SecureMessenger sm;
        Long routingID = SecureMessengerDB.getRoutingID(messengerID);
        if (routingID == null) {
            if (CentralDebugging.SECMSG_LOOKUPS) {
                System.out.println("[SecureMessengerDB] secmsg " + messengerID + " has no routing ID...");
            }
            if (CentralDebugging.DDEBUG_PROXYSERVER_MESSAGING) {
                DDLog.log(routingID, "[SecureMessengerDB] No routing ID found for secmsg " + messengerID);
            }
            return null;
        }
        if (CentralDebugging.SECMSG_LOOKUPS) {
            System.out.println("[SecureMessengerDB] Looking up secmsg " + messengerID + " under routing ID " + routingID);
        }
        Object object = routing_LOCK;
        synchronized (object) {
            sm = (SecureMessenger)routmap.getFromCache((Object)routingID);
        }
        if (sm != null) {
            if (waitForSetup > 0L) {
                long T_giveup = System.currentTimeMillis() + (long)LossyClient.STD_TIMEOUT;
                if (!sm.isReady()) {
                    System.out.println("[SecureMessengerDB] secmsg " + messengerID + " is not yet ready, will wait...");
                }
                while (!sm.isReady()) {
                    if (System.currentTimeMillis() > T_giveup) {
                        return null;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                System.out.println("[SecureMessengerDB] secmsg " + messengerID + " is ready now");
            } else if (!sm.isReady()) {
                System.out.println("[SecureMessengerDB] secmsg " + messengerID + " is not yet ready");
                return null;
            }
        }
        return sm;
    }

    static {
        deleteListener = new SecMsgDeleteListener();
        mergeDuplicateTargets = true;
        secmsgSave_LOCK = new Object();
    }

    static class SecMsgDeleteListener
    implements CacheListener<Long, SecureMessenger> {
        SecMsgDeleteListener() {
        }

        public void removedFromCache(Long key, SecureMessenger sm) {
            if (sm != null) {
                SecureMessengerDB.clearSecureMessenger(sm.myMessengerID, true, "cached maxed, fell off end");
            }
        }
    }

    private static class SingleTransportProvider
    implements SecureMessengerTransportProvider {
        LossyClient lclient;
        LossyTransport ltransport;
        SecureMessengerListener listener;

        SingleTransportProvider(LossyClient client, LossyTransport transport, SecureMessengerListener listener) {
            this.lclient = client;
            this.ltransport = transport;
            this.listener = listener;
        }

        @Override
        public LossyClient getLossyClient() {
            return this.lclient;
        }

        @Override
        public LossyTransport getLossyTransportFor(String clientID) {
            return this.ltransport;
        }

        @Override
        public SecureMessengerListener getListener() {
            return this.listener;
        }
    }
}

