/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload;

import com.aem.shelp.mdupload.LossyClient;
import com.aem.shelp.mdupload.LossyMessageHandler;
import com.aem.shelp.mdupload.LossyTransport;
import com.aem.shelp.mdupload.transports.UdpClientLossyTransport;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;

public class LossyTest
implements LossyMessageHandler {
    boolean TCP = false;
    boolean UDP_LOSSY = true;
    LossyClient lossy;
    UdpClientLossyTransport transport;

    public LossyTest(int localport, String host, int port) throws IOException {
        if (localport == port) {
            // empty if block
        }
        this.lossy = new LossyClient();
        this.lossy.init(this, new SecureRandom());
        this.transport = new UdpClientLossyTransport(this.lossy, localport, host, port);
        if (this.TCP) {
            if (localport < port) {
                new TcpTest(host, localport, true);
            } else {
                new TcpTest(host, port, false);
            }
        }
        if (this.UDP_LOSSY && localport < port) {
            int N = 20000;
            while (true) {
                this.lossy.sendLossy(this.transport, new byte[N++]);
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new LossyTest(Integer.parseInt(args[0]), args[1], Integer.parseInt(args[2]));
    }

    @Override
    public void handleAsyncMessage(byte[] m, LossyTransport respond, Long respondConversation, Object source) {
        System.out.println("Lossy: " + m.length);
    }

    class TcpTest
    extends Thread {
        Socket sock;
        boolean server;

        public TcpTest(String host, int port, boolean server) throws IOException {
            this.server = server;
            if (server) {
                System.out.println("[LossyTest] Starting TCP server on " + port);
                ServerSocket ssock = new ServerSocket(port);
                this.sock = ssock.accept();
            } else {
                System.out.println("[LossyTest] Starting TCP client to " + host + ":" + port);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sock = new Socket(host, port);
            }
            this.start();
        }

        @Override
        public void run() {
            try {
                if (this.server) {
                    byte[] dat = new byte[100000];
                    OutputStream out = this.sock.getOutputStream();
                    while (true) {
                        out.write(dat);
                    }
                }
                byte[] dat = new byte[1024];
                int K = 0;
                long next = System.currentTimeMillis() + 1000L;
                while (true) {
                    this.sock.getInputStream().read(dat);
                    ++K;
                    if (System.currentTimeMillis() <= next) continue;
                    next = System.currentTimeMillis() + 1000L;
                    System.out.println("TCP: " + K + "k/s");
                    K = 0;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                return;
            }
        }
    }
}

