/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.licence;

import com.aem.shelp.licence.License;
import com.aem.utils.StreamUtils;
import com.aem.utils.blowfish.Blowfish;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import utils.string.HexData;

public class LicenseUtil {
    static Properties props = new Properties();

    public static void getProp(String question, String key) throws IOException {
        System.out.println(question);
        String s = StreamUtils.readLine(System.in).trim();
        props.put(key, s);
    }

    public static void getIntProp(String question, String key) throws IOException, NumberFormatException {
        System.out.println(question);
        String s = StreamUtils.readLine(System.in).trim();
        props.put(key, "" + new Integer(s));
    }

    public static void getDateProp(String question, String key) throws ParseException, IOException, NumberFormatException {
        System.out.println(question);
        String s = StreamUtils.readLine(System.in).trim();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        sdf.parse(s);
        props.put(key, s);
    }

    public static void getYNProp(String question, String key) throws IOException, NumberFormatException {
        System.out.println(question);
        String s = StreamUtils.readLine(System.in).trim();
        if (!s.equalsIgnoreCase("y") && !s.equalsIgnoreCase("n")) {
            throw new IOException("must enter 'Y' or 'N'");
        }
        props.put(key, s.toUpperCase());
    }

    public static byte[] saveLicenseAsHex(License license) throws IOException {
        Blowfish bf = new Blowfish();
        bf.init(License.KEY);
        Properties props = license.getMergedPropertiesForSave();
        ArrayList<Object> list = new ArrayList<Object>(props.keySet());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamUtils.writeInt(bout, License.MAGIC);
        StreamUtils.writeInt(bout, list.size());
        for (int i = 0; i < list.size(); ++i) {
            String key = (String)list.get(i);
            String val = (String)props.get(key);
            StreamUtils.writeStringISO88591(bout, key);
            StreamUtils.writeStringISO88591(bout, val);
        }
        byte[] orig = bout.toByteArray();
        byte[] dat = bf.encryptSecure(orig, 0, orig.length, true);
        ByteArrayOutputStream ecout = new ByteArrayOutputStream();
        StreamUtils.writeInt(ecout, License.MAGIC);
        ecout.write(dat);
        String productName = "SIMPLEHELP";
        String hex = HexData.byteArrayToHexString((byte[])ecout.toByteArray());
        ecout = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(ecout);
        pout.println("::" + productName + "_LICENSE_BEGIN::");
        while (hex.length() > 0) {
            if (hex.length() > 80) {
                String s = hex.substring(0, 80);
                hex = hex.substring(80);
                pout.println(s);
                continue;
            }
            pout.println(hex);
            hex = "";
        }
        pout.println("::" + productName + "_LICENSE_END::");
        pout.close();
        return ecout.toByteArray();
    }

    public static void generateNow(String productName, OutputStream out, Properties props) throws Exception {
        Blowfish bf = new Blowfish();
        bf.init(License.KEY);
        ArrayList<Object> list = new ArrayList<Object>(props.keySet());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamUtils.writeInt(bout, License.MAGIC);
        StreamUtils.writeInt(bout, list.size());
        for (int i = 0; i < list.size(); ++i) {
            String key = (String)list.get(i);
            String val = (String)props.get(key);
            StreamUtils.writeStringISO88591(bout, key);
            StreamUtils.writeStringISO88591(bout, val);
        }
        byte[] orig = bout.toByteArray();
        byte[] dat = bf.encryptSecure(orig, 0, orig.length, true);
        ByteArrayOutputStream ecout = new ByteArrayOutputStream();
        StreamUtils.writeInt(ecout, License.MAGIC);
        ecout.write(dat);
        dat = ecout.toByteArray();
        System.out.println("License OK, writing hex file to SimpleHelpLicense.txt");
        String hex = HexData.byteArrayToHexString((byte[])dat);
        PrintStream pout = new PrintStream(out);
        pout.println("::" + productName + "_LICENSE_BEGIN::");
        while (hex.length() > 0) {
            if (hex.length() > 80) {
                String s = hex.substring(0, 80);
                hex = hex.substring(80);
                pout.println(s);
                continue;
            }
            pout.println(hex);
            hex = "";
        }
        pout.println("::" + productName + "_LICENSE_END::");
        pout.close();
    }
}

