/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.customer.disclaimer;

import com.aem.CentralDebugging;
import com.aem.SafeResourceBundle;
import com.aem.shelp.common.Language;
import com.aem.shelp.customer.disclaimer.DisclaimerListener;
import com.aem.shelp.customer.disclaimer.DisclaimerPanel;
import java.awt.BorderLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import jwrapper.jwutils.JWSystem;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;

public class DisclaimerPanelGlassDialog
extends ScaledGlassDialog
implements DisclaimerListener,
KeyListener,
ComponentListener {
    JPanel main = new JPanel();
    DisclaimerListener dl;

    public DisclaimerPanelGlassDialog(RootPaneContainer frame, DisclaimerListener dl, String disclaimer, JPanel options) {
        super(frame, DisclaimerPanelGlassDialog.checkWidth(400, frame.getRootPane().getSize().width - 20), DisclaimerPanelGlassDialog.checkHeight(300, frame.getRootPane().getSize().height - 20), true, true, false);
        this.setModal(true);
        this.dl = dl;
        this.main.setLayout(new BorderLayout());
        DisclaimerPanel dp = new DisclaimerPanel(disclaimer, this, options, this);
        this.main.addKeyListener(this);
        this.main.add("Center", dp);
        this.getContentPane().add(this.main);
        this.setTitle(Language.get("DISCLAIMER_TITLE"));
        frame.getGlassPane().addComponentListener(this);
        if (CentralDebugging.GLASS_DIALOGS_VERBOSE) {
            System.out.println("Setting glass disclaimer visible");
        }
        this.setVisible(true);
        if (CentralDebugging.GLASS_DIALOGS_VERBOSE) {
            System.out.println("Set glass disclaimer visible");
        }
    }

    public static void main(String[] args) throws IOException {
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(200, 500);
        frame.setVisible(true);
        SafeResourceBundle.loadTestBundle();
        DisclaimerPanelGlassDialog dp = new DisclaimerPanelGlassDialog((RootPaneContainer)frame, null, "asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd asd ", new JPanel());
    }

    private static int checkWidth(int desiredWidth, int max) {
        String prop = JWSystem.getAppLaunchProperty((String)"disclaimer_width");
        if (prop != null && prop.length() > 0) {
            try {
                desiredWidth = Integer.parseInt(prop);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Math.min(desiredWidth, max);
    }

    private static int checkHeight(int desiredWidth, int max) {
        String prop = JWSystem.getAppLaunchProperty((String)"disclaimer_height");
        if (prop != null && prop.length() > 0) {
            try {
                desiredWidth = Integer.parseInt(prop);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Math.min(desiredWidth, max);
    }

    @Override
    public void disclaimerAccepted() {
        this.setVisible(false);
        this.src_rootPane.getGlassPane().removeComponentListener(this);
        this.dl.disclaimerAccepted();
    }

    @Override
    public void disclaimerRejected() {
        this.setVisible(false);
        this.src_rootPane.getGlassPane().removeComponentListener(this);
        this.dl.disclaimerRejected();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.disclaimerAccepted();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int newHeight;
        int currentHeight;
        int currentWidth = this.getWidth();
        int newWidth = DisclaimerPanelGlassDialog.checkWidth(400, this.src_rootPane.getRootPane().getSize().width - 10);
        boolean repaint = false;
        if (currentWidth != newWidth) {
            this.setWidth(newWidth);
            repaint = true;
        }
        if ((currentHeight = this.getHeight()) != (newHeight = DisclaimerPanelGlassDialog.checkHeight(300, this.src_rootPane.getRootPane().getSize().height - 10))) {
            this.setHeight(newHeight);
            repaint = true;
        }
        if (repaint) {
            this.repaint();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

