/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.customer.details;

import com.aem.sdesktop.server.gui.ConnectionSettings;
import com.aem.shelp.common.Language;
import com.aem.shelp.customer.details.DetailsListener;
import com.aem.shelp.customer.details.DetailsPanel;
import com.aem.shelp.proxy.types.Customer;
import java.awt.BorderLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import jwrapper.jwutils.JWSystem;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;

public class DetailsPanelGlassDialog
extends ScaledGlassDialog
implements DetailsListener,
ComponentListener {
    DetailsListener dl;
    JPanel main = new JPanel();
    private DetailsPanel dp;

    private ResultPair[] getResultPairFrom(Customer customer) {
        if (customer == null) {
            return new ResultPair[0];
        }
        ArrayList<ResultPair> pairs = new ArrayList<ResultPair>();
        String[] keys = customer.getDetailsKeys();
        String[] values = customer.getDetailsValues();
        for (int i = 0; i < keys.length; ++i) {
            pairs.add(new ResultPair(keys[i], values[i]));
        }
        ResultPair[] res = new ResultPair[pairs.size()];
        pairs.toArray(res);
        return res;
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        DetailsPanelGlassDialog dpg = new DetailsPanelGlassDialog(Language.DEFLANG, (RootPaneContainer)frame, null, null, true, new ConnectionSettings(null));
    }

    public DetailsPanelGlassDialog(ResourceBundle lang, RootPaneContainer frame, DetailsListener dl, CUIField[] config, boolean requiresPassword, ConnectionSettings settings) {
        super(frame, DetailsPanelGlassDialog.checkWidth(400, frame.getRootPane().getSize().width - 10), 50, true, true, false);
        this.setModal(true);
        this.dl = dl;
        this.main.setLayout(new BorderLayout());
        frame.getRootPane().addComponentListener(this);
        this.dp = new DetailsPanel(this, config, requiresPassword, this.getResultPairFrom(settings.getCustomer()), settings.queuePassword);
        int height = this.getAdjustedHeight();
        this.setHeight(height);
        this.main.add("Center", this.dp);
        this.getContentPane().add(this.main);
        this.setTitle(lang.getString("INPUT_DETAILS_TITLE"));
        this.setFocusComponent(this.dp.getFocusComponent());
        this.setVisible(true);
    }

    private int getAdjustedHeight() {
        int height = this.dp.getPreferredSize().height + 40;
        int max = this.src_rootPane.getRootPane().getSize().height - 10;
        if (height > max) {
            height = max;
        }
        height = DetailsPanelGlassDialog.checkHeight(height, this.src_rootPane.getRootPane().getSize().height - 10);
        return height;
    }

    private static int checkWidth(int desiredWidth, int max) {
        String prop = JWSystem.getAppLaunchProperty((String)"details_width");
        if (prop != null && prop.length() > 0) {
            try {
                desiredWidth = Integer.parseInt(prop);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Math.min(desiredWidth, max);
    }

    private static int checkHeight(int desiredHeight, int max) {
        String prop = JWSystem.getAppLaunchProperty((String)"details_height");
        if (prop != null && prop.length() > 0) {
            try {
                desiredHeight = Integer.parseInt(prop);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Math.min(desiredHeight, max);
    }

    @Override
    public void detailsAccepted(ResultPair[] results, String queuePassword) {
        this.setVisible(false);
        this.src_rootPane.getRootPane().removeComponentListener(this);
        this.dl.detailsAccepted(results, queuePassword);
    }

    @Override
    public void detailsRejected() {
        this.setVisible(false);
        this.src_rootPane.getRootPane().removeComponentListener(this);
        this.dl.detailsRejected();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int newHeight;
        int currentHeight;
        int currentWidth = this.getWidth();
        int newWidth = DetailsPanelGlassDialog.checkWidth(400, this.src_rootPane.getRootPane().getSize().width - 20);
        boolean repaint = false;
        if (currentWidth != newWidth) {
            this.setWidth(newWidth);
            repaint = true;
        }
        if ((currentHeight = this.getHeight()) != (newHeight = this.getAdjustedHeight())) {
            this.setHeight(newHeight);
            repaint = true;
        }
        if (repaint) {
            this.repaint();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

