/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.customer.details;

import com.aem.shelp.common.Language;
import com.aem.shelp.customer.details.DetailsListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import utils.swing.cui.layouts.CUIHorizontalPanel;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;

public class DetailsPanel
extends JPanel
implements ActionListener,
KeyListener {
    private JButton bok;
    private DetailsListener listener;
    private JTextField focusField = null;
    private CUIHorizontalPanel panel;
    private TextField passwordField;
    private AbstractField.ChangeListener changeListener = new AbstractField.ChangeListener(){

        public void changed(AbstractField source) {
            if (DetailsPanel.this.panel.isValid()) {
                DetailsPanel.this.bok.setEnabled(true);
            } else {
                DetailsPanel.this.bok.setEnabled(false);
            }
        }
    };

    public DetailsPanel(DetailsListener listener, CUIField[] fields, boolean passwordRequired, ResultPair[] defaultValues, String defaultQueuePassword) {
        this.listener = listener;
        this.panel = new CUIHorizontalPanel(new ScaledInsets(5, 10, 5, 5), true);
        if (fields != null) {
            this.panel.addAll(fields);
        }
        if (passwordRequired) {
            this.passwordField = new TextField(Language.get("DETAILS_PASSWORD_LABEL"), null);
            this.panel.add((CUIField)this.passwordField);
            if (defaultQueuePassword != null) {
                this.passwordField.setDefaultValue(defaultQueuePassword);
            }
            this.passwordField.getComponent().addKeyListener(this);
        }
        this.panel.setChangeListener(this.changeListener);
        if (fields != null) {
            Color background = this.panel.getRootComponent().getBackground();
            for (CUIField field : fields) {
                if (field instanceof TextField) {
                    ((TextField)field).getComponent().addKeyListener(this);
                    String defaultValue = this.getDefaultValue(field.getLabel(), defaultValues);
                    if (defaultValue != null) {
                        ((TextField)field).setDefaultValue(defaultValue);
                    }
                }
                if (!(field instanceof AbstractField)) continue;
                ((AbstractField)field).setBackground(background);
            }
        }
        this.bok = new JButton(Language.get("CONTINUE"), ImageLoader.getImageIcon((String)"images/svg/arrows/right-moving.svg,16"));
        SHButtonUI.makeButtonBlue((JButton)this.bok);
        this.setLayout(new BorderLayout());
        JPanel wrapperPanel = new JPanel(new BorderLayout());
        wrapperPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)20, (int)0, (int)20));
        wrapperPanel.add("North", (Component)this.panel.getRootComponent());
        JScrollPane sp = new JScrollPane(wrapperPanel);
        sp.setBorder(SHBorderFactory.createEmptyBorder());
        this.add("Center", sp);
        JPanel buttons = new JPanel();
        this.add("South", buttons);
        buttons.setLayout((LayoutManager)new ScaledFlowLayout(1, SimpleHelpLookAndFeel.scale((int)15), SimpleHelpLookAndFeel.scale((int)15)));
        buttons.add(this.bok);
        this.bok.addActionListener(this);
        this.bok.setEnabled(this.panel.isValid());
    }

    private String getDefaultValue(String labelKey, ResultPair[] defaultValues) {
        if (defaultValues == null) {
            return "";
        }
        for (ResultPair defaultValue : defaultValues) {
            String key = defaultValue.getKey();
            String value = defaultValue.getValue();
            if (!key.equalsIgnoreCase(labelKey)) continue;
            return value;
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    private void actionPerformed(Object o) {
        if (o == this.bok) {
            ResultPair[] filledOutResults = this.panel.getFilledOutResults((ResourceBundle)Language.DEFLANG);
            String password = null;
            if (this.passwordField != null) {
                ResultPair[] newResults = new ResultPair[filledOutResults.length - 1];
                System.arraycopy(filledOutResults, 0, newResults, 0, newResults.length);
                password = filledOutResults[filledOutResults.length - 1].getValue();
            }
            this.listener.detailsAccepted(filledOutResults, password);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.bok.isEnabled()) {
            this.actionPerformed(this.bok);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public JComponent getFocusComponent() {
        return this.focusField;
    }

    @Override
    public void grabFocus() {
    }
}

