/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.customer;

import com.aem.sdesktop.ClientBranding;
import com.aem.shelp.common.CommonStandalone;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.MatchedVersionServerUnavailableDialog;
import com.aem.shelp.customer.CustomerServerUnavailableDialog;
import com.aem.shelp.customer.ui.ConnectOptionGlassDialog;
import com.aem.utils.Debugger;
import com.jw.AuxConfig;
import java.net.URISyntaxException;
import javax.swing.Icon;
import javax.swing.RootPaneContainer;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dialog.jdialog.MessageDialog;
import utils.swing.images.ImageLoader;

public class StandaloneCustomer
extends CommonStandalone {
    public static void main(String[] args) throws URISyntaxException {
        AuxConfig.initAuxDownload();
        if (StandaloneCustomer.isSilentInstall(args)) {
            return;
        }
        new StandaloneCustomer();
    }

    @Override
    protected String getTitle() {
        return Language.get("CUSTOMER_STANDALONE_TITLE");
    }

    @Override
    protected MatchedVersionServerUnavailableDialog showUnavailableDialog() {
        return new CustomerServerUnavailableDialog();
    }

    public StandaloneCustomer() {
        super("StandaloneCustomer");
        this.initFrame();
        this.mainFrame.setSize(this.getDesiredWidth(600), this.getDesiredHeight(500));
        this.mainFrame.setVisible(true);
        this.mainFrame.toFront();
        try {
            this.establishConnectionToServer(true);
            this.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
            String str = Debugger.getStackTrace(t);
            SHGlassOptionPane.showErrorDialog((RootPaneContainer)this.mainFrame, (String)("<HTML>An unidentified error ocurred.<BR><BR>Details: " + str + "</HTML>"), (String)"Error", (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            System.exit(1);
        }
    }

    private String promptForConnectionType() {
        ConnectOptionGlassDialog dialog = new ConnectOptionGlassDialog(this.mainFrame, false);
        return dialog.getInvitationCode();
    }

    public void start() {
        try {
            this.helpUtil.startCustomer();
        }
        catch (Throwable t) {
            t.printStackTrace();
            SHGlassOptionPane.showMessageDialog((RootPaneContainer)this.mainFrame, (String)Debugger.getStackTrace(t), (String)"Error", null, (String)Language.get("CLOSE"));
        }
    }

    @Override
    public boolean canClose() {
        if (this.helpUtil != null && this.helpUtil.hasStarted()) {
            MessageDialog dialog = MessageDialog.getDecoratedDialog(this.mainFrame, 420, Language.get("CONFIRM_CLOSE_CUSTOMER"), Language.get("CONFIRM_CLOSE_TITLE"), Language.get("CLOSE_SESSION"), Language.get("CANCEL"), ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"));
            try {
                dialog.setDialogIconImage(ClientBranding.get().getLogo32(true).getImage());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            dialog.showDialog();
            return dialog.isOKResult();
        }
        return true;
    }
}

