/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.video;

import bcutil.BCUtil;
import com.aem.SaltedFileUtil;
import com.aem.shelp.common.ClientEncryption;
import com.aem.shelp.common.CommonEncryptors;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.tech.video.VideoMetadata;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.gziplist.ChunkList;
import utils.dataservice.gziplist.SplitChunkList;
import utils.dataservice.gziplist.policies.CachePolicy;
import utils.dataservice.gziplist.policies.NullCachePolicy;
import utils.dataservice.local.datalist.split.SplitByteArrayList;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.progtools.collections.FixedSizeMap;
import utils.stream.StreamPiper;
import utils.stream.StreamUtils;
import utils.string.Base64;
import utils.xml.XML14Util;

public class VideoUtils {
    public static final String LEGACY_VIDEO_EXTENSION = ".svf";
    public static final String LEGACY_VIDEO_SETTINGS_EXTENSION = ".cfg";
    public static final String LEGACY_VIDEO_HTML_EXTENSION = ".html";
    public static final String ENC_VIDEO_EXTENSION = ".esvf";
    public static final String ENC_VIDEO_SETTINGS_EXTENSION = ".ecfg";
    public static final String ENC_VIDEO_HTML_EXTENSION = ".ehtml";
    public static final File VIDEOS_FOLDER = new File("configuration/recordings");
    private static final SimpleDateFormat VIDEO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    private static final Object LOCK = new Object();
    private static final FixedSizeMap<String, VideoMetadata> videoMetadataCache = new FixedSizeMap(10, 10);

    public static boolean isVideoFileResource(File file) {
        if (file.exists()) {
            String name = file.getName();
            return name.endsWith(LEGACY_VIDEO_EXTENSION) || name.endsWith(LEGACY_VIDEO_SETTINGS_EXTENSION) || name.endsWith(LEGACY_VIDEO_HTML_EXTENSION) || name.endsWith(ENC_VIDEO_EXTENSION) || name.endsWith(ENC_VIDEO_SETTINGS_EXTENSION) || name.endsWith(ENC_VIDEO_HTML_EXTENSION);
        }
        return false;
    }

    public static long getVideoCreationDate(File file) {
        if (file.exists()) {
            try {
                return VIDEO_DATE_FORMAT.parse(file.getName()).getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfig(File configFile, VideoConfig config, SaltedFileUtil encryptor) throws IOException {
        System.out.println("[ProxyServer] Saving " + configFile);
        Object object = LOCK;
        synchronized (object) {
            StringBuilder xml = new StringBuilder();
            xml.append("<VideoConfig>\n");
            if (config.hasPassword()) {
                String base64Password = Base64.byteArrayToBase64((byte[])config.passwordBytesUTF8);
                xml.append("\t<VideoPassword>").append(base64Password).append("</VideoPassword>\n");
            }
            xml.append("</VideoConfig>\n");
            Object object2 = LOCK;
            synchronized (object2) {
                encryptor.writeFile(configFile.getAbsolutePath(), configFile, xml.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static void migrateToEncrypted(Runnable notificationTracker) {
        FileUtil.FileIterator depthFirstIterator = FileUtil.getDepthFirstIterator((File)VIDEOS_FOLDER);
        while (depthFirstIterator.hasNext()) {
            File candidate = depthFirstIterator.next();
            try {
                VideoUtils.migrateToEncrypted(candidate, notificationTracker);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateToEncrypted(File file, Runnable notificationTracker) throws IOException {
        block33: {
            if (file.getName().endsWith(LEGACY_VIDEO_SETTINGS_EXTENSION)) {
                System.out.println("[VideoMigration] Migrating " + file.getName());
                File newFile = new File(file.getParentFile(), file.getName().replace(LEGACY_VIDEO_SETTINGS_EXTENSION, ENC_VIDEO_SETTINGS_EXTENSION));
                boolean worked = false;
                try {
                    notificationTracker.run();
                    VideoConfig config = VideoUtils.loadConfig(file, CommonEncryptors.generalEncryptor);
                    VideoUtils.saveConfig(newFile, config, CommonEncryptors.generalEncryptor);
                    worked = true;
                }
                finally {
                    if (worked) {
                        file.delete();
                    } else {
                        file.renameTo(new File(file.getParentFile(), file.getName() + ".legacy"));
                    }
                }
            }
            if (file.getName().endsWith(LEGACY_VIDEO_HTML_EXTENSION)) {
                System.out.println("[VideoMigration] Migrating " + file.getName());
                File newFile = new File(file.getParentFile(), file.getName().replace(LEGACY_VIDEO_HTML_EXTENSION, ENC_VIDEO_HTML_EXTENSION));
                boolean worked = false;
                try {
                    notificationTracker.run();
                    OutputStream outputStream = CommonEncryptors.generalEncryptor.saveFileAsStream(file.getAbsolutePath(), newFile, false);
                    try {
                        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
                        try {
                            StreamPiper.pipe((InputStream)bin, (OutputStream)outputStream, (boolean)true, (boolean)false, (boolean)false);
                            worked = true;
                            break block33;
                        }
                        finally {
                            FileUtil.robustClose((InputStream)bin);
                        }
                    }
                    finally {
                        FileUtil.robustClose((OutputStream)outputStream);
                    }
                }
                finally {
                    if (worked) {
                        file.delete();
                    } else {
                        file.renameTo(new File(file.getParentFile(), file.getName() + ".legacy"));
                    }
                }
            }
            if (file.getName().endsWith(LEGACY_VIDEO_EXTENSION)) {
                System.out.println("[VideoMigration] Migrating " + file.getName());
                File newFile = new File(file.getParentFile(), file.getName().replace(LEGACY_VIDEO_EXTENSION, ENC_VIDEO_EXTENSION));
                ChunkHeader header = new ChunkHeader();
                SplitByteArrayList oldList = new SplitByteArrayList(file, header, 0x2800000L, null, (CachePolicy)new NullCachePolicy());
                SplitByteArrayList newByteArrayList = new SplitByteArrayList(newFile, header, 0x2800000L, (ChunkList.EncryptionKeyRepository)ClientEncryption.INSTANCE, (CachePolicy)new NullCachePolicy());
                boolean worked = false;
                try {
                    notificationTracker.run();
                    for (long i = 0L; i < oldList.size(); ++i) {
                        double time = oldList.getTime(i);
                        byte[] data = oldList.getBytes(i);
                        newByteArrayList.addBytes(time, data);
                    }
                    worked = true;
                }
                finally {
                    try {
                        oldList.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        newByteArrayList.close();
                    }
                    catch (Throwable throwable) {}
                    if (worked) {
                        file.delete();
                    } else {
                        file.renameTo(new File(file.getParentFile(), file.getName() + ".legacy"));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VideoConfig loadConfig(File configFile, SaltedFileUtil encryptor) {
        VideoConfig config;
        block11: {
            System.out.println("[ProxyServer] Loading " + configFile);
            config = new VideoConfig();
            try {
                byte[] bytes;
                if (configFile.getName().endsWith(LEGACY_VIDEO_SETTINGS_EXTENSION)) {
                    String xmlData;
                    Object object = LOCK;
                    synchronized (object) {
                        AtomicFileOutputStream.prepareForReading((File)configFile);
                        xmlData = StreamUtils.readAllAsStringUTF8((InputStream)new FileInputStream(configFile));
                    }
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document dom = builder.parse(new InputSource(new StringReader(xmlData)));
                    Element root = dom.getDocumentElement();
                    Element passwordElement = XML14Util.getChild((Element)root, (String)"VideoPassword");
                    if (passwordElement != null) {
                        String text = XML14Util.getTextContent((Node)passwordElement);
                        String dataBase64 = text.substring(0, text.indexOf(32));
                        byte[] data = Base64.base64ToByteArray((String)dataBase64);
                        String saltBase64 = text.substring(text.indexOf(32) + 1);
                        config.passwordBytesUTF8 = BCUtil.decryptWithSecret((byte[])data, (String)saltBase64, (String)"C7F7NDyQ/0oL7fPe7NpdE12HMrkn7PIWizNuGijpJWGKw06Pk2GNEjg/5yElK66Il9H/E22BYPmYOMA6c6fIpw==", (int)200);
                    }
                    break block11;
                }
                Object builder = LOCK;
                synchronized (builder) {
                    bytes = encryptor.readFile(configFile.getAbsolutePath(), configFile);
                }
                String xml = new String(bytes, StandardCharsets.UTF_8);
                DocumentBuilder builder2 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document dom = builder2.parse(new InputSource(new StringReader(xml)));
                Element root = dom.getDocumentElement();
                Element passwordElement = XML14Util.getChild((Element)root, (String)"VideoPassword");
                if (passwordElement != null) {
                    String base64 = XML14Util.getTextContent((Node)passwordElement);
                    config.passwordBytesUTF8 = Base64.base64ToByteArray((String)base64);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                return new VideoConfig();
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VideoMetadata loadMetadata(File videoFile) throws IOException {
        if (!videoFile.exists()) {
            return null;
        }
        FixedSizeMap<String, VideoMetadata> fixedSizeMap = videoMetadataCache;
        synchronized (fixedSizeMap) {
            VideoMetadata videoMetadata = (VideoMetadata)videoMetadataCache.get(videoFile.getName());
            if (videoMetadata != null) {
                return videoMetadata;
            }
            ChunkHeader header = ChunkList.readHeader(videoFile, ClientEncryption.INSTANCE);
            videoMetadata = VideoMetadata.deserialise(header.getHeaderData());
            videoMetadataCache.put(videoFile.getName(), videoMetadata);
            return videoMetadata;
        }
    }

    public static long getVideoDuration(File videoFile) throws IOException {
        VideoMetadata metadata = VideoUtils.loadMetadata(videoFile);
        if (metadata != null) {
            return metadata.getDuration();
        }
        return 0L;
    }

    public static Dimension getScreenSize(File videoFile) throws IOException {
        VideoMetadata metadata = VideoUtils.loadMetadata(videoFile);
        if (metadata != null) {
            return metadata.getScreenSize();
        }
        return null;
    }

    public static long getStartTimeFromFileName(File file) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
        return sdf.parse(file.getName()).getTime();
    }

    public static String getSessionIDFromFileName(File file) {
        String name = file.getName();
        int index = name.indexOf("--");
        if (index == -1) {
            return null;
        }
        int dotIndex = name.indexOf(46, index += "--".length());
        return name.substring(index, dotIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getVideoFileName(File parent, long startTime, String id, String extension) {
        StringBuilder name = new StringBuilder();
        SimpleDateFormat simpleDateFormat = VIDEO_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            name.append(VIDEO_DATE_FORMAT.format(new Date(startTime)));
        }
        name.append("--");
        name.append(id);
        name.append(extension);
        return new File(parent, name.toString());
    }

    public static File getVideoFileName(File parent, AbstractSession session, String extension) {
        return VideoUtils.getVideoFileName(parent, session.getStartTime(), session.getSessionID(), extension);
    }

    public static File getServerVideoFile_server_side_call_only(long startTime, String id, String extension) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(startTime);
        int year = cal.get(1);
        int month = cal.get(2);
        File parentFolder = new File(new File(VIDEOS_FOLDER, Integer.toString(year)), Integer.toString(month));
        return VideoUtils.getVideoFileName(parentFolder, startTime, id, extension);
    }

    public static long getTotalSize(File videoFile) {
        long total = 0L;
        while (videoFile.exists()) {
            total += videoFile.length();
            videoFile = SplitChunkList.iterate(videoFile);
        }
        return total;
    }

    public static int getPartsCount(File videoFile) {
        int total = 0;
        while (videoFile.exists()) {
            ++total;
            videoFile = SplitChunkList.iterate(videoFile);
        }
        return total;
    }

    public static void main(String[] args) throws IOException {
        File file = new File("/Users/gchristelis/Documents/workspace/SimpleHelp/configuration/recordings/2018/3/2018-04-10-14-36-17-976--15233709708330.esvf");
        long videoDuration = VideoUtils.getVideoDuration(file);
        System.out.println(videoDuration);
    }

    public static class VideoConfig {
        public byte[] passwordBytesUTF8;

        public boolean hasPassword() {
            return this.passwordBytesUTF8 != null && this.passwordBytesUTF8.length > 0;
        }

        public boolean passwordMatches(String candidate) {
            return new String(this.passwordBytesUTF8, StandardCharsets.UTF_8).matches(candidate);
        }
    }
}

