/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.properties;

import com.aem.shelp.common.properties.AbstractProperties;
import java.io.File;
import jwrapper.jwutils.JWSystem;

public class LocalProperties
extends AbstractProperties {
    public static LocalProperties INSTANCE = new LocalProperties(new File(JWSystem.getAllAppVersionsSharedFolder(), "tech.properties"));
    public static String PROP_ACCESS_HIERARCHY = "access_hierarchy";
    public static String PROP_ACCESS_MIN_MAX = "access_hierarchy_mm";
    public static String PROP_ALERT_HIERARCHY = "alert_hierarchy";
    public static String PROP_ALERT_MIN_MAX = "alert_hierarchy_mm";
    public static String PROP_DARK_MODE = "dark";
    public static String PROP_SCALING_PERCENTAGE = "scaling";

    public LocalProperties(File file) {
        super(file);
    }

    public static int getScalingPercentageOverride() {
        try {
            int scaling = INSTANCE.getIntProp(PROP_SCALING_PERCENTAGE, -1, 50, 300);
            System.out.println("[LocalProperties] Scaling override is " + scaling);
            return scaling;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return -1;
        }
    }

    public static void setScalingPercentageOverride(int override) {
        try {
            System.out.println("[LocalProperties] Setting scaling override to " + override);
            if (override <= 0) {
                INSTANCE.setPropAndSaveIn(PROP_SCALING_PERCENTAGE, null, 0);
            } else {
                INSTANCE.setPropAndSaveIn(PROP_SCALING_PERCENTAGE, Integer.toString(override), 0);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static boolean isDarkMode() {
        try {
            boolean dm = INSTANCE.getBooleanProp(PROP_DARK_MODE, false);
            System.out.println("[LocalProperties] Dark mode set to " + dm);
            return dm;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public static void setDarkMode(boolean dark) {
        try {
            System.out.println("[LocalProperties] Setting dark mode to " + dark);
            INSTANCE.setPropAndSaveIn(PROP_DARK_MODE, dark ? "true" : "false", 0);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    protected String getPrefix() {
        return null;
    }
}

