/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.properties;

import com.aem.ServerManagement;
import com.aem.shelp.tech.TechHelpUIIPCHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.progtools.DirtyProperties;
import utils.progtools.time.Time;
import utils.switches.Switches;

public abstract class AbstractProperties {
    private final File localFile;
    private PropertiesSaver server;
    private DirtyProperties props;
    private final Object LOCK = new Object();
    private static Timer propertiesSaveTimer = new Timer();
    private boolean saveScheduled = false;
    private boolean amWritable = false;

    protected abstract String getPrefix();

    public AbstractProperties() {
        this.localFile = null;
    }

    public AbstractProperties(File localFile) {
        this.localFile = localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.props == null) {
                this.props = new DirtyProperties();
                try {
                    this.loadFromLocalFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromLocalFile() throws FileNotFoundException {
        if (this.localFile != null && this.localFile.exists()) {
            AtomicFileOutputStream.prepareForReading((File)this.localFile);
            FileInputStream fin = new FileInputStream(this.localFile);
            BufferedInputStream bin = new BufferedInputStream(fin);
            try {
                this.props.load(bin);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                FileUtil.robustClose((InputStream)bin);
            }
        }
    }

    protected void saveToLocalFile() throws IOException {
        if (this.localFile != null) {
            try (AtomicFileOutputStream fout = new AtomicFileOutputStream(this.localFile);){
                this.props.store((OutputStream)fout, "Local technican properties");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overrideRemoteStoreIfItIsSet(PropertiesSaver client) {
        if (ServerManagement.isServerJVM()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.server == null) {
                return;
            }
            this.server = client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteStore(PropertiesSaver client) {
        if (ServerManagement.isServerJVM()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.server = client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitFrom(byte[] dat) {
        Object object = this.LOCK;
        synchronized (object) {
            try {
                GZIPInputStream gzin = new GZIPInputStream(new ByteArrayInputStream(dat));
                if (this.props == null) {
                    this.props = new DirtyProperties();
                }
                this.props.load(gzin);
                gzin.close();
                this.postProcess();
                this.props.markClean();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postProcess() {
        Object object = this.LOCK;
        synchronized (object) {
            Properties newProps = (Properties)this.props.clone();
            this.props.clear();
            String prefix = this.getPrefix();
            for (Object key : newProps.keySet()) {
                String keyString = (String)key;
                String value = (String)newProps.get(keyString);
                if (!keyString.startsWith(prefix)) continue;
                this.props.setProperty(keyString.substring(prefix.length() + 1), value);
            }
            for (Object key : this.props.keySet()) {
                Object value = this.props.get(key);
                System.out.println("[AbstractProperties:" + this.getPrefix() + "] " + key + " = " + value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getMyProperties() {
        this.init();
        Object object = this.LOCK;
        synchronized (object) {
            return (Properties)this.props.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMyProperties(String myPrefix, Properties mine) {
        this.init();
        Object object = this.LOCK;
        synchronized (object) {
            Object[] keys;
            for (Object key1 : keys = mine.keySet().toArray()) {
                String key = (String)key1;
                this.props.setProperty(key, mine.getProperty(key));
            }
        }
    }

    public void setMyPropertiesAndSave(Properties myProperties) {
        this.setMyProperties(this.getPrefix(), myProperties);
        this.save();
    }

    public int getIntProp(String key, int def, int min, int max) {
        String s = this.getProp(key);
        if (s == null) {
            return def;
        }
        try {
            int n = Integer.parseInt(s);
            if (n < min) {
                n = min;
            }
            if (n > max) {
                n = max;
            }
            return n;
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean getBooleanProp(String key, boolean def) {
        String s = this.getProp(key, "" + def);
        try {
            return s.equalsIgnoreCase("true");
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean getBooleanProp(String key) {
        String s = this.getProp(key);
        try {
            return s.equalsIgnoreCase("true");
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProp(String key) {
        this.init();
        Object object = this.LOCK;
        synchronized (object) {
            String ret = this.props.getProperty(key);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProp(String key, String def) {
        this.init();
        Object object = this.LOCK;
        synchronized (object) {
            String ret = this.props.getProperty(key);
            if (ret == null) {
                return def;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropNoSave(String key, String value) {
        this.init();
        Object object = this.LOCK;
        synchronized (object) {
            if (value == null) {
                this.props.remove(key);
            } else {
                this.props.setProperty(key, value);
            }
        }
    }

    public void setPropAndSave(String key, String value) {
        this.setPropNoSave(key, value);
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropAndSaveIn(String key, String value, int millisecondsTillSave) {
        this.setPropNoSave(key, value);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.saveScheduled) {
                return;
            }
            System.out.println("[AbstractProperties] Scheduling save in " + millisecondsTillSave + "ms");
            propertiesSaveTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = AbstractProperties.this.LOCK;
                    synchronized (object) {
                        AbstractProperties.this.save();
                        AbstractProperties.this.saveScheduled = false;
                    }
                }
            }, millisecondsTillSave);
            this.saveScheduled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getChangedPropertiesForMerging() {
        Object object = this.LOCK;
        synchronized (object) {
            this.init();
            Properties merge = new Properties();
            Iterator dirty = this.props.getDirtyKeys();
            while (dirty.hasNext()) {
                String key = (String)dirty.next();
                String value = (String)this.props.get(key);
                merge.put(this.getPrefix() + "_" + key, value);
            }
            this.props.markClean();
            return merge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getAllPropertiesForSaving() {
        Object object = this.LOCK;
        synchronized (object) {
            this.init();
            Properties result = new Properties();
            for (Object key : this.props.keySet()) {
                String sKey = (String)key;
                String value = this.props.getProperty(sKey);
                sKey = this.getPrefix() + "_" + sKey;
                result.setProperty(sKey, value);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] saveAllPropertiesToBytes() {
        Properties prefixedProperties = this.getAllPropertiesForSaving();
        Object object = this.LOCK;
        synchronized (object) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                GZIPOutputStream gout = new GZIPOutputStream(bout);
                prefixedProperties.store(gout, "SimpleSuite Properties");
                gout.finish();
                gout.close();
                return bout.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void makeWritable() {
        this.amWritable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (ServerManagement.isServerJVM()) {
            return;
        }
        if (!this.amWritable && Switches.SH_readOnlyPropertyMaps) {
            System.out.println("[StaticProperties] Not allowed to save these properties (have not been made writable)");
            return;
        }
        this.init();
        System.out.println("[StaticProperties] Saving properties locally");
        try {
            this.saveToLocalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.server != null) {
            System.out.println("[StaticProperties] Saving properties to remote server");
            Properties prefixedProperties = Switches.SH_uploadDirtyPropertiesOnly ? this.getChangedPropertiesForMerging() : this.getAllPropertiesForSaving();
            Object object = this.LOCK;
            synchronized (object) {
                try {
                    if (Switches.SH_uploadDirtyPropertiesOnly) {
                        RemoteUpdate ru = new RemoteUpdate(this.server, true);
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        GZIPOutputStream gout = new GZIPOutputStream(bout);
                        prefixedProperties.store(gout, "SimpleSuite Properties for Merging");
                        gout.finish();
                        gout.close();
                        ru.data = bout.toByteArray();
                        ru.start();
                    } else {
                        RemoteUpdate ru = new RemoteUpdate(this.server, false);
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        GZIPOutputStream gout = new GZIPOutputStream(bout);
                        prefixedProperties.store(gout, "SimpleSuite Properties");
                        gout.finish();
                        gout.close();
                        ru.data = bout.toByteArray();
                        ru.start();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface PropertiesSaver {
        public void mergeTechProperties(String var1, byte[] var2) throws Exception;

        public void setTechProperties(String var1, byte[] var2) throws Exception;
    }

    class RemoteUpdate
    extends Thread {
        byte[] data;
        PropertiesSaver server;
        boolean isPartial;

        public RemoteUpdate(PropertiesSaver server, boolean isPartial) {
            this.server = server;
            this.isPartial = isPartial;
        }

        @Override
        public void run() {
            try {
                System.out.println("[StaticProperties] Sending Tech Properties");
                Time t = new Time();
                if (this.isPartial) {
                    this.server.mergeTechProperties(AbstractProperties.this.getPrefix(), this.data);
                } else {
                    this.server.setTechProperties(AbstractProperties.this.getPrefix(), this.data);
                }
                System.out.println("[StaticProperties] Sending Tech Properties took " + t.lap() + "ms");
                if (AbstractProperties.this.getPrefix().equals("session") && TechHelpUIIPCHandler.INSTANCE != null) {
                    System.out.println("[StaticProperties] Sending Tech Properties to TechUI over IPC");
                    TechHelpUIIPCHandler.INSTANCE.sendNewSessionProperties(this.data);
                    System.out.println("[StaticProperties] Sending Tech Properties to TechUI over IPC took " + t.lap() + "ms");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

