/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.login;

import com.aem.sdesktop.ClientBranding;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.images.Icons;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.util.RequestFocusListener;
import com.aem.utils.StreamUtils;
import com.aem.utils.blowfish.Blowfish;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import jwrapper.jwutils.JWSystem;
import utils.string.Normaliser;
import utils.swing.SwingUtil;
import utils.swing.components.ScaledImageLabel;
import utils.swing.components.messagefields.MessagePasswordTextField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthLabel;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.GlassDialog;
import utils.swing.images.ImageHelper;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.switches.oem.OEMSwitches;

public class TechUiLoginGlassDialog
extends GlassDialog
implements ActionListener,
KeyListener {
    private TextField loginField;
    private TextField passwordField;
    private JPanel sourcePanel = new FixedWidthPanel();
    private GbPanelWrapper panel = new GbPanelWrapper((Container)this.sourcePanel);
    private GbPanel buttons = new GbPanel();
    private JButton bok;
    private JCheckBox rememberMeBox;
    private TechCredentials defaultCredentials;
    private int buffer = 20;
    private TechCredentials loadedCredentials;
    private boolean failedPreviousLogin;
    private final String rejectionReason;
    private TechCredentials credentials = null;
    private static File TECH_SETTINGS_FILE;
    private static final String TECH_USERNAME = "TECH_USERNAME";
    private static final String TECH_PASSWORD = "TECH_PASSWORD";
    private static final String TECH_GROUP = "TECH_GROUP";

    public boolean showDecoration() {
        return false;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        TechCredentials creds = new TechCredentials();
        creds.setUsername(OemBranding.OEM_ADMIN_USERNAME);
        TechUiLoginGlassDialog dialog = new TechUiLoginGlassDialog((RootPaneContainer)frame, creds, false, false, null);
        System.out.println(dialog.credentials);
        dialog = new TechUiLoginGlassDialog((RootPaneContainer)frame, null, false, true, "This is a short reason");
        System.out.println(dialog.credentials);
        dialog = new TechUiLoginGlassDialog((RootPaneContainer)frame, null, false, false, null);
        System.out.println(dialog.credentials);
        dialog = new TechUiLoginGlassDialog((RootPaneContainer)frame, null, false, true, "This is a short reason, this is a short reason, this is a short reason, danger! This is a short reason, this is a short reason, this is a short reason, danger!");
        System.out.println(dialog.credentials);
        creds.setPassword("WOOT");
        dialog = new TechUiLoginGlassDialog((RootPaneContainer)frame, creds, false, false, null);
        System.out.println(dialog.credentials);
    }

    public TechUiLoginGlassDialog(RootPaneContainer frame, TechCredentials defaultCredentials, boolean autoLogin, boolean failedPreviousLogin, String rejectionReason) {
        this(frame, defaultCredentials, autoLogin, failedPreviousLogin, rejectionReason, false);
    }

    public TechUiLoginGlassDialog(RootPaneContainer frame, TechCredentials defaultCredentials, boolean autoLogin, boolean failedPreviousLogin, String rejectionReason, boolean isForTestLoginPurposes) {
        super(frame, TechUiLoginGlassDialog.getDialogWidth(), TechUiLoginGlassDialog.getHeight(failedPreviousLogin, rejectionReason), true, true, false);
        if (rejectionReason != null && rejectionReason.length() == 0) {
            rejectionReason = null;
        }
        this.defaultCredentials = defaultCredentials;
        this.failedPreviousLogin = failedPreviousLogin;
        this.rejectionReason = rejectionReason;
        this.setModal(true);
        this.initUI(isForTestLoginPurposes);
        this.initFocus();
        if (defaultCredentials != null && defaultCredentials.isValid() && autoLogin) {
            this.credentials = (TechCredentials)defaultCredentials.clone();
            System.out.println("[TechUiLoginDialog] Auto logging in (" + this.credentials + ")...");
            return;
        }
        if (this.loadedCredentials != null && this.loadedCredentials.isValid() && autoLogin) {
            this.credentials = (TechCredentials)this.loadedCredentials.clone();
            return;
        }
        this.src_rootPane.getContentPane().setBackground(SHStyle.PANEL_BACKGROUND_LIGHT);
        this.setVisible(true);
    }

    private static int getDialogWidth() {
        return (int)(320.0 * SimpleHelpLookAndFeel.getScalingFactor());
    }

    private static int getHeight(boolean failedPreviousLogin, String reason) {
        JLabel titleImage = TechUiLoginGlassDialog.getScaledImageLabel(SimpleHelpLookAndFeel.scale((int)300), SimpleHelpLookAndFeel.scale((int)300));
        double extra = 20.0 * SimpleHelpLookAndFeel.getScalingFactor();
        if (failedPreviousLogin) {
            extra = reason == null ? (extra += 20.0 * SimpleHelpLookAndFeel.getScalingFactor()) : (extra += (double)TechUiLoginGlassDialog.getErrorLabel((String)reason).getPreferredSize().height);
        }
        extra += 180.0 * SimpleHelpLookAndFeel.getScalingFactor();
        return (int)(extra += (double)titleImage.getHeight());
    }

    private void initFocus() {
        this.loadedCredentials = TechUiLoginGlassDialog.loadCredentialsFromDisk();
        if (this.defaultCredentials == null || !this.defaultCredentials.hasUsername()) {
            String defaultUsername;
            if (this.defaultCredentials == null) {
                this.defaultCredentials = new TechCredentials();
            }
            if ((defaultUsername = Language.get("DO_NOT_TRANSLATE_DEFAULT_USERNAME")).length() > 0) {
                this.defaultCredentials.setUsername(defaultUsername);
            } else {
                this.defaultCredentials.setUsername("IGNORE");
            }
            if (this.defaultCredentials.hasUsername() && this.loadedCredentials != null) {
                this.defaultCredentials.setUsername(this.loadedCredentials.getUsername());
            }
        }
        this.loginField.setExampleValue(Language.get("SERVER_USERNAME"));
        this.passwordField.setExampleValue(Language.get("SERVER_PASSWORD"));
        this.loginField.setDefaultValue(this.defaultCredentials.getUsername());
        if (this.defaultCredentials.hasPassword()) {
            this.passwordField.setDefaultValue(this.defaultCredentials.getPassword());
        }
        if (!this.defaultCredentials.hasUsername()) {
            this.setFocusComponent(this.loginField.getComponent());
        } else if (!this.defaultCredentials.hasPassword()) {
            this.setFocusComponent(this.passwordField.getComponent());
            ((MessagePasswordTextField)this.passwordField.getComponent()).imitateHasFocus();
        } else {
            this.setFocusComponent(this.bok);
        }
    }

    public void setFocusComponent(JComponent focusComponent) {
        this.focusComponent = focusComponent;
        focusComponent.addAncestorListener(new RequestFocusListener());
    }

    private static TechCredentials loadCredentialsFromDisk() {
        try {
            File file = TECH_SETTINGS_FILE;
            if (!file.exists()) {
                return null;
            }
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
            byte[] encryptedData = StreamUtils.readAll(bin);
            Blowfish bfish = new Blowfish();
            bfish.init("ljis$5$GSEF(TYKyrthkjirtg09345jkfEJHRgisergSV5ItW$%0vwt'4&$^&%AdaF@l2i2@EFSwKJKUIWNRIb44");
            byte[] decrypted = bfish.decryptSecure(encryptedData, 0, false);
            ByteArrayInputStream bis = new ByteArrayInputStream(decrypted);
            Properties p = new Properties();
            p.load(bis);
            TechCredentials c = new TechCredentials(p.getProperty(TECH_USERNAME), p.getProperty(TECH_PASSWORD), null);
            System.out.println("[TechUiLoginGlassDialog] Loaded existing user credentials for " + c.getUsername());
            return c;
        }
        catch (Throwable t) {
            System.out.println("[TechUiLoginGlassDialog] Could not load technician username.");
            t.printStackTrace();
            return null;
        }
    }

    public static void forgetCredentials() {
        File file = TECH_SETTINGS_FILE;
        if (file.exists()) {
            file.delete();
        }
    }

    private static void saveCredentialsToDisk(String username, String password) {
        try {
            Properties p = new Properties();
            if (username != null) {
                p.setProperty(TECH_USERNAME, username);
            }
            if (password != null) {
                p.setProperty(TECH_PASSWORD, password);
            }
            ByteArrayOutputStream byout = new ByteArrayOutputStream();
            p.store(byout, "");
            byte[] decrypted = byout.toByteArray();
            Blowfish bfish = new Blowfish();
            bfish.init("ljis$5$GSEF(TYKyrthkjirtg09345jkfEJHRgisergSV5ItW$%0vwt'4&$^&%AdaF@l2i2@EFSwKJKUIWNRIb44");
            byte[] encrypted = bfish.encryptSecure(decrypted, 0, decrypted.length, false);
            File file = TECH_SETTINGS_FILE;
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(file));
            bout.write(encrypted);
            bout.close();
        }
        catch (Throwable t) {
            System.out.println("[TechUiLoginGlassDialog] Could not save technician username.");
            t.printStackTrace();
        }
    }

    private static JLabel getScaledImageLabel(int maxWidth, int maxHeight) {
        Icon logo = ClientBranding.get().getFullLogo(true);
        if (logo == null) {
            return new JLabel();
        }
        if (logo instanceof ImageIcon) {
            Dimension d = new Dimension(logo.getIconWidth(), logo.getIconHeight());
            ImageHelper.scaleDimensionToFitInside((Dimension)d, (int)maxWidth, (int)maxHeight);
            ScaledImageLabel titleImage = new ScaledImageLabel((ImageIcon)logo);
            SwingUtil.setSize((JComponent)titleImage, (Dimension)d);
            return titleImage;
        }
        Icon icon = ImageLoader.getImageIcon((String)Icons.getLogoOfHeight(38, 20));
        JLabel label = new JLabel(icon);
        Dimension d = new Dimension(logo.getIconWidth(), logo.getIconHeight() + SimpleHelpLookAndFeel.scale((int)10));
        SwingUtil.setSize((JComponent)label, (Dimension)d);
        return label;
    }

    private void initUI(boolean isForTestLoginPurposes) {
        JLabel titleImage = TechUiLoginGlassDialog.getScaledImageLabel(SimpleHelpLookAndFeel.scale((int)300), SimpleHelpLookAndFeel.scale((int)300));
        this.loginField = new TextField(null, null);
        this.passwordField = new TextField(null, null, 7);
        this.rememberMeBox = new JCheckBox(Language.get("KEEP_LOGGED_IN"));
        this.loginField.getComponent().addKeyListener(this);
        this.passwordField.getComponent().addKeyListener(this);
        this.bok = !OEMSwitches.DARK_THEME ? new JButton(Language.get("LOGIN"), ImageLoader.getImageIcon((String)"images/svg/arrows/right-moving.svg,16")) : new JButton(Language.get("LOGIN"), ImageLoader.getImageIconLighter((String)"images/svg/arrows/right-moving.svg,16"));
        if (isForTestLoginPurposes) {
            this.bok.setText("LOGIN_TEST");
        }
        SHButtonUI.makeButtonBlue((JButton)this.bok);
        this.buttons.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)this.buffer, (int)this.buffer, (int)this.buffer));
        int X = 0;
        this.buttons.add((Component)this.bok, X++, 0, 1, 1, 1, 0, 13, 0);
        this.bok.addActionListener(this);
        int Y = 0;
        this.panel.add((Component)titleImage, 0, Y++, 1, 1, 1, 0, 11, 2, (Insets)new ScaledInsets(this.buffer / 2, this.buffer, 0, this.buffer));
        if (this.failedPreviousLogin) {
            JLabel errorLabel = TechUiLoginGlassDialog.getErrorLabel(this.rejectionReason);
            this.panel.add((Component)errorLabel, 0, Y++, 1, 1, 1, 0, 11, 2, (Insets)new ScaledInsets(0, this.buffer, 5, this.buffer));
        }
        this.panel.add((Component)this.loginField.getComponent(), 0, Y++, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(this.buffer / 2, this.buffer, 10, this.buffer));
        this.panel.add((Component)this.passwordField.getComponent(), 0, Y++, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(0, this.buffer, 5, this.buffer));
        if (!isForTestLoginPurposes) {
            this.panel.add((Component)this.rememberMeBox, 0, Y++, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(0, this.buffer, 0, this.buffer));
        }
        this.panel.add((Component)this.buttons, 0, Y++, 1, 1, 1, 0, 15, 2);
        this.getContentPane().add(this.sourcePanel);
        this.setTitle(ClientBranding.get().getApplicationName(false) + " " + Language.get("SERVER_LOGIN"));
    }

    private static JLabel getErrorLabel(String rejectionReason) {
        FixedWidthLabel errorLabel = new FixedWidthLabel();
        errorLabel.setPreferredWidth(SimpleHelpLookAndFeel.scale((int)240));
        if (rejectionReason == null) {
            errorLabel.setText("<html><center>" + Language.get("QUEUE_PASSWORD_INCORRECT_TITLE"));
        } else {
            errorLabel.setText("<html><center>" + rejectionReason);
        }
        errorLabel.setHorizontalAlignment(0);
        errorLabel.setForeground(SHStyle.ERROR_TEXT_COLOR);
        return errorLabel;
    }

    public TechCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    private void actionPerformed(Object o) {
        if (o != null && o == this.bok) {
            this.credentials = new TechCredentials();
            this.credentials.setPassword(this.passwordField.getTextFieldValue());
            this.credentials.setUsername(this.loginField.getTextFieldValue().trim());
            if (this.rememberMeBox.isSelected()) {
                TechUiLoginGlassDialog.saveCredentialsToDisk(this.credentials.getUsername(), this.credentials.getPassword());
            } else {
                TechUiLoginGlassDialog.saveCredentialsToDisk(this.credentials.getUsername(), null);
            }
        } else {
            this.credentials = null;
        }
        this.setVisible(false);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.actionPerformed(this.bok);
        } else if (e.getKeyCode() == 27) {
            this.actionPerformed((Object)null);
        } else if (e.getSource() == this.loginField.getComponent()) {
            // empty if block
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    static {
        String updateURL = JWSystem.getUpdateURL();
        while (updateURL.endsWith("/")) {
            updateURL = updateURL.substring(0, updateURL.length() - 1);
        }
        TECH_SETTINGS_FILE = new File(JWSystem.getAllAppVersionsSharedFolder(), "technician." + Normaliser.safeWithoutNormalising((String)updateURL) + ".settings");
    }
}

