/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.shelp.common.Language;
import com.aem.shelp.util.RequestFocusListener;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jwrapper.jwutils.JWSystem;
import utils.swing.JFixedWidthPasswordField;
import utils.swing.SafeDialogIcon;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;

public abstract class MatchedVersionServerUnavailableDialog
extends JDialog
implements ActionListener,
KeyListener {
    private JTextField connectField = new JTextField();
    private JTextField proxyHostnameField = new JTextField();
    private JTextField proxyPortField = (JTextField)new TextField(null, null, 1).getComponent();
    private JTextField proxyUsernameField = new JTextField();
    private JTextField proxyPasswordField = new JFixedWidthPasswordField();
    private JButton okButton;
    private boolean isExit = true;

    public abstract String getUpdateURLSuffix();

    private static String getTrimmedUpdateURL() {
        int doubleSlash;
        String updateURL = JWSystem.getUpdateURL();
        int nextSlash = updateURL.indexOf(47, (doubleSlash = updateURL.indexOf("://")) + 3);
        if (nextSlash != -1) {
            updateURL = updateURL.substring(0, nextSlash);
        }
        return updateURL;
    }

    public MatchedVersionServerUnavailableDialog() {
        super((Frame)null);
        this.setSize(SimpleHelpLookAndFeel.scale((int)400), SimpleHelpLookAndFeel.scale((int)140) + SimpleHelpFrame.EMPTY_WINDOW_DECORATIONS_HEIGHT);
        this.setModal(true);
        this.connectField.setText(MatchedVersionServerUnavailableDialog.getTrimmedUpdateURL());
        this.connectField.select(0, this.connectField.getText().length());
        JPanel mainPanel = new JPanel();
        this.initGraphics(mainPanel);
        JPanel proxyPanel = new JPanel();
        this.initProxy(proxyPanel);
        JTabbedPane pane = new JTabbedPane();
        pane.addTab(Language.get("UPDATE_URL_DIALOG_CONNECTION"), mainPanel);
        pane.addTab(Language.get("PROXY"), proxyPanel);
        this.getContentPane().add(pane);
        SafeDialogIcon.setDialogIcon((JDialog)this, ImageLoader.getAsImage((String)"images/svg/dialogs/warning.svg,16"));
        this.setTitle(Language.get("UPDATE_URL_DIALOG_TITLE"));
        this.connectField.addAncestorListener(new RequestFocusListener());
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.addKeyListener(this);
        this.setVisible(true);
    }

    private void updateEnabled() {
        if (this.connectField.getText().length() > 0) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private void initGraphics(JPanel mainPanel) {
        GridBagLayout gbl = new GridBagLayout();
        mainPanel.setLayout(gbl);
        this.okButton = new JButton(Language.get("CONNECT"));
        SHButtonUI.makeButtonBlue((JButton)this.okButton);
        this.okButton.addActionListener(this);
        this.connectField.addKeyListener(this);
        JLabel exampleLabel = new JLabel(Language.get("EXAMPLE") + ": 192.168.2.1 / 8888, www.domain.com:8888");
        JWrapLabel description2 = new JWrapLabel("<html>" + Language.get("UNABLE_TO_CONNECT") + "</html>");
        description2.setForeground(SHStyle.ERROR_TEXT_COLOR);
        description2.setHorizontalAlignment(2);
        SwingUtil.setHeight((JComponent)this.connectField, (int)this.okButton.getPreferredSize().height);
        SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.okButton);
        gbl.setConstraints((Component)description2, new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(10, 15, 0, 10), 0, 0));
        gbl.setConstraints(this.connectField, new GridBagConstraints(1, 1, 1, 1, 100.0, 1.0, 17, 2, (Insets)new ScaledInsets(0, 15, 0, 0), 0, 0));
        gbl.setConstraints(this.okButton, new GridBagConstraints(2, 1, 2, 1, 1.0, 1.0, 10, 0, (Insets)new ScaledInsets(0, 0, 0, 15), 0, 0));
        gbl.setConstraints(exampleLabel, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 18, 2, (Insets)new ScaledInsets(0, 15, 0, 0), 0, 0));
        Font oldFont = exampleLabel.getFont();
        float size = oldFont.getSize();
        Font newFont = oldFont.deriveFont(size -= 2.0f);
        exampleLabel.setFont(newFont);
        exampleLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        mainPanel.add(this.connectField);
        mainPanel.add((Component)description2);
        mainPanel.add(this.okButton);
        mainPanel.add(exampleLabel);
        this.updateEnabled();
    }

    private void initProxy(JPanel proxyPanel) {
        GridBagLayout gbl = new GridBagLayout();
        proxyPanel.setLayout(gbl);
        JLabel hostLabel = new JLabel(Language.get("PROXY"));
        JLabel portLabel = new JLabel(Language.get("PORT"));
        JLabel username = new JLabel(Language.get("USERNAME"));
        JLabel password = new JLabel(Language.get("PASSWORD"));
        SwingUtil.setWidth((JComponent)this.proxyPortField, (int)SimpleHelpLookAndFeel.scale((int)50));
        SwingUtil.setWidth((JComponent)this.proxyUsernameField, (int)SimpleHelpLookAndFeel.scale((int)150));
        SwingUtil.setSize((JComponent)this.proxyPasswordField, (int)SimpleHelpLookAndFeel.scale((int)150), (int)this.proxyUsernameField.getPreferredSize().height);
        gbl.setConstraints(hostLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(10, 10, 0, 5), 0, 0));
        gbl.setConstraints(this.proxyHostnameField, new GridBagConstraints(1, 0, 1, 1, 100.0, 1.0, 17, 2, (Insets)new ScaledInsets(10, 0, 0, 10), 0, 0));
        gbl.setConstraints(portLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(10, 0, 0, 5), 0, 0));
        gbl.setConstraints(this.proxyPortField, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(10, 0, 0, 10), 0, 0));
        gbl.setConstraints(username, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 10, 0, 5), 0, 0));
        gbl.setConstraints(this.proxyUsernameField, new GridBagConstraints(1, 1, 1, 1, 100.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 10), 0, 0));
        gbl.setConstraints(password, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 10, 0, 5), 0, 0));
        gbl.setConstraints(this.proxyPasswordField, new GridBagConstraints(1, 2, 1, 1, 100.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 10), 0, 0));
        proxyPanel.add(hostLabel);
        proxyPanel.add(username);
        proxyPanel.add(password);
        proxyPanel.add(portLabel);
        proxyPanel.add(this.proxyHostnameField);
        proxyPanel.add(this.proxyPortField);
        proxyPanel.add(this.proxyUsernameField);
        proxyPanel.add(this.proxyPasswordField);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.isExit = false;
        try {
            String url = this.connectField.getText();
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            url = url + "/" + this.getUpdateURLSuffix();
            JWSystem.overrideSourceLauncherUpdateURL((URL)new URL(url));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String proxyHost = this.proxyHostnameField.getText();
        String proxyPort = this.proxyPortField.getText();
        String proxyUsername = this.proxyUsernameField.getText();
        String proxyPassword = this.proxyPasswordField.getText();
        if (proxyHost != null && proxyHost.length() > 0) {
            int proxyPortInt = 80;
            try {
                proxyPortInt = Integer.parseInt(proxyPort);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                InetSocketAddress address = new InetSocketAddress(proxyHost, proxyPortInt);
                Proxy httpProxy = new Proxy(Proxy.Type.HTTP, address);
                if (proxyUsername != null && proxyUsername.length() > 0) {
                    JWSystem.addAppSpecificProxy((Proxy)httpProxy, (String)proxyUsername, (String)proxyPassword);
                } else {
                    JWSystem.addAppSpecificProxy((Proxy)httpProxy);
                }
            }
            catch (Throwable t) {
                System.out.println("[MatchedVersionServerUnavailableDialog] Unable to set app specific proxy.");
                t.printStackTrace();
            }
        }
        this.setVisible(false);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateEnabled();
        if (e.getKeyCode() == 10) {
            this.actionPerformed(null);
        } else if (e.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public boolean isExit() {
        return this.isExit;
    }
}

