/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.CentralDebugging;
import com.aem.ServerManagement;
import com.aem.sdesktop.ClientBranding;
import com.aem.sdesktop.util.MainWindow;
import com.aem.shelp.common.CommonHelpUtil;
import com.aem.shelp.common.MatchedVersionServerUnavailableDialog;
import com.aem.shelp.common.SHParameters;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.util.FixedByteBuffer;
import com.aem.shelp.util.PleaseWaitDialog;
import com.aem.shelp.util.UIUtils;
import com.aem.utils.entropy.TimedEntropyWrap;
import com.jw.SHJWUtil;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.updater.JWLaunchProperties;
import utils.ostools.OS;
import utils.progtools.net.URLParser;
import utils.swing.customlaf.SimpleHelpFrame;

public abstract class CommonStandalone {
    protected JFrame mainFrame;
    protected String connectHostname;
    protected int connectPort;
    protected StandaloneHelpUtil helpUtil;
    private PleaseWaitDialog pleaseWaitDialog;

    public CommonStandalone(String standaloneIdentifier) {
        try {
            CentralDebugging.setOptionalDebugDir(JWSystem.getAllAppVersionsSharedFolder());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            CentralDebugging.loadDebugSettings(standaloneIdentifier, true);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            String id;
            if (OS.isWindowsVistaOrAbove() && (id = JWLaunchProperties.getProperty((String)"windows_app_id")) != null && id.length() > 0) {
                System.out.println("[CommonStandalone] Setting app ID to " + id);
                JWWindowsOS windowsOS = new JWWindowsOS();
                windowsOS.setWindowsAppID(id);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        TimedEntropyWrap.startup();
        FixedByteBuffer.injectIntoStdout();
        SimpleHelpFrame.setLnf();
        this.processParameters();
    }

    protected static boolean isSilentInstall(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("silent") && !arg.equalsIgnoreCase("/S")) continue;
            return true;
        }
        return false;
    }

    protected String getTitle() {
        return null;
    }

    protected int getDesiredWidth(int defaultWidth) {
        String desiredWidth = JWSystem.getAppLaunchProperty((String)"width");
        if (desiredWidth != null) {
            try {
                return Integer.parseInt(desiredWidth);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultWidth;
    }

    protected int getDesiredHeight(int defaultHeight) {
        String desiredHeight = JWSystem.getAppLaunchProperty((String)"height");
        if (desiredHeight != null) {
            try {
                return Integer.parseInt(desiredHeight);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultHeight;
    }

    public void initWithoutFrame() {
        this.initFrame();
    }

    public JFrame initFrame() {
        if (ServerManagement.isServerJVM()) {
            System.out.println("[CommonStandalone] Initing without frame (mobile customer)");
        } else {
            this.mainFrame = new SimpleHelpFrame(){

                public void setSize(int w, int h) {
                    super.setSize(w, h);
                    this.setLocationRelativeTo(null);
                }

                public void setSize(Dimension d) {
                    super.setSize(d);
                    this.setLocationRelativeTo(null);
                }
            };
            this.mainFrame.setDefaultCloseOperation(0);
            this.mainFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    boolean canClose = CommonStandalone.this.canClose();
                    if (!canClose) {
                        return;
                    }
                    System.out.println("[CommonStandalone] Detected closing. Cleaning up.");
                    CommonStandalone.this.mainFrame.setVisible(false);
                    try {
                        System.out.println("[CommonStandalone] Disconnecting.");
                        CommonStandalone.this.helpUtil.controller.disconnect(true);
                    }
                    finally {
                        System.out.println("[CommonStandalone] Exiting.");
                        System.exit(0);
                    }
                }
            });
            MainWindow.setImageListUsingReflection(this.mainFrame);
        }
        this.helpUtil = new StandaloneHelpUtil(this.mainFrame);
        return this.mainFrame;
    }

    protected boolean canClose() {
        return true;
    }

    protected boolean tryLoadTranslations() {
        try {
            System.out.println("[CommonStandalone] Trying to load translations...");
            this.helpUtil.loadTranslations();
            this.mainFrame.setTitle(this.getTitle());
            return true;
        }
        catch (Exception ex) {
            System.out.println("[CommonStandalone] Unable to load translations: " + ex.getMessage() + "(" + ex.getClass().getName() + ")");
            return false;
        }
    }

    private void loadConnectionSettingsFromJW() {
        String updateURL = JWSystem.getAppLaunchProperty((String)"update_url");
        this.getServerUrlFromUpdateUrl(updateURL);
    }

    protected abstract MatchedVersionServerUnavailableDialog showUnavailableDialog();

    protected void establishConnectionToServer(boolean launchMouseMover) {
        System.out.println("[CommonStandalone] Trying to connect to server...");
        this.loadConnectionSettingsFromJW();
        boolean success = this.tryLoadTranslations();
        while (!success) {
            MatchedVersionServerUnavailableDialog dialog = this.showUnavailableDialog();
            if (dialog.isExit()) {
                System.exit(1);
            }
            this.loadConnectionSettingsFromJW();
            success = this.tryLoadTranslations();
        }
        this.translationsLoaded();
        try {
            ClientBranding.startBrandingDownload(SHJWUtil.getUpdateURLProtocol() + "://" + this.connectHostname + ":" + this.connectPort + "/");
        }
        catch (Throwable t) {
            System.out.println("[CommonHelp] Unable to load branding from server " + t.getMessage());
        }
        this.helpUtil.loadNativeLibraries(launchMouseMover);
        UIUtils.initJOptionPaneTranslations();
    }

    protected void translationsLoaded() {
    }

    protected void processParameters() {
        System.out.println("[CommonStandalone] Printing out all parameters");
        for (int i = 0; i < SHParameters.getAllParameters().length; ++i) {
            String propertyKey = SHParameters.getAllParameters()[i];
            String propertyResult = JWSystem.getAppLaunchProperty((String)propertyKey);
            if (propertyResult == null || propertyResult.length() <= 0) continue;
            if (propertyKey != null && propertyKey.toLowerCase().contains("password")) {
                System.out.println("[CommonStandalone] Parameter " + propertyKey + " = ********");
                continue;
            }
            System.out.println("[CommonStandalone] Parameter " + propertyKey + " = " + propertyResult);
        }
        String updateURL = JWSystem.getAppLaunchProperty((String)"update_url");
        try {
            this.getServerUrlFromUpdateUrl(updateURL);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("[CommonStandalone] Startup Hostname=" + this.connectHostname + " Port=" + this.connectPort);
    }

    private void getServerUrlFromUpdateUrl(String updateURL) {
        if (updateURL.contains("JWLaunchProperties not set up")) {
            this.connectHostname = updateURL;
            this.connectPort = 8008;
            return;
        }
        URLParser parser = new URLParser(updateURL);
        this.connectHostname = parser.getHostname();
        this.connectPort = parser.getPort(true);
    }

    private static boolean isIP(String[] ip) {
        for (int i = 0; i < 4; ++i) {
            try {
                int ipNumber = Integer.parseInt(ip[i].trim());
                if (ipNumber <= 256 && ipNumber >= 0) continue;
                return false;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    public static String[] parseCrazyURL(String crazyURL) {
        boolean isIP;
        int bracketIndex;
        if (crazyURL == null || crazyURL.trim().length() == 0) {
            return null;
        }
        if (crazyURL.startsWith("-")) {
            crazyURL = crazyURL.substring(1);
        }
        if ((bracketIndex = crazyURL.indexOf(40)) != -1) {
            crazyURL = crazyURL.substring(0, bracketIndex);
            crazyURL = crazyURL.trim();
        }
        if ((bracketIndex = crazyURL.indexOf(91)) != -1) {
            crazyURL = crazyURL.substring(0, bracketIndex);
            crazyURL = crazyURL.trim();
        }
        crazyURL = crazyURL.replace(',', '.');
        crazyURL = crazyURL.replace(';', ':');
        crazyURL = crazyURL.replace(':', '/');
        crazyURL = crazyURL.replace('.', '/');
        while (crazyURL.startsWith("/")) {
            crazyURL = crazyURL.substring(1);
        }
        while (crazyURL.endsWith("/")) {
            crazyURL = crazyURL.substring(0, crazyURL.length() - 1);
        }
        String[] tmp = crazyURL.split("\\/");
        String host = "";
        String port = "";
        if (tmp.length == 4 && (isIP = CommonStandalone.isIP(tmp))) {
            return new String[]{tmp[0] + "." + tmp[1] + "." + tmp[2] + "." + tmp[3], "80"};
        }
        String possiblePort = tmp[tmp.length - 1].trim();
        boolean defaultPort = false;
        try {
            Integer.parseInt(possiblePort);
            defaultPort = false;
        }
        catch (Exception ex) {
            defaultPort = true;
        }
        if (defaultPort) {
            String[] tmp2 = new String[tmp.length + 1];
            System.arraycopy(tmp, 0, tmp2, 0, tmp.length);
            tmp2[tmp.length] = "80";
            tmp = tmp2;
        }
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = tmp[i].trim();
            if (i == 0) {
                host = tmp[i];
                continue;
            }
            if (i < tmp.length - 1) {
                host = host + "." + tmp[i];
                continue;
            }
            port = tmp[i];
        }
        return new String[]{host, port};
    }

    public class StandaloneHelpUtil
    extends CommonHelpUtil {
        public StandaloneHelpUtil(RootPaneContainer rpc) {
            super(rpc, false);
        }

        @Override
        public String getHost() {
            if (CommonStandalone.this.connectHostname == null) {
                return null;
            }
            return CommonStandalone.this.connectHostname;
        }

        @Override
        public int getPort() {
            if (CommonStandalone.this.connectPort <= 0) {
                return -1;
            }
            return CommonStandalone.this.connectPort;
        }

        @Override
        public String getCodeBase() {
            if (this.getHost() == null || this.getPort() == -1) {
                return null;
            }
            return SHJWUtil.getUpdateURLProtocol() + "://" + this.getHost() + ":" + this.getPort() + "/";
        }

        @Override
        public String getConnectURL() {
            if (this.getHost() == null || this.getPort() == -1) {
                return null;
            }
            return this.getHost() + ":" + this.getPort();
        }

        @Override
        public String getDemoName() {
            return null;
        }

        @Override
        public Customer getDemoCustomerType() {
            return null;
        }

        public boolean hasStarted() {
            return this.started;
        }
    }
}

