/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.SafeResourceBundle;
import com.aem.ServerManagement;
import com.aem.sdesktop.util.Version;
import com.aem.shelp.images.Icons;
import com.aem.shelp.licence.OemBranding;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import utils.files.FileUtil;
import utils.progtools.net.URLParser;
import utils.string.Normaliser;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageHelper;
import utils.swing.images.ImageLoader;
import utils.swing.images.PNGChunkRemover;

public class AbstractBranding {
    public static final String HOSTED_RESALE_BRANDING = "HOSTED_RESALE_BRANDING";
    protected LoadedImage splashImage = null;
    protected ImageIcon fullLogo = null;
    protected ImageIcon shLogo16 = null;
    protected ImageIcon shLogo32 = null;
    protected ImageIcon shLogo48 = null;
    protected ImageIcon shLogo256 = null;
    protected ImageIcon sgLogo16 = null;
    protected ImageIcon sgLogo32 = null;
    protected ImageIcon sgLogo48 = null;
    protected ImageIcon sgLogo256 = null;
    protected ImageIcon systemTrayBlue16 = null;
    protected ImageIcon systemTrayRed16 = null;
    protected ImageIcon systemTrayBlue36 = null;
    protected ImageIcon systemTrayRed36 = null;
    protected String technicianApplicationNameWithVersion = OemBranding.OEM_IS_SH ? OemBranding.OEM_APPLICATION_NAME + " " + Version.getExtendedUserFacing() : OemBranding.OEM_APPLICATION_NAME + " " + Version.getExtendedUserFacing();
    protected String technicianApplicationName = OemBranding.OEM_IS_SH ? OemBranding.OEM_APPLICATION_NAME : OemBranding.OEM_APPLICATION_NAME;
    protected String customerApplicationNameWithVersion = OemBranding.OEM_IS_SH ? OemBranding.OEM_APPLICATION_NAME + " " + Version.getExtendedUserFacing() : OemBranding.OEM_APPLICATION_NAME + " " + Version.getExtendedUserFacing();
    protected String customerApplicationName = OemBranding.OEM_IS_SH ? OemBranding.OEM_APPLICATION_NAME : OemBranding.OEM_APPLICATION_NAME;
    protected String supportExeName = null;
    protected boolean supportExeKeepOS = true;
    protected boolean supportExeKeepType = true;
    protected Color remoteSupportHeaderColor;
    protected long lastModified = 0L;

    public LoadedImage createScaledVersionOf(LoadedImage image) {
        if (image.bufferedImage == null) {
            return null;
        }
        LoadedImage result = new LoadedImage();
        result.bufferedImage = ImageHelper.scaleDownToFitInside((BufferedImage)image.bufferedImage, (int)SimpleHelpLookAndFeel.scale((int)300), (int)SimpleHelpLookAndFeel.scale((int)200));
        if (result.bufferedImage == null) {
            return null;
        }
        if (ServerManagement.isServerJVM()) {
            result.rawPNGData = AbstractBranding.getImageBytes(result.bufferedImage);
            if (result.rawPNGData == null) {
                return null;
            }
            int w = result.bufferedImage.getWidth();
            int h = result.bufferedImage.getHeight();
            while (result.rawPNGData.length > 100000 && w >= 50 && h >= 50) {
                result.bufferedImage = ImageHelper.scaleDownToFitInside((BufferedImage)image.bufferedImage, (int)(w /= 2), (int)(h /= 2));
                result.rawPNGData = AbstractBranding.getImageBytes(result.bufferedImage);
            }
        }
        return result;
    }

    protected static byte[] getImageBytes(BufferedImage image) {
        if (image == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", bout);
            return bout.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BufferedImage getSplashImage() {
        return this.splashImage.bufferedImage;
    }

    public String getRemoteSupportDownloadName() {
        return this.supportExeName;
    }

    public boolean shouldRemoteSupportDownloadKeepOS() {
        return this.supportExeKeepOS;
    }

    public boolean shouldRemoteSupportDownloadKeepType() {
        return this.supportExeKeepType;
    }

    public Color getRemoteSupportHeaderColor() {
        return this.remoteSupportHeaderColor;
    }

    public String getApplicationNameWithVersion(boolean customerFacing) {
        if (customerFacing) {
            if (this.customerApplicationNameWithVersion.contains("SimpleHelp")) {
                return this.customerApplicationNameWithVersion;
            }
            return this.customerApplicationName;
        }
        if (this.technicianApplicationNameWithVersion.contains("SimpleHelp")) {
            return this.technicianApplicationNameWithVersion;
        }
        return this.technicianApplicationName;
    }

    public String getApplicationName(boolean customerFacing) {
        if (customerFacing) {
            return this.customerApplicationName;
        }
        return this.technicianApplicationName;
    }

    public String getApplicationNameWithVersionSH(boolean customerFacing) {
        return this.getApplicationNameWithVersion(customerFacing);
    }

    public String getApplicationNameWithSH(boolean customerFacing) {
        return this.getApplicationName(customerFacing);
    }

    public Icon getFullLogo(boolean sh) {
        if (this.fullLogo != null) {
            return this.fullLogo;
        }
        return ImageLoader.getImageIcon((String)Icons.SH_LOGO_LARGE);
    }

    public ImageIcon getLogo32(boolean sh) {
        return AbstractBranding.returnWorkingImage(sh, this.shLogo32, "images/svg/logos/simplehelp-blue.svg,32", this.shLogo32, "images/svg/logos/simplehelp-blue.svg,32");
    }

    public ImageIcon getLogo16(boolean sh) {
        return AbstractBranding.returnWorkingImage(sh, this.shLogo16, "images/svg/logos/simplehelp-blue.svg,16", this.shLogo16, "images/svg/logos/simplehelp-blue.svg,16");
    }

    public ImageIcon getLogo48(boolean sh) {
        return AbstractBranding.returnWorkingImage(sh, this.shLogo48, "images/svg/logos/simplehelp-blue.svg,48", this.shLogo48, "images/svg/logos/simplehelp-blue.svg,48");
    }

    public ImageIcon getLogo256(boolean sh) {
        return AbstractBranding.returnWorkingImage(sh, this.shLogo256, "images/svg/logos/simplehelp-blue.svg,256", this.sgLogo256, "images/svg/logos/simplehelp-blue.svg,256");
    }

    private static ImageIcon returnWorkingImage(boolean first, ImageIcon firstCached, String firstKey, ImageIcon secondCached, String secondKey) {
        if (first) {
            if (firstCached != null) {
                return firstCached;
            }
            return new ImageIcon(ImageLoader.getAsImage((String)firstKey));
        }
        if (secondCached != null) {
            return secondCached;
        }
        return new ImageIcon(ImageLoader.getAsImage((String)secondKey));
    }

    public long getMostRecentLoadedImageLastModified() {
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedImage loadImage(File imageFile) {
        try {
            if (!imageFile.exists() || imageFile.length() == 0L) {
                return null;
            }
            LoadedImage result = new LoadedImage();
            result.rawPNGData = FileUtil.readFile((File)imageFile);
            if (ServerManagement.isServerJVM()) {
                File originalFileCopy = new File(imageFile.getParentFile(), imageFile.getName() + ".original");
                FileUtil.writeFile((File)originalFileCopy, (byte[])result.rawPNGData);
                File tmpFile = File.createTempFile(imageFile.getName(), "stripped");
                BufferedInputStream fin = new BufferedInputStream(new ByteArrayInputStream(result.rawPNGData));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpFile));
                try {
                    System.out.println("[Branding] Stripping PNG chunks from " + imageFile.getName());
                    PNGChunkRemover.remove(fin, out);
                }
                finally {
                    FileUtil.robustClose((InputStream)fin);
                    FileUtil.robustClose((OutputStream)out);
                }
                if (!tmpFile.renameTo(imageFile)) {
                    FileUtil.copy((File)tmpFile, (File)imageFile);
                    tmpFile.delete();
                }
            }
            this.updateLastModified(imageFile.lastModified());
            result.bufferedImage = ImageIO.read(new ByteArrayInputStream(result.rawPNGData));
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void updateLastModified(long lastModified) {
        this.lastModified = Math.max(lastModified, this.lastModified);
    }

    private LoadedImage loadImage(File parent, String path) {
        return this.loadImage(new File(parent, path));
    }

    private ImageIcon loadImageIcon(File imageFile) {
        try {
            LoadedImage image = this.loadImage(imageFile);
            if (image == null || image.bufferedImage == null) {
                return null;
            }
            return new ImageIcon(image.bufferedImage);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void loadBrandingFrom(File brandingFolder) {
        this.loadBrandingFrom(brandingFolder, 0L);
    }

    public void loadBrandingFrom(File brandingFolder, long otherLastModified) {
        block15: {
            this.lastModified = otherLastModified;
            this.fullLogo = this.loadImageIcon(new File(brandingFolder, "logo_full.png"));
            this.shLogo32 = this.loadImageIcon(new File(brandingFolder, "logo_blue_16.png"));
            this.shLogo32 = this.loadImageIcon(new File(brandingFolder, "logo_blue_32.png"));
            this.shLogo48 = this.loadImageIcon(new File(brandingFolder, "logo_blue_48.png"));
            this.shLogo256 = this.loadImageIcon(new File(brandingFolder, "logo_blue_256.png"));
            this.sgLogo16 = this.loadImageIcon(new File(brandingFolder, "logo_green_32.png"));
            this.sgLogo32 = this.loadImageIcon(new File(brandingFolder, "logo_green_32.png"));
            this.sgLogo48 = this.loadImageIcon(new File(brandingFolder, "logo_green_48.png"));
            this.sgLogo256 = this.loadImageIcon(new File(brandingFolder, "logo_green_256.png"));
            this.systemTrayBlue16 = this.loadImageIcon(new File(brandingFolder, "systemtray_blue_16.png"));
            this.systemTrayRed16 = this.loadImageIcon(new File(brandingFolder, "systemtray_red_16.png"));
            this.systemTrayBlue36 = this.loadImageIcon(new File(brandingFolder, "systemtray_blue_36.png"));
            this.systemTrayRed36 = this.loadImageIcon(new File(brandingFolder, "systemtray_red_36.png"));
            this.splashImage = this.loadImage(new File(brandingFolder, "applet_splash.png"));
            if (this.splashImage != null) {
                this.splashLoaded();
            }
            try {
                File properties = new File(brandingFolder, "branding.properties");
                if (!properties.exists()) break block15;
                Properties newProperties = new Properties();
                newProperties.load(new FileInputStream(properties));
                this.customerApplicationName = this.customerApplicationNameWithVersion = (String)newProperties.get("APPLICATION_NAME");
                if (this.customerApplicationNameWithVersion == null) {
                    this.customerApplicationNameWithVersion = "SimpleHelp " + Version.getExtendedUserFacing();
                    this.customerApplicationName = "SimpleHelp";
                } else if (this.customerApplicationNameWithVersion.equals("SimpleHelp")) {
                    this.customerApplicationNameWithVersion = "SimpleHelp " + Version.getExtendedUserFacing();
                }
                if (newProperties.getProperty(HOSTED_RESALE_BRANDING) != null) {
                    this.technicianApplicationNameWithVersion = this.customerApplicationNameWithVersion;
                    this.technicianApplicationName = this.customerApplicationName;
                }
                try {
                    this.remoteSupportHeaderColor = Color.WHITE;
                    this.remoteSupportHeaderColor = Color.decode((String)newProperties.get("COLOR_APP_HEADER"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.supportExeName = (String)newProperties.get("SUPPORT_EXE_NAME");
                if (this.supportExeName != null) {
                    this.supportExeName = this.supportExeName.trim();
                    this.supportExeName = this.supportExeName.length() == 0 ? null : new String(this.convertToValidCDName(this.supportExeName.toCharArray()));
                }
                try {
                    this.supportExeKeepOS = ((String)newProperties.get("SUPPORT_EXE_NAME_KEEP_OS")).equalsIgnoreCase("true");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.supportExeKeepType = ((String)newProperties.get("SUPPORT_EXE_NAME_KEEP_TYPE")).equalsIgnoreCase("true");
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.customerApplicationName != null && !this.customerApplicationName.equals("SimpleHelp")) {
            SafeResourceBundle.addReplaceString("SimpleHelp", this.customerApplicationName, new String[]{OemBranding.OEM_ADMIN_USERNAME});
        }
    }

    protected void splashLoaded() {
    }

    private char[] convertToValidCDName(char[] cs) {
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == ' ' || cs[i] == '_' || cs[i] >= '0' && cs[i] <= '9' || cs[i] >= 'A' && cs[i] <= 'Z' || cs[i] >= 'a' && cs[i] <= 'z') continue;
            cs[i] = 95;
        }
        return cs;
    }

    protected static long getMostRecentlyModifiedResource(File brandingFolder) {
        brandingFolder.mkdirs();
        File[] file = brandingFolder.listFiles();
        long lastModified = 0L;
        if (file != null) {
            for (File aFile : file) {
                if (!aFile.getName().toLowerCase().endsWith("png") && !aFile.getName().toLowerCase().endsWith("ico") && !aFile.getName().toLowerCase().endsWith("branding.properties")) continue;
                lastModified = Math.max(lastModified, aFile.lastModified());
            }
        }
        if (lastModified == 0L) {
            return Long.MIN_VALUE;
        }
        return lastModified;
    }

    protected static File getBrandingFolderForServer(File branding, String codebase) {
        if (codebase == null || codebase.length() == 0) {
            return branding;
        }
        codebase = codebase.toLowerCase();
        URLParser parser = new URLParser(codebase);
        String hostAndPort = parser.getHostname();
        int port = parser.getPort(false);
        if (port > 0) {
            hostAndPort = hostAndPort + ":" + port;
        }
        File result = new File(branding, Normaliser.safeWithoutNormalising((String)hostAndPort));
        result.mkdirs();
        return result;
    }

    protected class LoadedImage {
        public BufferedImage bufferedImage;
        public byte[] rawPNGData;

        protected LoadedImage() {
        }
    }
}

