/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.ui;

import com.aem.shelp.tech.access.AccessStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import utils.ostools.OS;
import utils.swing.SwingUtil;
import utils.swing.components.SHJTree;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.images.ImageLoader;
import utils.swing.simplelist.jtree.SimpleTreeModel;

public class SimpleMachineGroupList {
    private JPanel rootComponent = new JPanel(new GridLayout(1, 1));
    private JTree tree;
    public SimpleTreeModel<TreeItemWrapper> model = new SimpleTreeModel();
    private JScrollPane pane;
    private MachineGroupCellRenderer renderer;
    private ConnectListener listener = new ConnectListener();
    private ButtonClickListener buttonClickListener;
    private String buttonText;
    private long count = 0L;

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    public SimpleMachineGroupList(String[][] machineGroups, String[] machineNames, String[] machineIDs) {
        this(machineGroups, machineNames, machineIDs, null, null);
    }

    public SimpleMachineGroupList(String[][] machineGroups, String[] machineNames, String[] ids, String buttonText, ButtonClickListener buttonClickListener) {
        this.buttonClickListener = buttonClickListener;
        this.buttonText = buttonText;
        this.initUI();
        if (machineGroups != null) {
            this.setGroupsToShow(machineGroups, machineNames, ids);
        }
    }

    public SimpleMachineGroupList(String[][] machineGroups) {
        this(machineGroups, null, null);
    }

    public SimpleMachineGroupList() {
        this(null, null, null, null, null);
    }

    private void initUI() {
        this.tree = new SHJTree(this.model.getTreeModel(), AccessStyle.TREE_SELECTION_COLOR);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        if (this.buttonText != null) {
            this.tree.addMouseListener(this.listener);
            this.tree.addMouseMotionListener(this.listener);
        }
        this.tree.getSelectionModel().setSelectionMode(1);
        this.renderer = new MachineGroupCellRenderer(this.getMachineIcon(), this.getFolderIcon());
        this.tree.setCellRenderer(this.renderer);
        this.pane = new JScrollPane(this.tree);
        this.rootComponent.add(this.pane);
    }

    public void setScrollPaneBorder(Border border) {
        this.pane.setBorder(border);
    }

    protected Icon getMachineIcon() {
        return ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16");
    }

    protected Icon getFolderIcon() {
        return ImageLoader.getImageIcon((String)"images/svg/general/machine-group.svg,16");
    }

    public String getSelection() {
        TreePath path = this.tree.getSelectionPath();
        return this.getMachineNameFromPath(path);
    }

    private String getMachineNameFromPath(TreePath path) {
        StringBuffer sb = new StringBuffer();
        if (path == null) {
            return null;
        }
        for (int i = 0; i < path.getPathCount(); ++i) {
            SimpleTreeModel.TreeNode node = (SimpleTreeModel.TreeNode)path.getPathComponent(i);
            TreeItemWrapper wrapper = (TreeItemWrapper)node.value;
            if (wrapper == null) continue;
            sb.append(wrapper.name);
            if (i >= path.getPathCount() - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public void setGroupsToShow(List<String[]> machineGroups, List<String> machineNames, List<String> machineIDs) {
        boolean includeMachineNames = machineNames != null;
        ++this.count;
        for (int j = 0; j < machineGroups.size(); ++j) {
            String[] groupPath = machineGroups.get(j);
            if (groupPath == null) continue;
            StringBuffer groupID = new StringBuffer();
            TreeItemWrapper parent = null;
            for (int i = 0; i < groupPath.length; ++i) {
                String child = groupPath[i];
                if (i == 0) {
                    groupID.append(child);
                } else {
                    groupID.append("/").append(child);
                }
                TreeItemWrapper item = new TreeItemWrapper();
                item.name = child;
                item.isMachine = false;
                item.tag = this.count;
                item.id = groupID.toString();
                TreeItemWrapper foundChild = this.model.getChildWithValueThatEquals(parent, item);
                if (foundChild == null) {
                    foundChild = item;
                    this.model.addChild(parent, item, false, false);
                }
                foundChild.tag = this.count;
                parent = item;
            }
            if (!includeMachineNames) continue;
            TreeItemWrapper item = new TreeItemWrapper();
            item.name = machineNames.get(j);
            item.isMachine = true;
            if (machineIDs != null) {
                item.id = machineIDs.get(j);
            }
            item.tag = this.count;
            TreeItemWrapper foundChild = this.model.getChildWithValueThatEquals(parent, item);
            if (foundChild == null) {
                foundChild = item;
                this.model.addChild(parent, item, false, false);
            }
            foundChild.tag = this.count;
        }
        this.removeChildrenWithTagsNotEqual((TreeItemWrapper)this.model.getTreeNodeFor(null).value, this.count);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleMachineGroupList.this.tree.expandPath(new TreePath(SimpleMachineGroupList.this.model.getTreeNodeFor(null)));
            }
        });
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    private void removeChildrenWithTagsNotEqual(TreeItemWrapper value, long tag) {
        int count = this.model.getChildCount(value);
        for (int i = count - 1; i >= 0; --i) {
            TreeItemWrapper child = this.model.getChild(value, i);
            this.removeChildrenWithTagsNotEqual(child, tag);
            if (child.tag == tag) continue;
            this.model.remove(value, i);
        }
    }

    public void setGroupsToShow(String[][] machineGroups, String[] machineNames, String[] ids) {
        this.setGroupsToShow(machineGroups != null ? Arrays.asList(machineGroups) : null, machineNames != null ? Arrays.asList(machineNames) : null, ids != null ? Arrays.asList(ids) : null);
    }

    public static void main(String[] args) throws InterruptedException {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        SimpleMachineGroupList groupList = new SimpleMachineGroupList(new String[][]{{"A", "1", "Test"}, {"A", "2", "Test"}, {"B", "1", "Test"}, {"b", "1", "Test"}}, new String[]{"1", "2", "3", "4"}, null, "Connect", null);
        frame.getContentPane().add(groupList.getRootComponent());
        frame.setVisible(true);
        Thread.sleep(2000L);
        ArrayList<String[]> machineGroups = new ArrayList<String[]>();
        machineGroups.add(new String[0]);
        ArrayList<String> machineNames = new ArrayList<String>();
        machineNames.add("lingo.lan");
        ArrayList<String> machineIDs = new ArrayList<String>();
        machineIDs.add("SG_1926064173130031218");
        groupList.setGroupsToShow(machineGroups, machineNames, machineIDs);
        Thread.sleep(2000L);
        groupList.setGroupsToShow(new String[][]{{"A", "1", "Test"}, {"A", "2", "Test"}, {"B", "1", "Test"}, {"b", "1", "Test"}}, new String[]{"1", "2", "3", "4"}, null);
        Thread.sleep(5000L);
        groupList.setGroupsToShow(new String[][]{{"A", "1", "Test"}, {"b", "1", "Test"}}, new String[]{"11", "44"}, null);
    }

    public String[] getSelectedGroup() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object[] pathArray = path.getPath();
        String[] result = new String[pathArray.length];
        for (int i = 0; i < pathArray.length; ++i) {
            result[i] = "" + pathArray[i];
        }
        return result;
    }

    public static interface ButtonClickListener {
        public void buttonClicked(Object var1);
    }

    class ConnectListener
    implements MouseMotionListener,
    MouseListener {
        int hoverRow = -1;

        ConnectListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            try {
                if (e.getSource() == SimpleMachineGroupList.this.tree) {
                    int previousRow = this.hoverRow;
                    this.hoverRow = SimpleMachineGroupList.this.tree.getRowForLocation(e.getX(), e.getY());
                    if (this.hoverRow == previousRow) {
                        return;
                    }
                    this.repaintRows(this.hoverRow, previousRow);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private void repaintRows(int hoverRow, int previousRow) {
            SimpleMachineGroupList.this.renderer.setHoverRow(hoverRow);
            if (hoverRow != -1) {
                SimpleMachineGroupList.this.tree.repaint(SimpleMachineGroupList.this.tree.getRowBounds(hoverRow));
            }
            if (previousRow != -1) {
                SimpleMachineGroupList.this.tree.repaint(SimpleMachineGroupList.this.tree.getRowBounds(previousRow));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int row = SimpleMachineGroupList.this.tree.getRowForLocation(e.getX(), e.getY());
            if (row == this.hoverRow) {
                Rectangle rect = SimpleMachineGroupList.this.tree.getRowBounds(row);
                if (rect == null) {
                    return;
                }
                TreePath pathForRow = SimpleMachineGroupList.this.tree.getPathForRow(row);
                SimpleTreeModel.TreeNode node = (SimpleTreeModel.TreeNode)pathForRow.getLastPathComponent();
                TreeItemWrapper item = (TreeItemWrapper)node.value;
                if (!item.isMachine) {
                    return;
                }
                if (rect.contains(e.getPoint())) {
                    int buttonSize = ((SimpleMachineGroupList)SimpleMachineGroupList.this).renderer.getButtonSize().width;
                    int leftX = rect.x + rect.width - buttonSize;
                    int rightX = rect.x + rect.width;
                    if (e.getX() < rightX && e.getX() > leftX) {
                        ActionEvent ae = new ActionEvent(SimpleMachineGroupList.this.tree, 0, null);
                        SimpleMachineGroupList.this.buttonClickListener.buttonClicked(item.id);
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            int previousRow = this.hoverRow;
            this.hoverRow = -1;
            this.repaintRows(this.hoverRow, previousRow);
        }
    }

    class MachineGroupCellRenderer
    extends DefaultTreeCellRenderer {
        private Icon folderIcon;
        private Icon machineIcon;
        private Image hoverImage;
        private int hoverRow = -1;
        private int paintedRow = -2;

        public MachineGroupCellRenderer(Icon machineIcon, Icon folderIcon) {
            this.machineIcon = machineIcon;
            this.folderIcon = folderIcon;
            this.hoverImage = SwingUtil.getButtonImage((String)SimpleMachineGroupList.this.buttonText, (boolean)true, (int)SHStyle.SMALL_BUTTON_HEIGHT);
            this.setBackgroundSelectionColor(null);
            this.setTextSelectionColor(Color.WHITE);
            this.setBorderSelectionColor(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            JLabel label = (JLabel)c;
            SimpleTreeModel.TreeNode node = (SimpleTreeModel.TreeNode)value;
            TreeItemWrapper item = (TreeItemWrapper)node.value;
            if (item == null) {
                return label;
            }
            if (item.isMachine) {
                label.setIcon(this.machineIcon);
            } else {
                label.setIcon(this.folderIcon);
            }
            this.paintedRow = item.isMachine ? row : -100;
            return label;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.selected) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(AccessStyle.TREE_SELECTION_COLOR);
            }
            if (this.paintedRow == this.hoverRow) {
                AffineTransform t = SwingUtil.prepareForRetina((Graphics2D)g2d);
                int factor = 1;
                if (OS.isOSXRetina()) {
                    factor = 2;
                }
                try {
                    g2d.drawImage(this.hoverImage, factor * this.getWidth() - this.hoverImage.getWidth(null) - 2, (factor * this.getHeight() - this.hoverImage.getHeight(null)) / 2, null);
                }
                finally {
                    g2d.setTransform(t);
                }
            }
        }

        public Dimension getButtonSize() {
            return new Dimension(this.hoverImage.getWidth(null) + 2, this.hoverImage.getHeight(null) + 2);
        }

        public void setHoverRow(int row) {
            this.hoverRow = row;
        }
    }

    class TreeItemWrapper
    implements Comparable<TreeItemWrapper> {
        public long tag;
        public boolean isMachine = false;
        public String name;
        public String id;

        TreeItemWrapper() {
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            if (this.id == null) {
                return this.name.hashCode();
            }
            return this.id.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            TreeItemWrapper tiw = (TreeItemWrapper)o;
            if (this.id != null) {
                return tiw.name.equals(this.name) && tiw.isMachine == this.isMachine && tiw.id.equals(this.id);
            }
            return tiw.name.equals(this.name) && tiw.isMachine == this.isMachine;
        }

        @Override
        public int compareTo(TreeItemWrapper o) {
            return this.name.compareTo(o.name);
        }
    }
}

