/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.config.panels;

import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.sgateway.config.Server;
import com.aem.sgateway.config.URLTester;
import com.aem.sgateway.config.panels.SGChangeListener;
import com.aem.sgateway.ui.ServerProtocolChoicePanel;
import com.aem.sgateway.ui.SimpleGatewayGroupUI;
import com.aem.shelp.common.Language;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import com.aem.shelp.util.progress.SHProgressAnimatedIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.stream.URLUtil;
import utils.swing.SwingUtil;
import utils.swing.components.StrippedContentPanel;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.AsyncFocusGrabber;
import utils.swing.dialog.jdialog.SHOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.switches.Switches;

public class SGServersPanel
implements ActionListener,
URLTester.URLTesterStatusListener {
    private GbPanel rootComponent = new GbPanel();
    private StrippedContentPanel contentPanel = new SHStrippedContentPanel(this.rootComponent, false);
    private SGChangeListener dirtyListener;
    private JTextField machineNameField;
    private JButton addButton;
    private JButton deleteButton;
    private JButton testButton;
    private SimpleGatewayGroupUI simpleGatewayGroupUI;
    private JLabel serviceStatusLabel;
    private JButton switchStatusButton;
    private JList serversList;
    private DefaultListModel serversModel = new DefaultListModel();
    private boolean fileAccess;
    private boolean showSilentInstall;
    private boolean supportsUDP;
    private JCheckBox shortcutsBox;
    private JCheckBox silentInstallBox;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public DefaultListModel getServers() {
        return this.serversModel;
    }

    public SGServersPanel(SGChangeListener dirtyListener, boolean useTabs, boolean fileAccess, boolean supportsUDP, boolean showSilentInstall) {
        this.dirtyListener = dirtyListener;
        this.supportsUDP = supportsUDP;
        this.fileAccess = fileAccess;
        this.showSilentInstall = showSilentInstall;
        this.initUI(useTabs);
    }

    private void initUI(boolean useTabs) {
        TextField tf = new TextField(null, null);
        tf.setExampleValue("AUTODETECT");
        this.machineNameField = (JTextField)tf.getComponent();
        this.machineNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SGServersPanel.this.dirtyListener.setDirty(true);
            }
        });
        JPanel wrapperPanel = new JPanel(new GridLayout(1, 1));
        wrapperPanel.add(this.machineNameField);
        SwingUtil.setHeight((JComponent)this.machineNameField, (int)SimpleHelpLookAndFeel.scale((int)36));
        wrapperPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)5, (int)0));
        this.contentPanel.addContent(wrapperPanel, Language.get("THIS_COMPUTERS_NAME"));
        final GbPanel rightButtonPanel = new GbPanel();
        GbPanel urlp = new GbPanel(){

            public void setBackground(Color c) {
                super.setBackground(c);
                rightButtonPanel.setBackground(c);
            }
        };
        urlp.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)5, (int)0));
        this.serversList = new JList(this.serversModel);
        this.serversList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = SGServersPanel.this.serversList.locationToIndex(e.getPoint());
                if (index > -1) {
                    SGServersPanel.this.serversList.setToolTipText(null);
                    Server s = (Server)SGServersPanel.this.serversModel.getElementAt(index);
                    SGServersPanel.this.serversList.setToolTipText(s.getToolTipText());
                }
            }
        });
        this.serversList.setFixedCellHeight(SimpleHelpLookAndFeel.scale((int)25));
        this.serversList.setCellRenderer(new ServerRenderer());
        this.serversList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SGServersPanel.this.serversList.getSelectedIndex() != -1) {
                    SGServersPanel.this.deleteButton.setEnabled(true);
                } else {
                    SGServersPanel.this.deleteButton.setEnabled(false);
                }
                SGServersPanel.this.updateGroupPickOption();
            }
        });
        this.serversList.addMouseListener(new EditAdapter());
        if (!useTabs) {
            SwingUtil.setHeight((JComponent)urlp, (int)SimpleHelpLookAndFeel.scale((int)120));
        }
        this.addButton = new JButton(Language.get("ADD"), ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
        this.deleteButton = new JButton(Language.get("REMOVE"), ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
        this.testButton = new JButton(Language.get("TEST"), ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,16"));
        this.addButton.setHorizontalAlignment(2);
        this.deleteButton.setHorizontalAlignment(2);
        this.testButton.setHorizontalAlignment(2);
        int Y = 0;
        rightButtonPanel.add((Component)this.addButton, 0, Y++, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(0, 0, 3, 0));
        rightButtonPanel.add((Component)this.deleteButton, 0, Y++, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(0, 0, 3, 0));
        this.deleteButton.setEnabled(false);
        this.testButton.setEnabled(false);
        this.addButton.setHorizontalAlignment(2);
        this.deleteButton.setHorizontalAlignment(2);
        this.testButton.setHorizontalAlignment(2);
        this.addButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.testButton.addActionListener(this);
        int X = 0;
        urlp.add((Component)new JScrollPane(this.serversList), X++, 0, 1, 1, 1000, 1000, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 3));
        urlp.add((Component)rightButtonPanel, X++, 0, 1, 1, 0, 10, 11, 0, (Insets)new ScaledInsets(0, 3, 0, 0));
        if (this.fileAccess) {
            rightButtonPanel.add((Component)this.testButton, 0, Y++, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(10, 0, 3, 0));
        }
        this.contentPanel.addContent((JComponent)urlp, Language.get("SIMPLEGATEWAY_SERVERS"));
        urlp.setPreferredSize(urlp.getMinimumSize());
        this.simpleGatewayGroupUI = new SimpleGatewayGroupUI(SwingUtil.getRootPaneContainer((Component)this.rootComponent), "", this.dirtyListener);
        GbPanel groupWrapper = new GbPanel(){

            public void setBackground(Color c) {
                super.setBackground(c);
                SGServersPanel.this.simpleGatewayGroupUI.setBackground(c);
            }
        };
        groupWrapper.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)5, (int)0));
        int X2 = 0;
        groupWrapper.add((Component)this.simpleGatewayGroupUI.getRootComponent(), X2++, 0, 1, 1, 1, 1, 10, 1);
        SwingUtil.setHeight((JComponent)groupWrapper, (int)(groupWrapper.getMinimumSize().height + SimpleHelpLookAndFeel.scale((int)20)));
        GbPanel onOffWrapper = new GbPanel(new ScaledInsets(3, 0, 3, 0));
        this.serviceStatusLabel = new JLabel();
        this.switchStatusButton = new JButton();
        this.setStatusNotRunning();
        this.switchStatusButton.addActionListener(this);
        onOffWrapper.add((Component)this.serviceStatusLabel, 0, 0, 1, 1, 1, 1, 17, 2);
        onOffWrapper.add((Component)this.switchStatusButton, 1, 0, 1, 1, 0, 1, 17, 0);
        GbPanel shortcutsWrapper = new GbPanel(new ScaledInsets(5, 0, 5, 0));
        this.shortcutsBox = new JCheckBox(Language.get("INSTALL_SHORTCUTS_CHECKBOX"));
        this.shortcutsBox.setSelected(true);
        this.shortcutsBox.addActionListener(this);
        shortcutsWrapper.add((Component)this.shortcutsBox, 0, 0, 1, 1, 1, 1, 17, 2);
        if (this.showSilentInstall) {
            this.silentInstallBox = new JCheckBox(Language.get("SILENT_INSTALL"));
            this.silentInstallBox.setSelected(false);
            this.silentInstallBox.addActionListener(this);
            shortcutsWrapper.add((Component)this.silentInstallBox, 0, 1, 1, 1, 1, 1, 17, 2);
        }
        this.contentPanel.addContent((JComponent)groupWrapper, Language.get("GROUP_PANEL_TITLE"));
        if (useTabs) {
            if (this.fileAccess) {
                this.contentPanel.addContent((JComponent)onOffWrapper, null);
            } else {
                this.contentPanel.addContent((JComponent)shortcutsWrapper, null);
            }
        }
        this.contentPanel.addVerticalFiller();
        this.contentPanel.setBackgroundColours();
        SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{this.switchStatusButton, this.addButton, this.deleteButton, this.testButton});
    }

    private void updateGroupPickOption() {
        Server selectedSerlver = this.getSelectedServerOrFirstOption();
        this.simpleGatewayGroupUI.setSelectedServer(selectedSerlver, this.serversModel.getSize());
    }

    public boolean canSave() {
        return true;
    }

    public void setStatusRunning() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String label = Language.get("SG_SERVICE_STATUS_LABEL");
                label = label + " <font color=#28AB00><B>" + Language.get("SG_SERVICE_RUNNING") + "</B></font>";
                SGServersPanel.this.serviceStatusLabel.setText("<html>" + label + "</html>");
                SGServersPanel.this.switchStatusButton.setText(Language.get("SG_SERVICE_STOP_LABEL"));
                SGServersPanel.this.switchStatusButton.setEnabled(true);
                SGServersPanel.this.serviceStatusLabel.repaint();
                SGServersPanel.this.switchStatusButton.repaint();
            }
        });
    }

    public void setStatusNotRunning() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String label = Language.get("SG_SERVICE_STATUS_LABEL");
                label = label + " <font color=#A22A0A><B>" + Language.get("SG_SERVICE_NOT_RUNNING") + "</B></font>";
                SGServersPanel.this.serviceStatusLabel.setText("<html>" + label + "</html>");
                SGServersPanel.this.switchStatusButton.setText(Language.get("SG_SERVICE_START_LABEL"));
                SGServersPanel.this.switchStatusButton.setEnabled(true);
                SGServersPanel.this.serviceStatusLabel.repaint();
                SGServersPanel.this.switchStatusButton.repaint();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFrom(SimpleGatewayConfig config, boolean allowSilent, boolean installShortcuts) {
        this.dirtyListener.setIgnoreEvents(true);
        try {
            this.serversModel.clear();
            if (config != null) {
                String machineName;
                String[] configURLs = config.getRawURLs();
                if (configURLs != null) {
                    for (String url : configURLs) {
                        Server s = new Server();
                        s.setURL(url, config.getUrlRecoveryKey(url));
                        System.out.println("[SimpleGatewayServiceConfigure] Loaded config " + s + " - " + s.isUDP());
                        this.serversModel.addElement(s);
                    }
                }
                if ((machineName = config.getName()).indexOf(47) == -1) {
                    this.simpleGatewayGroupUI.clear();
                    if (machineName.equals("AUTODETECT")) {
                        this.machineNameField.setText("");
                    } else {
                        this.machineNameField.setText(machineName);
                    }
                } else {
                    int lastSlash = machineName.lastIndexOf(47);
                    String groupPrefix = machineName.substring(0, lastSlash);
                    String nameSuffix = machineName.substring(lastSlash + 1);
                    this.machineNameField.setText(nameSuffix);
                    this.simpleGatewayGroupUI.setGroupString(groupPrefix);
                }
            }
            if (this.silentInstallBox != null) {
                this.silentInstallBox.setSelected(allowSilent);
            }
            if (this.shortcutsBox != null) {
                this.shortcutsBox.setSelected(installShortcuts);
            }
            this.dirtyListener.machineListChanged();
        }
        finally {
            this.dirtyListener.setIgnoreEvents(false);
        }
    }

    public void saveTo(SimpleGatewayConfig config) {
        try {
            String prefix = this.simpleGatewayGroupUI.getGroupsAsString();
            if (this.machineNameField.getText().length() == 0) {
                config.setName(prefix + "AUTODETECT");
            } else {
                config.setName(prefix + this.machineNameField.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.getRootComponent(), Language.get("CONFIG_ERROR_COMPUTER_NAME"), Language.get("CONFIG_ERROR"), 0);
        }
        try {
            ArrayList<String> urls = new ArrayList<String>();
            for (int i = 0; i < this.serversModel.getSize(); ++i) {
                Server server = (Server)this.serversModel.getElementAt(i);
                urls.add(server.getFullURL());
                config.setUrlRecoveryKey(server.getFullURL(), server.getRecoveryKey());
            }
            config.setURLs(urls.toArray(new String[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.getRootComponent(), Language.get("CONFIG_ERROR_SG_SERVERS"), Language.get("CONFIG_ERROR"), 0);
        }
    }

    public Server getFirstServerInList() {
        if (this.serversModel.size() == 0) {
            return null;
        }
        return (Server)this.serversModel.get(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.switchStatusButton) {
            this.dirtyListener.switchServiceState();
        } else if (o == this.shortcutsBox) {
            this.dirtyListener.setDirty(true);
        } else if (o == this.silentInstallBox) {
            this.dirtyListener.setDirty(true);
        } else if (o == this.addButton) {
            String output;
            ServerProtocolChoicePanel spcp = new ServerProtocolChoicePanel(this.supportsUDP);
            if (Switches.SH_sgUrlDialogGrabFocusAsync) {
                AsyncFocusGrabber.grabFor(spcp.getFocusComponent());
            }
            if (SHOptionPane.showOkCancelPanelDialog(SwingUtil.getParentFrame((Component)this.rootComponent), (JPanel)spcp.getRootComponent(), Language.get("SIMPLEGATEWAY_SERVER"), Language.get("MIGRATE_ADD"), Language.get("CANCEL")) && (output = spcp.getFullAddress()).length() > 0) {
                if (!(output.startsWith("http://") || output.startsWith("https://") || output.startsWith("udp://"))) {
                    output = "http://" + output;
                }
                try {
                    String myserver = URLUtil.pickServerFromURL(output, true);
                    for (int i = 0; i < this.serversModel.getSize(); ++i) {
                        Server serv = (Server)this.serversModel.get(i);
                        String compare = URLUtil.pickServerFromURL(serv.getFullURL(), true);
                        if (!myserver.toLowerCase().equals(compare.toLowerCase()) || 1 != JOptionPane.showConfirmDialog((Component)this.rootComponent, Language.get("SG_WARN_SAMESERVER_MSG_1") + "\n" + Language.get("SG_WARN_SAMESERVER_MSG_2") + "\n\n" + Language.get("SG_WARN_SAMESERVER_MSG_3"), Language.get("SG_WARN_SAMESERVER_TITLE"), 0)) continue;
                        return;
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                Server s = new Server();
                s.setURL(output, null);
                this.serversModel.addElement(s);
                this.dirtyListener.machineListChanged();
                if (this.fileAccess) {
                    new URLTester(s, this).start();
                }
            }
            this.dirtyListener.setDirty(true);
        } else if (o == this.deleteButton) {
            int index = this.serversList.getSelectedIndex();
            if (index != -1) {
                this.serversModel.remove(index);
            }
            this.dirtyListener.machineListChanged();
            this.dirtyListener.setDirty(true);
        } else if (o == this.testButton) {
            this.dirtyListener.setProxySettings();
            this.testButton.setEnabled(false);
            this.testURLs();
        }
    }

    public int getServerCount() {
        return this.serversModel.size();
    }

    public void updateEnabled() {
        this.switchStatusButton.setEnabled(this.serversModel.size() > 0);
        this.testButton.setEnabled(this.serversModel.size() > 0);
        this.testButton.repaint();
        this.serversList.repaint();
        this.switchStatusButton.repaint();
        this.updateGroupPickOption();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testURLs() {
        if (!this.fileAccess) {
            return;
        }
        for (int i = 0; i < this.serversModel.size(); ++i) {
            Server s;
            Server server = s = (Server)this.serversModel.get(i);
            synchronized (server) {
                if (!s.isBeingChecked()) {
                    new URLTester(s, this).start();
                }
                continue;
            }
        }
    }

    @Override
    public void notifyCheckingServer(Server server) {
        this.serversList.repaint();
    }

    @Override
    public void notifyServerSettingsUpdated(Server server) {
        this.dirtyListener.setDirty(true);
    }

    @Override
    public void notifyTestingFinished(boolean allTestersFinished) {
        if (allTestersFinished) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SGServersPanel.this.testButton.setEnabled(true);
                }
            });
        }
        this.serversList.repaint();
    }

    public boolean canInstallShortcuts() {
        return this.shortcutsBox == null || this.shortcutsBox.isSelected();
    }

    public boolean mustSilentInstall() {
        return this.silentInstallBox != null && this.silentInstallBox.isSelected();
    }

    public void setSwitchButtonEnabled(boolean b) {
        this.switchStatusButton.setEnabled(b);
    }

    private Server[] getServerList() {
        int size = this.serversModel.getSize();
        Server[] result = new Server[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Server)this.serversModel.get(i);
        }
        return result;
    }

    public Server getSelectedServerOrFirstOption() {
        Server server = (Server)this.serversList.getSelectedValue();
        if (server != null) {
            return server;
        }
        Server[] serverList = this.getServerList();
        if (serverList.length == 1) {
            return serverList[0];
        }
        return null;
    }

    public void setSelectedGroup(String[] selectedGroup) {
        this.simpleGatewayGroupUI.setGroup(selectedGroup);
    }

    class EditAdapter
    extends MouseAdapter {
        EditAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                String output;
                Server server = (Server)SGServersPanel.this.serversList.getSelectedValue();
                String oldURL = server.getFullURL();
                ServerProtocolChoicePanel spcp = new ServerProtocolChoicePanel(SGServersPanel.this.supportsUDP, server.getFullURL());
                if (Switches.SH_sgUrlDialogGrabFocusAsync) {
                    AsyncFocusGrabber.grabFor(spcp.getFocusComponent());
                }
                if (SHOptionPane.showOkCancelPanelDialog(SwingUtil.getParentFrame((Component)SGServersPanel.this.rootComponent), (JPanel)spcp.getRootComponent(), Language.get("SIMPLEGATEWAY_SERVER"), Language.get("DONE"), Language.get("CANCEL")) && (output = spcp.getFullAddress()).length() > 0) {
                    if (!(output.startsWith("http://") || output.startsWith("https://") || output.startsWith("udp://"))) {
                        output = "http://" + output;
                    }
                    if (!output.equals(oldURL)) {
                        server.setURL(output, null);
                        if (SGServersPanel.this.fileAccess) {
                            new URLTester(server, SGServersPanel.this).start();
                        }
                        SGServersPanel.this.dirtyListener.machineListChanged();
                    }
                }
                SGServersPanel.this.dirtyListener.setDirty(true);
            }
        }
    }

    class ServerRenderer
    extends DefaultListCellRenderer {
        Icon icon = new SHProgressAnimatedIcon();

        ServerRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            JLabel l = (JLabel)c;
            Server s = (Server)value;
            if (SGServersPanel.this.fileAccess) {
                if (!s.isBeingChecked()) {
                    if (s.canConnect()) {
                        l.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16"));
                    } else {
                        l.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
                    }
                } else {
                    l.setIcon(this.icon);
                }
            } else {
                l.setIcon(null);
            }
            return c;
        }
    }
}

