/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.config.panels;

import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.sgateway.config.panels.SGChangeListener;
import com.aem.shelp.common.Language;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import com.aem.shelp.util.swing.RequestAccessTimeoutPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import utils.swing.JFixedWidthPasswordField;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JWrapCheckBox;
import utils.swing.components.StrippedContentPanel;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class SGSecurityPanel
implements ActionListener,
ItemListener {
    private final GbPanel rootComponent = new GbPanel();
    private final StrippedContentPanel contentPanel = new SHStrippedContentPanel(this.rootComponent, false);
    private JWrapCheckBox useMachinePassword;
    private JLabel machinePasswordLabelFirst;
    private JLabel machinePasswordLabelSecond;
    private JPasswordField firstPasswordField;
    private JPasswordField secondPasswordField;
    private JCheckBox allowMonitoring;
    private JCheckBox allowScripting;
    private JCheckBox requireConfirm;
    private RequestAccessTimeoutPanel timeoutPanel;
    private final SGChangeListener dirtyListener;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public SGSecurityPanel(SGChangeListener dirtyListener, boolean useTabs) {
        this.dirtyListener = dirtyListener;
        if (!useTabs) {
            this.contentPanel.setStartDark(true);
        }
        this.initUI(useTabs);
    }

    private void initUI(boolean useTabs) {
        this.useMachinePassword = new JWrapCheckBox(Language.get("REQUIRE_MACHINE_PASSWORD"));
        ColorPropagatingGBPanel permissionsPanel = new ColorPropagatingGBPanel(new ScaledInsets(0, 0, 3, 0));
        this.allowMonitoring = new JCheckBox(Language.get("PERM_ALLOW_MONITORING"), true);
        this.allowScripting = new JCheckBox(Language.get("PERM_ALLOW_COMMANDS"), true);
        this.requireConfirm = new JCheckBox(Language.get("PERM_TECH_MUST_CONFIRM"));
        this.timeoutPanel = new RequestAccessTimeoutPanel();
        this.timeoutPanel.addActionListener(new DirtyActionListener());
        this.allowMonitoring.addActionListener(this);
        this.allowScripting.addActionListener(this);
        this.requireConfirm.addActionListener(this);
        if (useTabs) {
            permissionsPanel.add(this.allowMonitoring, 0, 0, 1, 1, 10, 0, 17, 0);
            permissionsPanel.add(this.allowScripting, 0, 1, 1, 1, 10, 0, 17, 0);
            permissionsPanel.add(this.requireConfirm, 0, 2, 1, 1, 10, 0, 17, 0, (Insets)new ScaledInsets(10, 0, 3, 0));
            permissionsPanel.add((Component)this.timeoutPanel.getRootComponent(), 0, 3, 2, 1, 10, 0, 17, 2, (Insets)new ScaledInsets(0, 20, 3, 0));
        } else {
            permissionsPanel.add(this.allowMonitoring, 0, 0, 1, 1, 10, 0, 17, 0);
            permissionsPanel.add(this.allowScripting, 1, 0, 1, 1, 10, 0, 17, 0);
            permissionsPanel.add(this.requireConfirm, 0, 1, 1, 1, 10, 0, 17, 0);
            permissionsPanel.add((Component)this.timeoutPanel.getRootComponent(), 0, 3, 1, 1, 10, 0, 17, 0);
        }
        ColorPropagatingGBPanel passwordPanel = new ColorPropagatingGBPanel(new ScaledInsets(0, 0, 3, 0));
        this.machinePasswordLabelFirst = new JLabel("   " + Language.get("PASSWORD"));
        this.machinePasswordLabelSecond = new JLabel("   " + Language.get("CONFIRM_PASSWORD"));
        this.firstPasswordField = new JFixedWidthPasswordField();
        this.secondPasswordField = new JFixedWidthPasswordField();
        this.firstPasswordField.addKeyListener(this.dirtyListener);
        this.secondPasswordField.addKeyListener(this.dirtyListener);
        int Y = 0;
        passwordPanel.add(this.useMachinePassword.getRootComponent(), 0, Y++, 2, 1, 0, 10, 17, 2);
        passwordPanel.add(this.machinePasswordLabelFirst, 0, Y, 1, 1, 0, 10, 13, 0);
        passwordPanel.add(this.firstPasswordField, 1, Y++, 1, 1, 30, 10, 10, 2, (Insets)new ScaledInsets(0, 6, 3, 50));
        passwordPanel.add(this.machinePasswordLabelSecond, 0, Y, 1, 1, 0, 10, 13, 0);
        passwordPanel.add(this.secondPasswordField, 1, Y++, 1, 1, 30, 10, 10, 2, (Insets)new ScaledInsets(0, 6, 3, 50));
        this.contentPanel.addContent((JComponent)((Object)permissionsPanel), Language.get("ACCESS_PERMISSIONS"));
        this.contentPanel.addContent((JComponent)((Object)passwordPanel), Language.get("PASSWORD"));
        if (useTabs) {
            this.contentPanel.addVerticalFiller();
        }
        this.contentPanel.setBackgroundColours(useTabs);
        this.useMachinePassword.setBackground(passwordPanel.getBackground());
        this.updateEnabled();
    }

    public void updateEnabled() {
        if (this.useMachinePassword != null) {
            boolean b = this.useMachinePassword.isSelected();
            this.machinePasswordLabelFirst.setEnabled(b);
            this.machinePasswordLabelSecond.setEnabled(b);
            this.firstPasswordField.setEnabled(b);
            this.secondPasswordField.setEnabled(b);
        }
        boolean confirm = this.requireConfirm.isSelected();
        this.timeoutPanel.setEnabled(confirm);
    }

    public void loadFrom(SimpleGatewayConfig config) {
        if (config.getPassword() != null) {
            this.useMachinePassword.setSelected(true);
            try {
                this.firstPasswordField.setText(config.getPassword());
                this.secondPasswordField.setText(config.getPassword());
            }
            catch (Exception e) {
                this.firstPasswordField.setText("");
                this.secondPasswordField.setText("");
            }
        } else {
            this.useMachinePassword.setSelected(false);
        }
        this.allowMonitoring.setSelected(config.getAllowMonitoring());
        this.allowScripting.setSelected(config.getAllowScripting());
        this.requireConfirm.setSelected(config.getRequireSessionConfirmation());
        long timeout = config.getRequirePermissionTimeoutMS();
        this.timeoutPanel.setTimeout(timeout);
        this.useMachinePassword.addItemListener(this);
        this.updateEnabled();
    }

    public void saveTo(SimpleGatewayConfig config) {
        if (this.useMachinePassword.isSelected()) {
            config.setPassword(new String(this.firstPasswordField.getPassword()));
        } else {
            config.setPassword("");
        }
        config.setAllowMonitoring(this.allowMonitoring.isSelected());
        config.setAllowScripting(this.allowScripting.isSelected());
        long timeout = this.timeoutPanel.getTimeout();
        config.setRequireSessionConfirmation(this.requireConfirm.isSelected(), timeout);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateEnabled();
        if (e.getSource() == this.allowScripting || e.getSource() == this.allowMonitoring || e.getSource() == this.requireConfirm) {
            this.dirtyListener.setDirty(true);
        }
    }

    public boolean canSave() {
        if (this.useMachinePassword != null && this.useMachinePassword.isSelected()) {
            return Arrays.equals(this.firstPasswordField.getPassword(), this.secondPasswordField.getPassword());
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.useMachinePassword.getCheckBoxComponent()) {
            this.dirtyListener.setDirty(true);
            this.updateEnabled();
        }
    }

    class DirtyActionListener
    implements ActionListener {
        DirtyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SGSecurityPanel.this.updateEnabled();
            SGSecurityPanel.this.dirtyListener.setDirty(true);
        }
    }
}

