/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.common;

import com.aem.utils.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import jwrapper.jwutils.JWSystem;
import utils.files.FileLockUtil;
import utils.ostools.OS;

public class SGPortUtil {
    private static final File[] getSGPortChildrenOf(File parent) {
        System.out.println("[SGPortUtil] Searching " + parent.getAbsolutePath() + " for SG port files");
        ArrayList<File> list = new ArrayList<File>();
        File[] children = parent.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                String name = children[i].getName();
                if (!name.equals("sgport") && !name.startsWith("sgport-") || name.endsWith(".lock")) continue;
                list.add(children[i]);
            }
        }
        return list.toArray(new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSgPortFromFile(File sgPortFile, boolean v4Installation) throws Exception {
        if (!sgPortFile.exists()) {
            return -1;
        }
        String sport = "";
        try (FileInputStream fin = new FileInputStream(sgPortFile);){
            sport = StreamUtils.readAllAsStringISO88951(fin);
        }
        return (int)Double.parseDouble(sport.trim());
    }

    public static final File[] getSgPortFiles(File master) {
        return SGPortUtil.getSGPortChildrenOf(JWSystem.getAllAppVersionsSharedFolder((File)master));
    }

    public static final File[] getSGPortFiles(boolean v4Installation) {
        if (v4Installation) {
            return SGPortUtil.getSGPortChildrenOf(JWSystem.getAllAppVersionsSharedFolder());
        }
        return SGPortUtil.getSGPortChildrenOf(new File("../../"));
    }

    public static final File getSGPortFile(File master) {
        File shared = JWSystem.getAllAppVersionsSharedFolder((File)master);
        if (OS.isMacOS()) {
            return new File(shared, "sgport-" + System.getProperty("user.name"));
        }
        return new File(shared, "sgport");
    }

    public static final File getSGPortFile(boolean v4Installation) {
        if (v4Installation) {
            if (OS.isMacOS()) {
                return new File(JWSystem.getAllAppVersionsSharedFolder(), "sgport-" + System.getProperty("user.name"));
            }
            return new File(JWSystem.getAllAppVersionsSharedFolder(), "sgport");
        }
        if (OS.isMacOS()) {
            return new File("sgport-" + System.getProperty("user.name"));
        }
        return new File("sgport");
    }

    public static File getSgIsRunningFile(boolean v4Installation) {
        if (v4Installation) {
            return new File(JWSystem.getAllAppVersionsSharedFolder(), "sgrunning");
        }
        return new File("sgrunning");
    }

    public static String getSgPortFileUsername(File file) {
        String id = "";
        try {
            int dashIndex;
            if (file != null && (dashIndex = file.getName().indexOf(45)) != -1) {
                id = file.getName().substring(dashIndex + 1);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return id;
    }

    public static FileLockUtil.LockResult getLockForSGPortOrTimeout(File sgportFile, long timeout) {
        File lockFile = new File(sgportFile.getParentFile(), sgportFile.getName() + ".lock");
        return FileLockUtil.lockFileOrTimeout((File)lockFile, (long)timeout);
    }

    public static FileLockUtil.LockResult getLockForSGPortOrBlock(File sgportFile) {
        File lockFile = new File(sgportFile.getParentFile(), sgportFile.getName() + ".lock");
        return FileLockUtil.lockFileOrBlock((File)lockFile);
    }

    public static FileLockUtil.LockResult tryGetLockForSGPort(File sgportFile) {
        File lockFile = new File(sgportFile.getParentFile(), sgportFile.getName() + ".lock");
        return FileLockUtil.tryLockFile((File)lockFile);
    }

    public static boolean isSGPortFileLocked(File sgPortFile) {
        File lockFile = new File(sgPortFile.getParentFile(), sgPortFile.getName() + ".lock");
        return FileLockUtil.isFileCurrentlyLocked((File)lockFile);
    }
}

