/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import com.aem.sgateway.common.SGPortUtil;
import com.aem.utils.StreamUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import utils.osstats.OsStats;

public class SimpleGatewayServiceStop {
    public static void forceKillMyV4Service() {
        try {
            File myPortFile = SGPortUtil.getSGPortFile(true);
            int sport = SGPortUtil.getSgPortFromFile(myPortFile, true);
            OsStats.getOsStats().killProcessListeningOn(sport, true, true);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void forceKillAllV4Services() {
        try {
            File[] portFiles;
            for (File myPortFile : portFiles = SGPortUtil.getSGPortFiles(true)) {
                int sport = SGPortUtil.getSgPortFromFile(myPortFile, true);
                OsStats.getOsStats().killProcessListeningOn(sport, true, true);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static int getMySGPort() {
        File myPortFile = SGPortUtil.getSGPortFile(true);
        try {
            return SGPortUtil.getSgPortFromFile(myPortFile, true);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static void stopJustMyService(boolean v4Installation, boolean returnImmediately) {
        File myPortFile = SGPortUtil.getSGPortFile(v4Installation);
        SimpleGatewayServiceStop.terminateService(myPortFile, v4Installation, returnImmediately);
    }

    public static void stopService(boolean v4Installation, boolean returnImmediately) {
        File[] sgPortFiles = SGPortUtil.getSGPortFiles(v4Installation);
        System.out.println("[SimpleGatewayServiceStop] Found " + sgPortFiles.length + " port files");
        for (int i = 0; i < sgPortFiles.length; ++i) {
            File portFile = sgPortFiles[i];
            SimpleGatewayServiceStop.terminateService(portFile, v4Installation, returnImmediately);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void terminateService(File portFile, boolean v4Installation, boolean returnImmediately) {
        String id = SGPortUtil.getSgPortFileUsername(portFile);
        System.out.println("[SimpleGatewayServiceStop] SGPort user is '" + id + "'");
        try {
            int sport = SGPortUtil.getSgPortFromFile(portFile, v4Installation);
            if (sport == -1) {
                System.out.println("[SimpleGatewayServiceStop] (" + id + ") SimpleGatewayService is not running");
                return;
            }
            System.out.println("[SimpleGatewayServiceStop] (" + id + ") Requesting service shutdown (" + sport + ")");
            Socket sock = new Socket("localhost", sport);
            try {
                try {
                    sock.setSoTimeout(180000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OutputStream out = sock.getOutputStream();
                InputStream in = sock.getInputStream();
                StreamUtils.writeStringISO88591(out, "SimpleGatewayService:Shutdown");
                out.flush();
                String response = StreamUtils.readNStringISO88591(in, 10000);
                if (response.equalsIgnoreCase("SimpleGatewayService:OK")) {
                    System.out.println("[SimpleGatewayServiceStop] (" + id + ") SimpleGatewayService shutdown OK");
                    String osname = System.getProperty("os.name");
                    if (osname != null && osname.toLowerCase().indexOf("win") != -1 && !returnImmediately) {
                        System.out.println("PLEASE NOTE: if SimpleGateway is installed as a Windows service it will automatically restart.  If you want to shut it down for good you should do this through the Services control panel (Control Panel / Admin Tools)");
                        Thread.sleep(4000L);
                    }
                } else {
                    System.out.println("Unexpected response from SimpleGatewayService - [" + response + "] (" + id + ")");
                }
            }
            finally {
                try {
                    System.out.println("[SimpleGatewayServiceStop] Performing socket close");
                    sock.close();
                    System.out.println("[SimpleGatewayServiceStop] Socket cleanup complete");
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("[SimpleGatewayServiceStop] (" + id + ") SimpleGatewayService is not running");
        }
    }

    public static void main(String[] args) throws Exception {
        SimpleGatewayServiceStop.stopService(true, false);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }
}

