/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util.sound;

import com.aem.CentralDebugging;
import com.aem.sdesktop.interfaces.ProxiedSoundListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.UnsupportedAudioFileException;
import utils.files.FileUtil;
import utils.sound.SoundConfiguration;
import utils.sound.encoders.pcm.PCMPlayer;
import utils.sound.util.ByteArrayQueue;

public class PCMSoundPlayerListener
implements ProxiedSoundListener {
    private PCMPlayer player;
    private ByteArrayQueue encodedQueue = new ByteArrayQueue();
    private int MAX_SIZE;
    private boolean warnOverflow = true;
    private long lastSoundPlayedAt = 0L;
    private static final boolean DEBUG_DUMP_TO_FILE = false;
    private BufferedOutputStream DEBUG_BOUT = null;
    private AudioFormat lastFormat;
    private Mixer lastMixer;

    public PCMSoundPlayerListener() {
        System.out.println("[PCMSoundPlayerListener] Creating sound player");
    }

    @Override
    public void die() {
        System.out.println("[PCMSoundPlayerListener] Finishing...");
        if (this.player != null) {
            this.player.finish();
            this.player = null;
        }
    }

    @Override
    public void soundBytes(byte[] dat) {
        if (CentralDebugging.PRINT_AUDIO_DEBUG) {
            System.out.println("[PCMSoundPlayerListener] AudioPlayer asked to play " + dat.length + " bytes of data");
        }
        if (this.encodedQueue.length() < this.MAX_SIZE) {
            this.warnOverflow = true;
            this.encodedQueue.add(dat);
        } else {
            if (this.warnOverflow) {
                System.out.println("[PCMSoundPlayerListener] WARNING: Discarded audio...");
            }
            this.warnOverflow = false;
        }
    }

    @Override
    public void setFormat(AudioFormat format) {
        this.lastFormat = format;
        this.restartPlayer(this.lastFormat, this.lastMixer);
    }

    public void restartPlayer(AudioFormat format, Mixer mixer) {
        if (format == null) {
            return;
        }
        if (this.player != null) {
            this.player.finish();
        }
        int bufferSize = SoundConfiguration.getBufferSize(format);
        this.MAX_SIZE = bufferSize * 50 * 5;
        this.encodedQueue.setCapacity(this.MAX_SIZE);
        this.encodedQueue.clear();
        this.player = new PCMPlayer(this.encodedQueue.getInputStream(), bufferSize, format, true, mixer);
    }

    @Override
    public void setMixerToUse(Mixer mixer) {
        this.lastMixer = mixer;
        this.restartPlayer(this.lastFormat, this.lastMixer);
    }

    public static void main(String[] args) throws IOException, InterruptedException, UnsupportedAudioFileException {
        AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
        File wav = new File("aah.wav");
        PCMSoundPlayerListener player = new PCMSoundPlayerListener();
        player.setFormat(format);
        byte[] dat = FileUtil.readFile((File)wav);
        Random r = new Random();
        int step = 1760;
        while (true) {
            int size = r.nextInt(dat.length / 4) * 4;
            byte[] stepBuffer = new byte[size];
            System.arraycopy(dat, 0, stepBuffer, 0, size);
            player.soundBytes(stepBuffer);
            Thread.sleep(5000L);
        }
    }
}

