/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import java.util.Comparator;
import utils.files.RemoteFile;
import utils.ostools.OS;
import utils.swing.simplelist.wrapper.filter.FilterWrapper;

public class FileEntry
implements Comparable,
FilterWrapper.Filterable {
    public String name;
    public long size;
    public long lastmod;
    public boolean folder;
    public boolean isHidden;
    public boolean isRoot;
    public RemoteFile parentFile;
    public String alias;
    public static final Comparator<FileEntry> FILE_ENTRY_WINDOWS = new Comparator<FileEntry>(){

        @Override
        public int compare(FileEntry o1, FileEntry o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.folder && o2.folder || !o1.folder && !o2.folder) {
                return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
            }
            if (o1.folder) {
                return -1;
            }
            return 1;
        }
    };
    public static final Comparator<FileEntry> FILE_ENTRY_OTHER = new Comparator<FileEntry>(){

        @Override
        public int compare(FileEntry o1, FileEntry o2) {
            return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
        }
    };

    public FileEntry(String name, long size, long lastmod, boolean folder, boolean isHidden, boolean isRoot, RemoteFile parentFile) {
        this(name, size, lastmod, folder, isHidden, isRoot, parentFile, name);
    }

    public FileEntry(String name, long size, long lastmod, boolean folder, boolean isHidden, boolean isRoot, RemoteFile parentFile, String alias) {
        this.name = name;
        this.size = size;
        this.lastmod = lastmod;
        this.folder = folder;
        this.isHidden = isHidden;
        this.isRoot = isRoot;
        this.parentFile = parentFile;
        this.alias = alias;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileEntry)) {
            return false;
        }
        FileEntry fe = (FileEntry)o;
        return this.name.equals(fe.name) && this.size == fe.size && this.lastmod == fe.lastmod && this.folder == fe.folder && this.isHidden == fe.isHidden && this.isRoot == fe.isRoot;
    }

    public String toString() {
        return this.name + " size=" + this.size + " lastmod=" + this.lastmod + " folder=" + this.folder + " isHidden=" + this.isHidden + " isRoot=" + this.isRoot;
    }

    public int compareTo(Object o) {
        if (o instanceof FileEntry) {
            return FileEntry.getOSDependentComparator().compare(this, (FileEntry)o);
        }
        return this.toString().compareTo(o.toString());
    }

    @Override
    public String getFilterString() {
        return this.name;
    }

    public static final Comparator<FileEntry> getOSDependentComparator() {
        if (OS.isWindows() || OS.isLinux()) {
            return FILE_ENTRY_WINDOWS;
        }
        return FILE_ENTRY_OTHER;
    }
}

